/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http;

import com.alibaba.nacos.common.http.BaseHttpClient;
import com.alibaba.nacos.common.http.handler.RequestHandler;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.utils.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;

public enum BaseHttpMethod {
    GET("GET"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpGet(url);
        }
    }
    ,
    GET_LARGE("GET-LARGE"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new BaseHttpClient.HttpGetWithEntity(url);
        }
    }
    ,
    POST("POST"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpPost(url);
        }
    }
    ,
    PUT("PUT"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpPut(url);
        }
    }
    ,
    DELETE("DELETE"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpDelete(url);
        }
    }
    ,
    HEAD("HEAD"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpHead(url);
        }
    }
    ,
    TRACE("TRACE"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpTrace(url);
        }
    }
    ,
    PATCH("PATCH"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpPatch(url);
        }
    }
    ,
    OPTIONS("OPTIONS"){

        @Override
        protected HttpRequestBase createRequest(String url) {
            return new HttpTrace(url);
        }
    };

    private String name;
    private HttpRequest requestBase;

    private BaseHttpMethod(String name) {
        this.name = name;
    }

    public void init(String url) {
        this.requestBase = this.createRequest(url);
    }

    protected HttpRequestBase createRequest(String url) {
        throw new UnsupportedOperationException();
    }

    public void initHeader(Header header) {
        Iterator<Map.Entry<String, String>> iterator = header.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            this.requestBase.setHeader(entry.getKey(), entry.getValue());
        }
    }

    public void initEntity(Object body, String mediaType) throws Exception {
        if (body == null) {
            return;
        }
        if (this.requestBase instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)this.requestBase;
            ContentType contentType = ContentType.create((String)mediaType);
            StringEntity entity = new StringEntity(RequestHandler.parse(body), contentType);
            request.setEntity((HttpEntity)entity);
        }
    }

    public void initFromEntity(Map<String, String> body, String charset) throws Exception {
        if (body == null || body.isEmpty()) {
            return;
        }
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(body.size());
        for (Map.Entry<String, String> entry : body.entrySet()) {
            params.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        if (this.requestBase instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest request = (HttpEntityEnclosingRequest)this.requestBase;
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(params, charset);
            request.setEntity((HttpEntity)entity);
        }
    }

    public HttpRequestBase getRequestBase() {
        return (HttpRequestBase)this.requestBase;
    }

    public static BaseHttpMethod sourceOf(String name) {
        for (BaseHttpMethod method : BaseHttpMethod.values()) {
            if (!StringUtils.equalsIgnoreCase(name, method.name)) continue;
            return method;
        }
        throw new IllegalArgumentException("Unsupported http method : " + name);
    }
}

