/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.client;

import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.common.http.client.HttpClientRequest;
import com.alibaba.nacos.common.http.client.HttpClientResponse;
import com.alibaba.nacos.common.http.handler.ResponseHandler;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.http.param.Query;
import com.alibaba.nacos.common.model.RequestHttpEntity;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosRestTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(NacosRestTemplate.class);
    private HttpClientRequest requestClient;

    public NacosRestTemplate(HttpClientRequest requestClient) {
        this.requestClient = requestClient;
    }

    public <T> HttpRestResult<T> get(String url, Header header, Query query, Type responseType) throws Exception {
        return this.execute(url, "GET", new RequestHttpEntity(header, query), responseType);
    }

    public <T> HttpRestResult<T> get(String url, Header header, Map<String, String> paramValues, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header, Query.newInstance().initParams(paramValues));
        return this.execute(url, "GET", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> getLarge(String url, Header header, Query query, Object body, Type responseType) throws Exception {
        return this.execute(url, "GET-LARGE", new RequestHttpEntity(header, query, body), responseType);
    }

    public <T> HttpRestResult<T> delete(String url, Header header, Query query, Type responseType) throws Exception {
        return this.execute(url, "DELETE", new RequestHttpEntity(header, query), responseType);
    }

    public <T> HttpRestResult<T> put(String url, Header header, Query query, Object body, Type responseType) throws Exception {
        return this.execute(url, "PUT", new RequestHttpEntity(header, query, body), responseType);
    }

    public <T> HttpRestResult<T> putJson(String url, Header header, Map<String, String> paramValues, String body, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/json"), Query.newInstance().initParams(paramValues), body);
        return this.execute(url, "PUT", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> putForm(String url, Header header, Query query, Map<String, String> bodyValues, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/x-www-form-urlencoded"), query, bodyValues);
        return this.execute(url, "PUT", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> putForm(String url, Header header, Map<String, String> paramValues, Map<String, String> bodyValues, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/x-www-form-urlencoded"), Query.newInstance().initParams(paramValues), bodyValues);
        return this.execute(url, "PUT", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> post(String url, Header header, Query query, Object body, Type responseType) throws Exception {
        return this.execute(url, "POST", new RequestHttpEntity(header, query, body), responseType);
    }

    public <T> HttpRestResult<T> postJson(String url, Header header, Map<String, String> paramValues, String body, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/json"), Query.newInstance().initParams(paramValues), body);
        return this.execute(url, "POST", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> postForm(String url, Header header, Query query, Map<String, String> bodyValues, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/x-www-form-urlencoded"), query, bodyValues);
        return this.execute(url, "POST", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> postForm(String url, Header header, Map<String, String> paramValues, Map<String, String> bodyValues, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/x-www-form-urlencoded"), Query.newInstance().initParams(paramValues), bodyValues);
        return this.execute(url, "POST", requestHttpEntity, responseType);
    }

    public <T> HttpRestResult<T> exchangeForm(String url, Header header, Map<String, String> paramValues, Map<String, String> bodyValues, String httpMethod, Type responseType) throws Exception {
        RequestHttpEntity requestHttpEntity = new RequestHttpEntity(header.setContentType("application/x-www-form-urlencoded"), Query.newInstance().initParams(paramValues), bodyValues);
        return this.execute(url, httpMethod, requestHttpEntity, responseType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> HttpRestResult<T> execute(String url, String httpMethod, RequestHttpEntity requestEntity, Type responseType) throws Exception {
        URI uri = HttpUtils.buildUri(url, requestEntity.getQuery());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("HTTP " + httpMethod + " " + url);
        }
        HttpClientResponse response = null;
        try {
            response = this.requestClient.execute(uri, httpMethod, requestEntity);
            HttpRestResult httpRestResult = ResponseHandler.responseEntityExtractor(response, responseType);
            return httpRestResult;
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public void close() throws Exception {
        this.requestClient.close();
    }
}

