/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.http.handler;

import com.alibaba.nacos.api.exception.runtime.NacosDeserializationException;
import com.alibaba.nacos.common.http.HttpRestResult;
import com.alibaba.nacos.common.http.client.HttpClientResponse;
import com.alibaba.nacos.common.http.param.Header;
import com.alibaba.nacos.common.model.RestResult;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseHandler.class);

    public static <T> T convert(String s, Class<T> cls) throws Exception {
        return JacksonUtils.toObj(s, cls);
    }

    public static <T> T convert(String s, Type type) throws Exception {
        return JacksonUtils.toObj(s, type);
    }

    public static <T> T convert(InputStream inputStream, Type type) throws Exception {
        return JacksonUtils.toObj(inputStream, type);
    }

    private static <T> HttpRestResult<T> convert(RestResult<T> restResult) {
        HttpRestResult<T> httpRestResult = new HttpRestResult<T>();
        httpRestResult.setCode(restResult.getCode());
        httpRestResult.setData(restResult.getData());
        httpRestResult.setMessage(restResult.getMessage());
        return httpRestResult;
    }

    public static <T> HttpRestResult<T> responseEntityExtractor(HttpClientResponse response, Type type) throws Exception {
        Header headers = response.getHeaders();
        String contentType = headers.getValue("Content-Type");
        InputStream body = response.getBody();
        String extractBody = null;
        boolean typeToStr = String.class.toString().equals(type.toString());
        if (contentType != null && contentType.startsWith("application/json") && 200 == response.getStatusCode()) {
            extractBody = typeToStr ? IoUtils.toString(body, headers.getCharset()) : ResponseHandler.convert(body, type);
        }
        if (extractBody == null) {
            if (!typeToStr) {
                LOGGER.error("if the response contentType is not [application/json], only support to java.lang.String");
                throw new NacosDeserializationException(type);
            }
            extractBody = IoUtils.toString(body, headers.getCharset());
        }
        if (extractBody instanceof RestResult) {
            HttpRestResult<T> httpRestResult = ResponseHandler.convert((RestResult)((Object)extractBody));
            httpRestResult.setHeader(headers);
            return httpRestResult;
        }
        return new HttpRestResult<String>(response.getHeaders(), response.getStatusCode(), extractBody);
    }
}

