/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.annotation.config;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.alibaba.nacos.spring.context.event.config.NacosConfigReceivedEvent;
import com.alibaba.nacos.spring.util.NacosUtils;
import com.alibaba.spring.beans.factory.annotation.AnnotationInjectedBeanPostProcessor;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ReflectionUtils;

public class NacosValueAnnotationBeanPostProcessor
extends AnnotationInjectedBeanPostProcessor<NacosValue>
implements BeanFactoryAware,
ApplicationListener<NacosConfigReceivedEvent> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String BEAN_NAME = "nacosValueAnnotationBeanPostProcessor";
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private static final String VALUE_SEPARATOR = ":";
    private Map<String, List<NacosValueTarget>> placeholderNacosValueTargetMap = new HashMap<String, List<NacosValueTarget>>();
    private ConfigurableListableBeanFactory beanFactory;

    protected Object doGetInjectedBean(NacosValue annotation, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) {
        String annotationValue = annotation.value();
        String value = this.beanFactory.resolveEmbeddedValue(annotationValue);
        Member member = injectedElement.getMember();
        if (member instanceof Field) {
            return this.convertIfNecessary((Field)member, (Object)value);
        }
        if (member instanceof Method) {
            return this.convertIfNecessary((Method)member, (Object)value);
        }
        return null;
    }

    protected String buildInjectedObjectCacheKey(NacosValue annotation, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) {
        return bean.getClass().getName() + annotation;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("NacosValueAnnotationBeanPostProcessor requires a ConfigurableListableBeanFactory");
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.doWithFields(bean, beanName);
        this.doWithMethods(bean, beanName);
        return super.postProcessBeforeInitialization(bean, beanName);
    }

    public void onApplicationEvent(NacosConfigReceivedEvent event) {
        String content = event.getContent();
        if (content != null) {
            Properties configProperties = NacosUtils.toProperties(content);
            for (Object key : configProperties.keySet()) {
                String propertyKey = (String)key;
                List<NacosValueTarget> beanPropertyList = this.placeholderNacosValueTargetMap.get(propertyKey);
                if (beanPropertyList == null) continue;
                String propertyValue = configProperties.getProperty(propertyKey);
                for (NacosValueTarget nacosValueTarget : beanPropertyList) {
                    if (nacosValueTarget.method == null) {
                        this.setField(nacosValueTarget, propertyValue);
                        continue;
                    }
                    this.setMethod(nacosValueTarget, propertyValue);
                }
            }
        }
    }

    private Object convertIfNecessary(Field field, Object value) {
        TypeConverter converter = this.beanFactory.getTypeConverter();
        return converter.convertIfNecessary(value, field.getType(), field);
    }

    private Object convertIfNecessary(Method method, Object value) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] arguments = new Object[paramTypes.length];
        TypeConverter converter = this.beanFactory.getTypeConverter();
        if (arguments.length == 1) {
            return converter.convertIfNecessary(value, paramTypes[0], new MethodParameter(method, 0));
        }
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = converter.convertIfNecessary(value, paramTypes[i], new MethodParameter(method, i));
        }
        return arguments;
    }

    private void doWithFields(final Object bean, final String beanName) {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException {
                NacosValue annotation = (NacosValue)AnnotationUtils.getAnnotation((AnnotatedElement)field, NacosValue.class);
                NacosValueAnnotationBeanPostProcessor.this.doWithAnnotation(beanName, bean, annotation, field.getModifiers(), null, field);
            }
        });
    }

    private void doWithMethods(final Object bean, final String beanName) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException {
                NacosValue annotation = (NacosValue)AnnotationUtils.getAnnotation((Method)method, NacosValue.class);
                NacosValueAnnotationBeanPostProcessor.this.doWithAnnotation(beanName, bean, annotation, method.getModifiers(), method, null);
            }
        });
    }

    private void doWithAnnotation(String beanName, Object bean, NacosValue annotation, int modifiers, Method method, Field field) {
        if (annotation != null) {
            if (Modifier.isStatic(modifiers)) {
                return;
            }
            if (annotation.autoRefreshed()) {
                String placeholder = this.resolvePlaceholder(annotation.value());
                if (placeholder == null) {
                    return;
                }
                NacosValueTarget nacosValueTarget = new NacosValueTarget(bean, beanName, method, field);
                this.put2ListMap(this.placeholderNacosValueTargetMap, placeholder, nacosValueTarget);
            }
        }
    }

    private String resolvePlaceholder(String placeholder) {
        int endIndex;
        if (!placeholder.startsWith(PLACEHOLDER_PREFIX)) {
            return null;
        }
        if (!placeholder.endsWith(PLACEHOLDER_SUFFIX)) {
            return null;
        }
        if (placeholder.length() <= PLACEHOLDER_PREFIX.length() + PLACEHOLDER_SUFFIX.length()) {
            return null;
        }
        int beginIndex = PLACEHOLDER_PREFIX.length();
        int separatorIndex = (placeholder = placeholder.substring(beginIndex, endIndex = placeholder.length() - PLACEHOLDER_PREFIX.length() + 1)).indexOf(VALUE_SEPARATOR);
        if (separatorIndex != -1) {
            return placeholder.substring(0, separatorIndex);
        }
        return placeholder;
    }

    private <K, V> void put2ListMap(Map<K, List<V>> map, K key, V value) {
        List<V> valueList = map.get(key);
        if (valueList == null) {
            valueList = new ArrayList<V>();
        }
        valueList.add(value);
        map.put(key, valueList);
    }

    private void setMethod(NacosValueTarget nacosValueTarget, String propertyValue) {
        block3: {
            Method method = nacosValueTarget.method;
            ReflectionUtils.makeAccessible((Method)method);
            try {
                method.invoke(nacosValueTarget.bean, this.convertIfNecessary(method, (Object)propertyValue));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Update value with {} (method) in {} (bean) with {}", new Object[]{method.getName(), nacosValueTarget.beanName, propertyValue});
                }
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error("Can't update value with " + method.getName() + " (method) in " + nacosValueTarget.beanName + " (bean)", e);
            }
        }
    }

    private void setField(NacosValueTarget nacosValueTarget, String propertyValue) {
        block3: {
            Object bean = nacosValueTarget.bean;
            Field field = nacosValueTarget.field;
            String fieldName = field.getName();
            try {
                ReflectionUtils.makeAccessible((Field)field);
                field.set(bean, this.convertIfNecessary(field, (Object)propertyValue));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Update value of the {} (field) in {} (bean) with {}", new Object[]{fieldName, nacosValueTarget.beanName, propertyValue});
                }
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error("Can't update value of the " + fieldName + " (field) in " + nacosValueTarget.beanName + " (bean)", e);
            }
        }
    }

    private static class NacosValueTarget {
        private Object bean;
        private String beanName;
        private Method method;
        private Field field;

        NacosValueTarget(Object bean, String beanName, Method method, Field field) {
            this.bean = bean;
            this.beanName = beanName;
            this.method = method;
            this.field = field;
        }
    }
}

