/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.properties.config;

import com.alibaba.nacos.api.config.annotation.NacosConfigurationProperties;
import com.alibaba.nacos.spring.context.properties.config.NacosConfigurationPropertiesBinder;
import com.alibaba.nacos.spring.factory.NacosServiceFactory;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;

public class NacosConfigurationPropertiesBindingPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    public static final String BEAN_NAME = "nacosConfigurationPropertiesBindingPostProcessor";
    private Properties globalNacosProperties;
    private NacosServiceFactory nacosServiceFactory;
    private Environment environment;
    private ApplicationEventPublisher applicationEventPublisher;
    private ConfigurableApplicationContext applicationContext;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        NacosConfigurationProperties nacosConfigurationProperties = (NacosConfigurationProperties)AnnotationUtils.findAnnotation(bean.getClass(), NacosConfigurationProperties.class);
        if (nacosConfigurationProperties != null) {
            this.bind(bean, beanName, nacosConfigurationProperties);
        }
        return bean;
    }

    private void bind(Object bean, String beanName, NacosConfigurationProperties nacosConfigurationProperties) {
        NacosConfigurationPropertiesBinder binder;
        try {
            binder = (NacosConfigurationPropertiesBinder)this.applicationContext.getBean("nacosConfigurationPropertiesBinder", NacosConfigurationPropertiesBinder.class);
            if (binder == null) {
                binder = new NacosConfigurationPropertiesBinder(this.applicationContext);
            }
        }
        catch (Exception e) {
            binder = new NacosConfigurationPropertiesBinder(this.applicationContext);
        }
        binder.bind(bean, beanName, nacosConfigurationProperties);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }
}

