/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.enums;

import com.alibaba.nacos.common.utils.StringUtils;

public enum FileTypeEnum {
    YML("yaml"),
    YAML("yaml"),
    TXT("text"),
    TEXT("text"),
    JSON("json"),
    XML("xml"),
    HTM("html"),
    HTML("html"),
    PROPERTIES("properties");

    private String fileType;
    private static final FileTypeEnum[] VALUES;

    private FileTypeEnum(String fileType) {
        this.fileType = fileType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public static FileTypeEnum getFileTypeEnumByFileExtensionOrFileType(String extOrFileType) {
        if (StringUtils.isNotBlank((String)extOrFileType)) {
            String upperExtName = extOrFileType.trim().toUpperCase();
            for (FileTypeEnum value : VALUES) {
                if (!value.name().equals(upperExtName)) continue;
                return value;
            }
        }
        return PROPERTIES;
    }

    static {
        VALUES = FileTypeEnum.values();
    }
}

