/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.client.kafka;

import com.alibaba.fastjson2.JSON;
import com.alibaba.google.common.collect.Lists;
import com.alibaba.otter.canal.client.CanalMQConnector;
import com.alibaba.otter.canal.client.kafka.MessageDeserializer;
import com.alibaba.otter.canal.protocol.FlatMessage;
import com.alibaba.otter.canal.protocol.Message;
import com.alibaba.otter.canal.protocol.exception.CanalClientException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.StringDeserializer;

public class KafkaCanalConnector
implements CanalMQConnector {
    protected KafkaConsumer<String, Message> kafkaConsumer;
    protected KafkaConsumer<String, String> kafkaConsumer2;
    protected String topic;
    protected Integer partition;
    protected Properties properties;
    protected volatile boolean connected = false;
    protected volatile boolean running = false;
    protected boolean flatMessage;
    private Map<Integer, Long> currentOffsets = new ConcurrentHashMap<Integer, Long>();

    public KafkaCanalConnector(String servers, String topic, Integer partition, String groupId, Integer batchSize, boolean flatMessage) {
        this.topic = topic;
        this.partition = partition;
        this.flatMessage = flatMessage;
        this.properties = new Properties();
        this.properties.put("bootstrap.servers", servers);
        this.properties.put("group.id", groupId);
        this.properties.put("enable.auto.commit", (Object)false);
        this.properties.put("auto.commit.interval.ms", "1000");
        this.properties.put("auto.offset.reset", "latest");
        this.properties.put("request.timeout.ms", "40000");
        this.properties.put("session.timeout.ms", "30000");
        this.properties.put("isolation.level", "read_committed");
        if (batchSize == null) {
            batchSize = 100;
        }
        this.properties.put("max.poll.records", batchSize.toString());
        this.properties.put("key.deserializer", StringDeserializer.class.getName());
        if (!flatMessage) {
            this.properties.put("value.deserializer", MessageDeserializer.class.getName());
        } else {
            this.properties.put("value.deserializer", StringDeserializer.class.getName());
        }
    }

    @Override
    public void connect() {
        if (this.connected) {
            return;
        }
        this.connected = true;
        if (this.kafkaConsumer == null && !this.flatMessage) {
            this.kafkaConsumer = new KafkaConsumer(this.properties);
        }
        if (this.kafkaConsumer2 == null && this.flatMessage) {
            this.kafkaConsumer2 = new KafkaConsumer(this.properties);
        }
    }

    @Override
    public void disconnect() {
        if (this.kafkaConsumer != null) {
            this.kafkaConsumer.close();
            this.kafkaConsumer = null;
        }
        if (this.kafkaConsumer2 != null) {
            this.kafkaConsumer2.close();
            this.kafkaConsumer2 = null;
        }
        this.connected = false;
    }

    protected void waitClientRunning() {
        this.running = true;
    }

    @Override
    public boolean checkValid() {
        return true;
    }

    @Override
    public void subscribe() {
        this.waitClientRunning();
        if (!this.running) {
            return;
        }
        if (this.partition == null) {
            if (this.kafkaConsumer != null) {
                this.kafkaConsumer.subscribe(Collections.singletonList(this.topic));
            }
            if (this.kafkaConsumer2 != null) {
                this.kafkaConsumer2.subscribe(Collections.singletonList(this.topic));
            }
        } else {
            TopicPartition topicPartition = new TopicPartition(this.topic, this.partition.intValue());
            if (this.kafkaConsumer != null) {
                this.kafkaConsumer.assign(Collections.singletonList(topicPartition));
            }
            if (this.kafkaConsumer2 != null) {
                this.kafkaConsumer2.assign(Collections.singletonList(topicPartition));
            }
        }
    }

    @Override
    public void unsubscribe() {
        this.waitClientRunning();
        if (!this.running) {
            return;
        }
        if (this.kafkaConsumer != null) {
            this.kafkaConsumer.unsubscribe();
        }
        if (this.kafkaConsumer2 != null) {
            this.kafkaConsumer2.unsubscribe();
        }
    }

    @Override
    public List<Message> getList(Long timeout, TimeUnit unit) throws CanalClientException {
        this.waitClientRunning();
        if (!this.running) {
            return Lists.newArrayList();
        }
        List<Message> messages = this.getListWithoutAck(timeout, unit);
        if (messages != null && !messages.isEmpty()) {
            this.ack();
        }
        return messages;
    }

    @Override
    public List<Message> getListWithoutAck(Long timeout, TimeUnit unit) throws CanalClientException {
        this.waitClientRunning();
        if (!this.running) {
            return Lists.newArrayList();
        }
        ConsumerRecords records = this.kafkaConsumer.poll(unit.toMillis(timeout));
        this.currentOffsets.clear();
        for (TopicPartition topicPartition : records.partitions()) {
            this.currentOffsets.put(topicPartition.partition(), this.kafkaConsumer.position(topicPartition));
        }
        if (!records.isEmpty()) {
            ArrayList<Message> messages = new ArrayList<Message>();
            for (ConsumerRecord record : records) {
                messages.add((Message)record.value());
            }
            return messages;
        }
        return Lists.newArrayList();
    }

    @Override
    public List<FlatMessage> getFlatList(Long timeout, TimeUnit unit) throws CanalClientException {
        this.waitClientRunning();
        if (!this.running) {
            return Lists.newArrayList();
        }
        List<FlatMessage> messages = this.getFlatListWithoutAck(timeout, unit);
        if (messages != null && !messages.isEmpty()) {
            this.ack();
        }
        return messages;
    }

    @Override
    public List<FlatMessage> getFlatListWithoutAck(Long timeout, TimeUnit unit) throws CanalClientException {
        this.waitClientRunning();
        if (!this.running) {
            return Lists.newArrayList();
        }
        ConsumerRecords records = this.kafkaConsumer2.poll(unit.toMillis(timeout));
        this.currentOffsets.clear();
        for (TopicPartition topicPartition : records.partitions()) {
            this.currentOffsets.put(topicPartition.partition(), this.kafkaConsumer2.position(topicPartition));
        }
        if (!records.isEmpty()) {
            ArrayList<FlatMessage> flatMessages = new ArrayList<FlatMessage>();
            for (ConsumerRecord record : records) {
                String flatMessageJson = (String)record.value();
                FlatMessage flatMessage = (FlatMessage)JSON.parseObject((String)flatMessageJson, FlatMessage.class);
                flatMessages.add(flatMessage);
            }
            return flatMessages;
        }
        return Lists.newArrayList();
    }

    @Override
    public void rollback() {
        this.waitClientRunning();
        if (!this.running) {
            return;
        }
        if (this.kafkaConsumer != null) {
            for (Map.Entry<Integer, Long> entry : this.currentOffsets.entrySet()) {
                this.kafkaConsumer.seek(new TopicPartition(this.topic, entry.getKey().intValue()), entry.getValue() - 1L);
            }
        }
        if (this.kafkaConsumer2 != null) {
            for (Map.Entry<Integer, Long> entry : this.currentOffsets.entrySet()) {
                this.kafkaConsumer2.seek(new TopicPartition(this.topic, entry.getKey().intValue()), entry.getValue() - 1L);
            }
        }
    }

    @Override
    public void ack() {
        this.waitClientRunning();
        if (!this.running) {
            return;
        }
        if (this.kafkaConsumer != null) {
            this.kafkaConsumer.commitSync();
        }
        if (this.kafkaConsumer2 != null) {
            this.kafkaConsumer2.commitSync();
        }
    }

    @Override
    public void subscribe(String filter) throws CanalClientException {
        throw new CanalClientException("mq not support this method");
    }

    @Override
    public Message get(int batchSize) throws CanalClientException {
        throw new CanalClientException("mq not support this method");
    }

    @Override
    public Message get(int batchSize, Long timeout, TimeUnit unit) throws CanalClientException {
        throw new CanalClientException("mq not support this method");
    }

    @Override
    public Message getWithoutAck(int batchSize) throws CanalClientException {
        throw new CanalClientException("mq not support this method");
    }

    @Override
    public Message getWithoutAck(int batchSize, Long timeout, TimeUnit unit) throws CanalClientException {
        throw new CanalClientException("mq not support this method");
    }

    @Override
    public void ack(long batchId) throws CanalClientException {
        throw new CanalClientException("mq not support this method");
    }

    @Override
    public void rollback(long batchId) throws CanalClientException {
        throw new CanalClientException("mq not support this method");
    }

    public void setSessionTimeout(Long timeout, TimeUnit unit) {
        long t = unit.toMillis(timeout);
        this.properties.put("request.timeout.ms", String.valueOf(t + 60000L));
        this.properties.put("session.timeout.ms", String.valueOf(t));
    }
}

