/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.common.utils;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.lang.reflect.Type;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;

public class JsonUtils {
    public static <T> T unmarshalFromByte(byte[] bytes, Class<T> targetClass) {
        return (T)JSON.parseObject((byte[])bytes, targetClass);
    }

    public static <T> T unmarshalFromByte(byte[] bytes, TypeReference<T> type) {
        return (T)JSON.parseObject((byte[])bytes, (Type)type.getType());
    }

    public static byte[] marshalToByte(Object obj) {
        return JSON.toJSONBytes((Object)obj);
    }

    public static byte[] marshalToByte(Object obj, JSONWriter.Feature ... features) {
        return JSON.toJSONBytes((Object)obj, (JSONWriter.Feature[])features);
    }

    public static <T> T unmarshalFromString(String json, Class<T> targetClass) {
        return (T)JSON.parseObject((String)json, targetClass);
    }

    public static <T> T unmarshalFromString(String json, TypeReference<T> type) {
        return (T)JSON.parseObject((String)json, type, (JSONReader.Feature[])new JSONReader.Feature[0]);
    }

    public static String marshalToString(Object obj) {
        return JSON.toJSONString((Object)obj);
    }

    public static String marshalToString(Object obj, JSONWriter.Feature ... features) {
        return JSON.toJSONString((Object)obj, (JSONWriter.Feature[])features);
    }

    public static String marshalToString(Object obj, String ... fliterFields) {
        final List<String> propertyFliters = Arrays.asList(fliterFields);
        return JSON.toJSONString((Object)obj, (Filter)new PropertyFilter(){

            public boolean process(Object object, String name, Object value) {
                return !propertyFliters.contains(name);
            }
        }, (JSONWriter.Feature[])new JSONWriter.Feature[0]);
    }

    static {
        JSON.register(InetAddress.class, (ObjectWriter)InetAddressWriter.instance);
        JSON.register(Inet4Address.class, (ObjectWriter)InetAddressWriter.instance);
        JSON.register(Inet6Address.class, (ObjectWriter)InetAddressWriter.instance);
        JSONFactory.getDefaultObjectReaderProvider().addAutoTypeAccept("com.alibaba.otter.");
        JSONFactory.getDefaultObjectReaderProvider().addAutoTypeAccept("com.taobao.tddl.dbsync.");
    }

    public static class InetAddressWriter
    implements ObjectWriter {
        public static InetAddressWriter instance = new InetAddressWriter();

        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            if (object == null) {
                jsonWriter.writeNull();
                return;
            }
            InetAddress address = (InetAddress)object;
            jsonWriter.writeString(address.getHostName());
        }
    }
}

