/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.anno.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.asm.Type;

public class ClassUtil {
    private static ConcurrentHashMap<Method, String> methodSigMap = new ConcurrentHashMap();

    public static String getShortClassName(String className) {
        if (className == null) {
            return null;
        }
        String[] ss = className.split("\\.");
        StringBuilder sb = new StringBuilder(className.length());
        for (int i = 0; i < ss.length; ++i) {
            String s = ss[i];
            if (i != ss.length - 1) {
                sb.append(s.charAt(0)).append('.');
                continue;
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static Class<?>[] getAllInterfaces(Object obj) {
        Class<?> c = obj.getClass();
        HashSet s = new HashSet();
        do {
            Class<?>[] its = c.getInterfaces();
            Collections.addAll(s, its);
        } while ((c = c.getSuperclass()) != null);
        return s.toArray(new Class[s.size()]);
    }

    private static void getMethodSig(StringBuilder sb, Method m) {
        sb.append(m.getName());
        sb.append(Type.getType((Method)m).getDescriptor());
    }

    public static String getMethodSig(Method m) {
        String sig = methodSigMap.get(m);
        if (sig != null) {
            return sig;
        }
        StringBuilder sb = new StringBuilder();
        ClassUtil.getMethodSig(sb, m);
        sig = sb.toString();
        methodSigMap.put(m, sig);
        return sig;
    }
}

