/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.autoconfigure;

import com.alicp.jetcache.autoconfigure.AutoConfigureBeans;
import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.reactive.RedisClusterReactiveCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;

public class LettuceFactory
implements FactoryBean {
    @Autowired
    private AutoConfigureBeans autoConfigureBeans;
    private boolean inited;
    private Object obj;
    private Class<?> clazz;
    private String key;

    LettuceFactory(AutoConfigureBeans autoConfigureBeans, String key, Class<?> clazz) {
        this(key, clazz);
        this.autoConfigureBeans = autoConfigureBeans;
    }

    public LettuceFactory(String key, Class<?> clazz) {
        this.clazz = clazz;
        if (AbstractRedisClient.class.isAssignableFrom(clazz)) {
            key = key + ".client";
        } else if (StatefulConnection.class.isAssignableFrom(clazz)) {
            key = key + ".connection";
        } else if (RedisClusterCommands.class.isAssignableFrom(clazz)) {
            key = key + ".commands";
        } else if (RedisClusterAsyncCommands.class.isAssignableFrom(clazz)) {
            key = key + ".asyncCommands";
        } else if (RedisClusterReactiveCommands.class.isAssignableFrom(clazz)) {
            key = key + ".reactiveCommands";
        } else {
            throw new IllegalArgumentException(clazz.getName());
        }
        this.key = key;
    }

    private void init() {
        if (!this.inited) {
            this.obj = this.autoConfigureBeans.getCustomContainer().get(this.key);
            this.inited = true;
        }
    }

    public Object getObject() throws Exception {
        this.init();
        return this.obj;
    }

    public Class<?> getObjectType() {
        return this.clazz;
    }

    public boolean isSingleton() {
        return true;
    }
}

