/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache;

import com.alicp.jetcache.CacheResultCode;
import com.alicp.jetcache.ResultData;
import com.alicp.jetcache.anno.CacheConsts;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CacheResult {
    public static final String MSG_ILLEGAL_ARGUMENT = "illegal argument";
    private static Duration DEFAULT_TIMEOUT = CacheConsts.ASYNC_RESULT_TIMEOUT;
    public static final CacheResult SUCCESS_WITHOUT_MSG = new CacheResult(CacheResultCode.SUCCESS, null);
    public static final CacheResult PART_SUCCESS_WITHOUT_MSG = new CacheResult(CacheResultCode.PART_SUCCESS, null);
    public static final CacheResult FAIL_WITHOUT_MSG = new CacheResult(CacheResultCode.FAIL, null);
    public static final CacheResult FAIL_ILLEGAL_ARGUMENT = new CacheResult(CacheResultCode.FAIL, "illegal argument");
    public static final CacheResult EXISTS_WITHOUT_MSG = new CacheResult(CacheResultCode.EXISTS, null);
    private CacheResultCode resultCode;
    private String message;
    private CompletionStage<ResultData> future;
    private Duration timeout = DEFAULT_TIMEOUT;

    public CacheResult(CompletionStage<ResultData> future) {
        this.future = future;
    }

    public CacheResult(CacheResultCode resultCode, String message) {
        this(CompletableFuture.completedFuture(new ResultData(resultCode, message, null)));
    }

    public CacheResult(Throwable ex) {
        this.future = CompletableFuture.completedFuture(new ResultData(ex));
    }

    public boolean isSuccess() {
        return this.getResultCode() == CacheResultCode.SUCCESS;
    }

    protected void waitForResult() {
        this.waitForResult(this.timeout);
    }

    public void waitForResult(Duration timeout) {
        if (this.resultCode != null) {
            return;
        }
        try {
            ResultData resultData = this.future.toCompletableFuture().get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            this.fetchResultSuccess(resultData);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            this.fetchResultFail(e);
        }
    }

    protected void fetchResultSuccess(ResultData resultData) {
        this.resultCode = resultData.getResultCode();
        this.message = resultData.getMessage();
    }

    protected void fetchResultFail(Throwable e) {
        this.resultCode = CacheResultCode.FAIL;
        this.message = e.getClass() + ":" + e.getMessage();
    }

    public CacheResultCode getResultCode() {
        this.waitForResult();
        return this.resultCode;
    }

    public String getMessage() {
        this.waitForResult();
        return this.message;
    }

    public CompletionStage<ResultData> future() {
        return this.future;
    }

    public static void setDefaultTimeout(Duration defaultTimeout) {
        DEFAULT_TIMEOUT = defaultTimeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }
}

