/*
 * Decompiled with CFR 0.152.
 */
package com.alicp.jetcache.support;

import com.alicp.jetcache.CacheValueHolder;
import com.alicp.jetcache.support.AbstractValueDecoder;
import com.alicp.jetcache.support.CacheMessage;
import java.nio.charset.StandardCharsets;

public abstract class AbstractJsonDecoder
extends AbstractValueDecoder {
    public AbstractJsonDecoder(boolean useIdentityNumber) {
        super(useIdentityNumber);
    }

    @Override
    protected Object doApply(byte[] buffer) throws Exception {
        int[] indexHolder = new int[]{this.isUseIdentityNumber() ? 4 : 0};
        short objCount = this.readShort(buffer, indexHolder[0]);
        indexHolder[0] = indexHolder[0] + 2;
        if (objCount < 0) {
            return null;
        }
        Object obj = this.readObject(buffer, indexHolder);
        if (obj == null) {
            return null;
        }
        if (obj instanceof CacheValueHolder) {
            CacheValueHolder h = (CacheValueHolder)obj;
            h.setValue(this.readObject(buffer, indexHolder));
            return h;
        }
        if (obj instanceof CacheMessage) {
            CacheMessage cm = (CacheMessage)obj;
            if (objCount > 1) {
                Object[] keys = new Object[objCount - 1];
                for (int i = 0; i < objCount - 1; ++i) {
                    keys[i] = this.readObject(buffer, indexHolder);
                }
                cm.setKeys(keys);
            }
            return cm;
        }
        return obj;
    }

    private int readInt(byte[] buf, int index) {
        int x = buf[index] & 0xFF;
        x = x << 8 | buf[index + 1] & 0xFF;
        x = x << 8 | buf[index + 2] & 0xFF;
        x = x << 8 | buf[index + 3] & 0xFF;
        return x;
    }

    private short readShort(byte[] buf, int index) {
        int x = buf[index] & 0xFF;
        x = x << 8 | buf[index + 1] & 0xFF;
        return (short)x;
    }

    private Object readObject(byte[] buf, int[] indexHolder) throws Exception {
        int index = indexHolder[0];
        short classNameLen = this.readShort(buf, index);
        index += 2;
        if (classNameLen < 0) {
            indexHolder[0] = index;
            return null;
        }
        String className = new String(buf, index, (int)classNameLen, StandardCharsets.UTF_8);
        Class<?> clazz = Class.forName(className);
        int size = this.readInt(buf, index += classNameLen);
        Object obj = this.parseObject(buf, index += 4, size, clazz);
        indexHolder[0] = index += size;
        return obj;
    }

    protected abstract Object parseObject(byte[] var1, int var2, int var3, Class var4);
}

