/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.green.extension.uploader;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.activation.MimetypesFileTypeMap;

public class CustomLibUploader {
    public String uploadFile(String host, String uploadFolder, String ossAccessKeyId, String policy, String signature, String filepath) throws Exception {
        LinkedHashMap<String, String> textMap = new LinkedHashMap<String, String>();
        String objectName = uploadFolder + "/imglib_" + UUID.randomUUID().toString() + ".jpg";
        textMap.put("key", objectName);
        textMap.put("Content-Disposition", "attachment;filename=" + filepath);
        textMap.put("OSSAccessKeyId", ossAccessKeyId);
        textMap.put("policy", policy);
        textMap.put("Signature", signature);
        HashMap<String, String> fileMap = new HashMap<String, String>();
        fileMap.put("file", filepath);
        String ret = CustomLibUploader.formUpload(host, textMap, fileMap);
        System.out.println("[" + host + "] post_object:" + objectName);
        System.out.println("post reponse:" + ret);
        return objectName;
    }

    private static String formUpload(String urlStr, Map<String, String> textMap, Map<String, String> fileMap) throws Exception {
        String res = "";
        HttpURLConnection conn = null;
        String BOUNDARY = "9431149156168";
        try {
            StringBuffer strBuf;
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(10000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.1; zh-CN; rv:1.9.2.6)");
            conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            if (textMap != null) {
                StringBuffer strBuf2 = new StringBuffer();
                Iterator<Map.Entry<String, String>> iter = textMap.entrySet().iterator();
                int i = 0;
                while (iter.hasNext()) {
                    Map.Entry<String, String> entry = iter.next();
                    String inputName = entry.getKey();
                    String inputValue = entry.getValue();
                    if (inputValue == null) continue;
                    if (i == 0) {
                        strBuf2.append("--").append(BOUNDARY).append("\r\n");
                        strBuf2.append("Content-Disposition: form-data; name=\"" + inputName + "\"\r\n\r\n");
                        strBuf2.append(inputValue);
                    } else {
                        strBuf2.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                        strBuf2.append("Content-Disposition: form-data; name=\"" + inputName + "\"\r\n\r\n");
                        strBuf2.append(inputValue);
                    }
                    ++i;
                }
                ((OutputStream)out).write(strBuf2.toString().getBytes());
            }
            if (fileMap != null) {
                for (Map.Entry<String, String> entry : fileMap.entrySet()) {
                    String inputName = entry.getKey();
                    String inputValue = entry.getValue();
                    if (inputValue == null) continue;
                    File file = new File(inputValue);
                    String filename = file.getName();
                    String contentType = new MimetypesFileTypeMap().getContentType(file);
                    if (contentType == null || contentType.equals("")) {
                        contentType = "application/octet-stream";
                    }
                    StringBuffer strBuf3 = new StringBuffer();
                    strBuf3.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                    strBuf3.append("Content-Disposition: form-data; name=\"" + inputName + "\"; filename=\"" + filename + "\"\r\n");
                    strBuf3.append("Content-Type: " + contentType + "\r\n\r\n");
                    ((OutputStream)out).write(strBuf3.toString().getBytes());
                    DataInputStream in = new DataInputStream(new FileInputStream(file));
                    int bytes = 0;
                    byte[] bufferOut = new byte[1024];
                    while ((bytes = in.read(bufferOut)) != -1) {
                        ((OutputStream)out).write(bufferOut, 0, bytes);
                    }
                    in.close();
                }
                strBuf = new StringBuffer();
                ((OutputStream)out).write(strBuf.toString().getBytes());
            }
            byte[] endData = ("\r\n--" + BOUNDARY + "--\r\n").getBytes();
            ((OutputStream)out).write(endData);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            strBuf = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                strBuf.append(line).append("\n");
            }
            res = strBuf.toString();
            reader.close();
            reader = null;
        }
        catch (Exception e) {
            System.err.println("\u53d1\u9001POST\u8bf7\u6c42\u51fa\u9519: " + urlStr);
            throw e;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
        }
        return res;
    }
}

