/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.apigateway.model.SdkType;
import java.util.List;

@SdkInternalApi
public class SdkTypeMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<String> FRIENDLYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("friendlyName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<List> CONFIGURATIONPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("configurationProperties").build();
    private static final SdkTypeMarshaller instance = new SdkTypeMarshaller();

    public static SdkTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(SdkType sdkType, ProtocolMarshaller protocolMarshaller) {
        if (sdkType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)sdkType.getId(), ID_BINDING);
            protocolMarshaller.marshall((Object)sdkType.getFriendlyName(), FRIENDLYNAME_BINDING);
            protocolMarshaller.marshall((Object)sdkType.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(sdkType.getConfigurationProperties(), CONFIGURATIONPROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

