/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.SalesforceDataTransferApi;
import com.amazonaws.services.appflow.model.transform.SalesforceMetadataMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SalesforceMetadata
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> oAuthScopes;
    private List<String> dataTransferApis;

    public List<String> getOAuthScopes() {
        return this.oAuthScopes;
    }

    public void setOAuthScopes(Collection<String> oAuthScopes) {
        if (oAuthScopes == null) {
            this.oAuthScopes = null;
            return;
        }
        this.oAuthScopes = new ArrayList<String>(oAuthScopes);
    }

    public SalesforceMetadata withOAuthScopes(String ... oAuthScopes) {
        if (this.oAuthScopes == null) {
            this.setOAuthScopes(new ArrayList<String>(oAuthScopes.length));
        }
        for (String ele : oAuthScopes) {
            this.oAuthScopes.add(ele);
        }
        return this;
    }

    public SalesforceMetadata withOAuthScopes(Collection<String> oAuthScopes) {
        this.setOAuthScopes(oAuthScopes);
        return this;
    }

    public List<String> getDataTransferApis() {
        return this.dataTransferApis;
    }

    public void setDataTransferApis(Collection<String> dataTransferApis) {
        if (dataTransferApis == null) {
            this.dataTransferApis = null;
            return;
        }
        this.dataTransferApis = new ArrayList<String>(dataTransferApis);
    }

    public SalesforceMetadata withDataTransferApis(String ... dataTransferApis) {
        if (this.dataTransferApis == null) {
            this.setDataTransferApis(new ArrayList<String>(dataTransferApis.length));
        }
        for (String ele : dataTransferApis) {
            this.dataTransferApis.add(ele);
        }
        return this;
    }

    public SalesforceMetadata withDataTransferApis(Collection<String> dataTransferApis) {
        this.setDataTransferApis(dataTransferApis);
        return this;
    }

    public SalesforceMetadata withDataTransferApis(SalesforceDataTransferApi ... dataTransferApis) {
        ArrayList<String> dataTransferApisCopy = new ArrayList<String>(dataTransferApis.length);
        for (SalesforceDataTransferApi value : dataTransferApis) {
            dataTransferApisCopy.add(value.toString());
        }
        if (this.getDataTransferApis() == null) {
            this.setDataTransferApis(dataTransferApisCopy);
        } else {
            this.getDataTransferApis().addAll(dataTransferApisCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOAuthScopes() != null) {
            sb.append("OAuthScopes: ").append(this.getOAuthScopes()).append(",");
        }
        if (this.getDataTransferApis() != null) {
            sb.append("DataTransferApis: ").append(this.getDataTransferApis());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceMetadata)) {
            return false;
        }
        SalesforceMetadata other = (SalesforceMetadata)obj;
        if (other.getOAuthScopes() == null ^ this.getOAuthScopes() == null) {
            return false;
        }
        if (other.getOAuthScopes() != null && !other.getOAuthScopes().equals(this.getOAuthScopes())) {
            return false;
        }
        if (other.getDataTransferApis() == null ^ this.getDataTransferApis() == null) {
            return false;
        }
        return other.getDataTransferApis() == null || other.getDataTransferApis().equals(this.getDataTransferApis());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOAuthScopes() == null ? 0 : this.getOAuthScopes().hashCode());
        hashCode = 31 * hashCode + (this.getDataTransferApis() == null ? 0 : this.getDataTransferApis().hashCode());
        return hashCode;
    }

    public SalesforceMetadata clone() {
        try {
            return (SalesforceMetadata)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SalesforceMetadataMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

