/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.ExecutionResult;

@SdkInternalApi
public class ExecutionResultMarshaller {
    private static final MarshallingInfo<StructuredPojo> ERRORINFO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorInfo").build();
    private static final MarshallingInfo<Long> BYTESPROCESSED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bytesProcessed").build();
    private static final MarshallingInfo<Long> BYTESWRITTEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bytesWritten").build();
    private static final MarshallingInfo<Long> RECORDSPROCESSED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("recordsProcessed").build();
    private static final ExecutionResultMarshaller instance = new ExecutionResultMarshaller();

    public static ExecutionResultMarshaller getInstance() {
        return instance;
    }

    public void marshall(ExecutionResult executionResult, ProtocolMarshaller protocolMarshaller) {
        if (executionResult == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)executionResult.getErrorInfo(), ERRORINFO_BINDING);
            protocolMarshaller.marshall((Object)executionResult.getBytesProcessed(), BYTESPROCESSED_BINDING);
            protocolMarshaller.marshall((Object)executionResult.getBytesWritten(), BYTESWRITTEN_BINDING);
            protocolMarshaller.marshall((Object)executionResult.getRecordsProcessed(), RECORDSPROCESSED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

