/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appsync.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appsync.model.transform.CachingConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CachingConfig
implements Serializable,
Cloneable,
StructuredPojo {
    private Long ttl;
    private List<String> cachingKeys;

    public void setTtl(Long ttl) {
        this.ttl = ttl;
    }

    public Long getTtl() {
        return this.ttl;
    }

    public CachingConfig withTtl(Long ttl) {
        this.setTtl(ttl);
        return this;
    }

    public List<String> getCachingKeys() {
        return this.cachingKeys;
    }

    public void setCachingKeys(Collection<String> cachingKeys) {
        if (cachingKeys == null) {
            this.cachingKeys = null;
            return;
        }
        this.cachingKeys = new ArrayList<String>(cachingKeys);
    }

    public CachingConfig withCachingKeys(String ... cachingKeys) {
        if (this.cachingKeys == null) {
            this.setCachingKeys(new ArrayList<String>(cachingKeys.length));
        }
        for (String ele : cachingKeys) {
            this.cachingKeys.add(ele);
        }
        return this;
    }

    public CachingConfig withCachingKeys(Collection<String> cachingKeys) {
        this.setCachingKeys(cachingKeys);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTtl() != null) {
            sb.append("Ttl: ").append(this.getTtl()).append(",");
        }
        if (this.getCachingKeys() != null) {
            sb.append("CachingKeys: ").append(this.getCachingKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachingConfig)) {
            return false;
        }
        CachingConfig other = (CachingConfig)obj;
        if (other.getTtl() == null ^ this.getTtl() == null) {
            return false;
        }
        if (other.getTtl() != null && !other.getTtl().equals(this.getTtl())) {
            return false;
        }
        if (other.getCachingKeys() == null ^ this.getCachingKeys() == null) {
            return false;
        }
        return other.getCachingKeys() == null || other.getCachingKeys().equals(this.getCachingKeys());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTtl() == null ? 0 : this.getTtl().hashCode());
        hashCode = 31 * hashCode + (this.getCachingKeys() == null ? 0 : this.getCachingKeys().hashCode());
        return hashCode;
    }

    public CachingConfig clone() {
        try {
            return (CachingConfig)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CachingConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

