/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront.model.GetFunctionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;

public class GetFunctionRequestMarshaller
implements Marshaller<Request<GetFunctionRequest>, GetFunctionRequest> {
    public Request<GetFunctionRequest> marshall(GetFunctionRequest getFunctionRequest) {
        if (getFunctionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getFunctionRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/2020-05-31/function/{Name}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "Name", getFunctionRequest.getName());
        request.setResourcePath(uriResourcePath);
        if (getFunctionRequest.getStage() != null) {
            request.addParameter("Stage", StringUtils.fromString((String)getFunctionRequest.getStage()));
        }
        return request;
    }
}

