/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudwatchevidently.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.cloudwatchevidently.model.S3DestinationConfig;

@SdkInternalApi
public class S3DestinationConfigMarshaller {
    private static final MarshallingInfo<String> BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bucket").build();
    private static final MarshallingInfo<String> PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("prefix").build();
    private static final S3DestinationConfigMarshaller instance = new S3DestinationConfigMarshaller();

    public static S3DestinationConfigMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3DestinationConfig s3DestinationConfig, ProtocolMarshaller protocolMarshaller) {
        if (s3DestinationConfig == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3DestinationConfig.getBucket(), BUCKET_BINDING);
            protocolMarshaller.marshall((Object)s3DestinationConfig.getPrefix(), PREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

