/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.comprehend.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.comprehend.model.Entity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectEntitiesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Entity> entities;

    public List<Entity> getEntities() {
        return this.entities;
    }

    public void setEntities(Collection<Entity> entities) {
        if (entities == null) {
            this.entities = null;
            return;
        }
        this.entities = new ArrayList<Entity>(entities);
    }

    public DetectEntitiesResult withEntities(Entity ... entities) {
        if (this.entities == null) {
            this.setEntities(new ArrayList<Entity>(entities.length));
        }
        for (Entity ele : entities) {
            this.entities.add(ele);
        }
        return this;
    }

    public DetectEntitiesResult withEntities(Collection<Entity> entities) {
        this.setEntities(entities);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEntities() != null) {
            sb.append("Entities: ").append(this.getEntities());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectEntitiesResult)) {
            return false;
        }
        DetectEntitiesResult other = (DetectEntitiesResult)obj;
        if (other.getEntities() == null ^ this.getEntities() == null) {
            return false;
        }
        return other.getEntities() == null || other.getEntities().equals(this.getEntities());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEntities() == null ? 0 : this.getEntities().hashCode());
        return hashCode;
    }

    public DetectEntitiesResult clone() {
        try {
            return (DetectEntitiesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

