/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.comprehend.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/DetectEntities" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DetectEntitiesRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * A UTF-8 text string. The maximum string size is 100 KB.
     * </p>
     */
    private String text;
    /**
     * <p>
     * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend.
     * All documents must be in the same language.
     * </p>
     * <p>
     * If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language
     * of your custom model, and it ignores any language code that you specify here.
     * </p>
     */
    private String languageCode;
    /**
     * <p>
     * The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an
     * endpoint if you want to detect entities by using your own custom model instead of the default model that is used
     * by Amazon Comprehend.
     * </p>
     * <p>
     * If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any language
     * code that you provide in your request.
     * </p>
     * <p>
     * For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     */
    private String endpointArn;

    /**
     * <p>
     * A UTF-8 text string. The maximum string size is 100 KB.
     * </p>
     * 
     * @param text
     *        A UTF-8 text string. The maximum string size is 100 KB.
     */

    public void setText(String text) {
        this.text = text;
    }

    /**
     * <p>
     * A UTF-8 text string. The maximum string size is 100 KB.
     * </p>
     * 
     * @return A UTF-8 text string. The maximum string size is 100 KB.
     */

    public String getText() {
        return this.text;
    }

    /**
     * <p>
     * A UTF-8 text string. The maximum string size is 100 KB.
     * </p>
     * 
     * @param text
     *        A UTF-8 text string. The maximum string size is 100 KB.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DetectEntitiesRequest withText(String text) {
        setText(text);
        return this;
    }

    /**
     * <p>
     * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend.
     * All documents must be in the same language.
     * </p>
     * <p>
     * If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language
     * of your custom model, and it ignores any language code that you specify here.
     * </p>
     * 
     * @param languageCode
     *        The language of the input documents. You can specify any of the primary languages supported by Amazon
     *        Comprehend. All documents must be in the same language.</p>
     *        <p>
     *        If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the
     *        language of your custom model, and it ignores any language code that you specify here.
     * @see LanguageCode
     */

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    /**
     * <p>
     * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend.
     * All documents must be in the same language.
     * </p>
     * <p>
     * If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language
     * of your custom model, and it ignores any language code that you specify here.
     * </p>
     * 
     * @return The language of the input documents. You can specify any of the primary languages supported by Amazon
     *         Comprehend. All documents must be in the same language.</p>
     *         <p>
     *         If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the
     *         language of your custom model, and it ignores any language code that you specify here.
     * @see LanguageCode
     */

    public String getLanguageCode() {
        return this.languageCode;
    }

    /**
     * <p>
     * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend.
     * All documents must be in the same language.
     * </p>
     * <p>
     * If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language
     * of your custom model, and it ignores any language code that you specify here.
     * </p>
     * 
     * @param languageCode
     *        The language of the input documents. You can specify any of the primary languages supported by Amazon
     *        Comprehend. All documents must be in the same language.</p>
     *        <p>
     *        If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the
     *        language of your custom model, and it ignores any language code that you specify here.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LanguageCode
     */

    public DetectEntitiesRequest withLanguageCode(String languageCode) {
        setLanguageCode(languageCode);
        return this;
    }

    /**
     * <p>
     * The language of the input documents. You can specify any of the primary languages supported by Amazon Comprehend.
     * All documents must be in the same language.
     * </p>
     * <p>
     * If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the language
     * of your custom model, and it ignores any language code that you specify here.
     * </p>
     * 
     * @param languageCode
     *        The language of the input documents. You can specify any of the primary languages supported by Amazon
     *        Comprehend. All documents must be in the same language.</p>
     *        <p>
     *        If your request includes the endpoint for a custom entity recognition model, Amazon Comprehend uses the
     *        language of your custom model, and it ignores any language code that you specify here.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see LanguageCode
     */

    public DetectEntitiesRequest withLanguageCode(LanguageCode languageCode) {
        this.languageCode = languageCode.toString();
        return this;
    }

    /**
     * <p>
     * The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an
     * endpoint if you want to detect entities by using your own custom model instead of the default model that is used
     * by Amazon Comprehend.
     * </p>
     * <p>
     * If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any language
     * code that you provide in your request.
     * </p>
     * <p>
     * For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     * 
     * @param endpointArn
     *        The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide
     *        an endpoint if you want to detect entities by using your own custom model instead of the default model
     *        that is used by Amazon Comprehend.</p>
     *        <p>
     *        If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any
     *        language code that you provide in your request.
     *        </p>
     *        <p>
     *        For information about endpoints, see <a
     *        href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     */

    public void setEndpointArn(String endpointArn) {
        this.endpointArn = endpointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an
     * endpoint if you want to detect entities by using your own custom model instead of the default model that is used
     * by Amazon Comprehend.
     * </p>
     * <p>
     * If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any language
     * code that you provide in your request.
     * </p>
     * <p>
     * For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     * 
     * @return The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model.
     *         Provide an endpoint if you want to detect entities by using your own custom model instead of the default
     *         model that is used by Amazon Comprehend.</p>
     *         <p>
     *         If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any
     *         language code that you provide in your request.
     *         </p>
     *         <p>
     *         For information about endpoints, see <a
     *         href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     */

    public String getEndpointArn() {
        return this.endpointArn;
    }

    /**
     * <p>
     * The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide an
     * endpoint if you want to detect entities by using your own custom model instead of the default model that is used
     * by Amazon Comprehend.
     * </p>
     * <p>
     * If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any language
     * code that you provide in your request.
     * </p>
     * <p>
     * For information about endpoints, see <a
     * href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * </p>
     * 
     * @param endpointArn
     *        The Amazon Resource Name of an endpoint that is associated with a custom entity recognition model. Provide
     *        an endpoint if you want to detect entities by using your own custom model instead of the default model
     *        that is used by Amazon Comprehend.</p>
     *        <p>
     *        If you specify an endpoint, Amazon Comprehend uses the language of your custom model, and it ignores any
     *        language code that you provide in your request.
     *        </p>
     *        <p>
     *        For information about endpoints, see <a
     *        href="https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html">Managing endpoints</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DetectEntitiesRequest withEndpointArn(String endpointArn) {
        setEndpointArn(endpointArn);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getText() != null)
            sb.append("Text: ").append("***Sensitive Data Redacted***").append(",");
        if (getLanguageCode() != null)
            sb.append("LanguageCode: ").append(getLanguageCode()).append(",");
        if (getEndpointArn() != null)
            sb.append("EndpointArn: ").append(getEndpointArn());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DetectEntitiesRequest == false)
            return false;
        DetectEntitiesRequest other = (DetectEntitiesRequest) obj;
        if (other.getText() == null ^ this.getText() == null)
            return false;
        if (other.getText() != null && other.getText().equals(this.getText()) == false)
            return false;
        if (other.getLanguageCode() == null ^ this.getLanguageCode() == null)
            return false;
        if (other.getLanguageCode() != null && other.getLanguageCode().equals(this.getLanguageCode()) == false)
            return false;
        if (other.getEndpointArn() == null ^ this.getEndpointArn() == null)
            return false;
        if (other.getEndpointArn() != null && other.getEndpointArn().equals(this.getEndpointArn()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getText() == null) ? 0 : getText().hashCode());
        hashCode = prime * hashCode + ((getLanguageCode() == null) ? 0 : getLanguageCode().hashCode());
        hashCode = prime * hashCode + ((getEndpointArn() == null) ? 0 : getEndpointArn().hashCode());
        return hashCode;
    }

    @Override
    public DetectEntitiesRequest clone() {
        return (DetectEntitiesRequest) super.clone();
    }

}
