/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.connect.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.connect.model.QuickConnectType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListQuickConnectsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String instanceId;
    private String nextToken;
    private Integer maxResults;
    private List<String> quickConnectTypes;

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ListQuickConnectsRequest withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListQuickConnectsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListQuickConnectsRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public List<String> getQuickConnectTypes() {
        return this.quickConnectTypes;
    }

    public void setQuickConnectTypes(Collection<String> quickConnectTypes) {
        if (quickConnectTypes == null) {
            this.quickConnectTypes = null;
            return;
        }
        this.quickConnectTypes = new ArrayList<String>(quickConnectTypes);
    }

    public ListQuickConnectsRequest withQuickConnectTypes(String ... quickConnectTypes) {
        if (this.quickConnectTypes == null) {
            this.setQuickConnectTypes(new ArrayList<String>(quickConnectTypes.length));
        }
        for (String ele : quickConnectTypes) {
            this.quickConnectTypes.add(ele);
        }
        return this;
    }

    public ListQuickConnectsRequest withQuickConnectTypes(Collection<String> quickConnectTypes) {
        this.setQuickConnectTypes(quickConnectTypes);
        return this;
    }

    public ListQuickConnectsRequest withQuickConnectTypes(QuickConnectType ... quickConnectTypes) {
        ArrayList<String> quickConnectTypesCopy = new ArrayList<String>(quickConnectTypes.length);
        for (QuickConnectType value : quickConnectTypes) {
            quickConnectTypesCopy.add(value.toString());
        }
        if (this.getQuickConnectTypes() == null) {
            this.setQuickConnectTypes(quickConnectTypesCopy);
        } else {
            this.getQuickConnectTypes().addAll(quickConnectTypesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getQuickConnectTypes() != null) {
            sb.append("QuickConnectTypes: ").append(this.getQuickConnectTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQuickConnectsRequest)) {
            return false;
        }
        ListQuickConnectsRequest other = (ListQuickConnectsRequest)obj;
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getQuickConnectTypes() == null ^ this.getQuickConnectTypes() == null) {
            return false;
        }
        return other.getQuickConnectTypes() == null || other.getQuickConnectTypes().equals(this.getQuickConnectTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getQuickConnectTypes() == null ? 0 : this.getQuickConnectTypes().hashCode());
        return hashCode;
    }

    public ListQuickConnectsRequest clone() {
        return (ListQuickConnectsRequest)super.clone();
    }
}

