/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.datasync.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.datasync.model.transform.Ec2ConfigMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Ec2Config
implements Serializable,
Cloneable,
StructuredPojo {
    private String subnetArn;
    private List<String> securityGroupArns;

    public void setSubnetArn(String subnetArn) {
        this.subnetArn = subnetArn;
    }

    public String getSubnetArn() {
        return this.subnetArn;
    }

    public Ec2Config withSubnetArn(String subnetArn) {
        this.setSubnetArn(subnetArn);
        return this;
    }

    public List<String> getSecurityGroupArns() {
        return this.securityGroupArns;
    }

    public void setSecurityGroupArns(Collection<String> securityGroupArns) {
        if (securityGroupArns == null) {
            this.securityGroupArns = null;
            return;
        }
        this.securityGroupArns = new ArrayList<String>(securityGroupArns);
    }

    public Ec2Config withSecurityGroupArns(String ... securityGroupArns) {
        if (this.securityGroupArns == null) {
            this.setSecurityGroupArns(new ArrayList<String>(securityGroupArns.length));
        }
        for (String ele : securityGroupArns) {
            this.securityGroupArns.add(ele);
        }
        return this;
    }

    public Ec2Config withSecurityGroupArns(Collection<String> securityGroupArns) {
        this.setSecurityGroupArns(securityGroupArns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSubnetArn() != null) {
            sb.append("SubnetArn: ").append(this.getSubnetArn()).append(",");
        }
        if (this.getSecurityGroupArns() != null) {
            sb.append("SecurityGroupArns: ").append(this.getSecurityGroupArns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2Config)) {
            return false;
        }
        Ec2Config other = (Ec2Config)obj;
        if (other.getSubnetArn() == null ^ this.getSubnetArn() == null) {
            return false;
        }
        if (other.getSubnetArn() != null && !other.getSubnetArn().equals(this.getSubnetArn())) {
            return false;
        }
        if (other.getSecurityGroupArns() == null ^ this.getSecurityGroupArns() == null) {
            return false;
        }
        return other.getSecurityGroupArns() == null || other.getSecurityGroupArns().equals(this.getSecurityGroupArns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSubnetArn() == null ? 0 : this.getSubnetArn().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroupArns() == null ? 0 : this.getSecurityGroupArns().hashCode());
        return hashCode;
    }

    public Ec2Config clone() {
        try {
            return (Ec2Config)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        Ec2ConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

