/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dlm.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.dlm.model.EventParameters;
import java.util.List;

@SdkInternalApi
public class EventParametersMarshaller {
    private static final MarshallingInfo<String> EVENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EventType").build();
    private static final MarshallingInfo<List> SNAPSHOTOWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SnapshotOwner").build();
    private static final MarshallingInfo<String> DESCRIPTIONREGEX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DescriptionRegex").build();
    private static final EventParametersMarshaller instance = new EventParametersMarshaller();

    public static EventParametersMarshaller getInstance() {
        return instance;
    }

    public void marshall(EventParameters eventParameters, ProtocolMarshaller protocolMarshaller) {
        if (eventParameters == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)eventParameters.getEventType(), EVENTTYPE_BINDING);
            protocolMarshaller.marshall(eventParameters.getSnapshotOwner(), SNAPSHOTOWNER_BINDING);
            protocolMarshaller.marshall((Object)eventParameters.getDescriptionRegex(), DESCRIPTIONREGEX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

