/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DeleteFleetsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteFleetsRequestMarshaller
implements Marshaller<Request<DeleteFleetsRequest>, DeleteFleetsRequest> {
    public Request<DeleteFleetsRequest> marshall(DeleteFleetsRequest deleteFleetsRequest) {
        if (deleteFleetsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteFleetsRequest, "AmazonEC2");
        request.addParameter("Action", "DeleteFleets");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList deleteFleetsRequestFleetIdsList = (SdkInternalList)deleteFleetsRequest.getFleetIds();
        if (!deleteFleetsRequestFleetIdsList.isEmpty() || !deleteFleetsRequestFleetIdsList.isAutoConstruct()) {
            int fleetIdsListIndex = 1;
            for (String deleteFleetsRequestFleetIdsListValue : deleteFleetsRequestFleetIdsList) {
                if (deleteFleetsRequestFleetIdsListValue != null) {
                    request.addParameter("FleetId." + fleetIdsListIndex, StringUtils.fromString((String)deleteFleetsRequestFleetIdsListValue));
                }
                ++fleetIdsListIndex;
            }
        }
        if (deleteFleetsRequest.getTerminateInstances() != null) {
            request.addParameter("TerminateInstances", StringUtils.fromBoolean((Boolean)deleteFleetsRequest.getTerminateInstances()));
        }
        return request;
    }
}

