/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.NetworkCardInfo;
import com.amazonaws.services.ec2.model.NetworkInfo;
import com.amazonaws.services.ec2.model.transform.NetworkCardInfoStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class NetworkInfoStaxUnmarshaller
implements Unmarshaller<NetworkInfo, StaxUnmarshallerContext> {
    private static NetworkInfoStaxUnmarshaller instance;

    public NetworkInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        NetworkInfo networkInfo = new NetworkInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return networkInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("networkPerformance", targetDepth)) {
                    networkInfo.setNetworkPerformance(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("maximumNetworkInterfaces", targetDepth)) {
                    networkInfo.setMaximumNetworkInterfaces(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("maximumNetworkCards", targetDepth)) {
                    networkInfo.setMaximumNetworkCards(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("defaultNetworkCardIndex", targetDepth)) {
                    networkInfo.setDefaultNetworkCardIndex(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("networkCards", targetDepth)) {
                    networkInfo.withNetworkCards(new ArrayList<NetworkCardInfo>());
                    continue;
                }
                if (context.testExpression("networkCards/item", targetDepth)) {
                    networkInfo.withNetworkCards(NetworkCardInfoStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipv4AddressesPerInterface", targetDepth)) {
                    networkInfo.setIpv4AddressesPerInterface(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipv6AddressesPerInterface", targetDepth)) {
                    networkInfo.setIpv6AddressesPerInterface(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ipv6Supported", targetDepth)) {
                    networkInfo.setIpv6Supported(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("enaSupport", targetDepth)) {
                    networkInfo.setEnaSupport(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("efaSupported", targetDepth)) continue;
                networkInfo.setEfaSupported(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return networkInfo;
    }

    public static NetworkInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new NetworkInfoStaxUnmarshaller();
        }
        return instance;
    }
}

