/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.EnableFastSnapshotRestoresRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class EnableFastSnapshotRestoresRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<EnableFastSnapshotRestoresRequest> {
    private SdkInternalList<String> availabilityZones;
    private SdkInternalList<String> sourceSnapshotIds;

    public List<String> getAvailabilityZones() {
        if (this.availabilityZones == null) {
            this.availabilityZones = new SdkInternalList();
        }
        return this.availabilityZones;
    }

    public void setAvailabilityZones(Collection<String> availabilityZones) {
        if (availabilityZones == null) {
            this.availabilityZones = null;
            return;
        }
        this.availabilityZones = new SdkInternalList(availabilityZones);
    }

    public EnableFastSnapshotRestoresRequest withAvailabilityZones(String ... availabilityZones) {
        if (this.availabilityZones == null) {
            this.setAvailabilityZones((Collection<String>)new SdkInternalList(availabilityZones.length));
        }
        for (String ele : availabilityZones) {
            this.availabilityZones.add((Object)ele);
        }
        return this;
    }

    public EnableFastSnapshotRestoresRequest withAvailabilityZones(Collection<String> availabilityZones) {
        this.setAvailabilityZones(availabilityZones);
        return this;
    }

    public List<String> getSourceSnapshotIds() {
        if (this.sourceSnapshotIds == null) {
            this.sourceSnapshotIds = new SdkInternalList();
        }
        return this.sourceSnapshotIds;
    }

    public void setSourceSnapshotIds(Collection<String> sourceSnapshotIds) {
        if (sourceSnapshotIds == null) {
            this.sourceSnapshotIds = null;
            return;
        }
        this.sourceSnapshotIds = new SdkInternalList(sourceSnapshotIds);
    }

    public EnableFastSnapshotRestoresRequest withSourceSnapshotIds(String ... sourceSnapshotIds) {
        if (this.sourceSnapshotIds == null) {
            this.setSourceSnapshotIds((Collection<String>)new SdkInternalList(sourceSnapshotIds.length));
        }
        for (String ele : sourceSnapshotIds) {
            this.sourceSnapshotIds.add((Object)ele);
        }
        return this;
    }

    public EnableFastSnapshotRestoresRequest withSourceSnapshotIds(Collection<String> sourceSnapshotIds) {
        this.setSourceSnapshotIds(sourceSnapshotIds);
        return this;
    }

    @Override
    public Request<EnableFastSnapshotRestoresRequest> getDryRunRequest() {
        Request<EnableFastSnapshotRestoresRequest> request = new EnableFastSnapshotRestoresRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAvailabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(this.getAvailabilityZones()).append(",");
        }
        if (this.getSourceSnapshotIds() != null) {
            sb.append("SourceSnapshotIds: ").append(this.getSourceSnapshotIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFastSnapshotRestoresRequest)) {
            return false;
        }
        EnableFastSnapshotRestoresRequest other = (EnableFastSnapshotRestoresRequest)obj;
        if (other.getAvailabilityZones() == null ^ this.getAvailabilityZones() == null) {
            return false;
        }
        if (other.getAvailabilityZones() != null && !other.getAvailabilityZones().equals(this.getAvailabilityZones())) {
            return false;
        }
        if (other.getSourceSnapshotIds() == null ^ this.getSourceSnapshotIds() == null) {
            return false;
        }
        return other.getSourceSnapshotIds() == null || other.getSourceSnapshotIds().equals(this.getSourceSnapshotIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAvailabilityZones() == null ? 0 : this.getAvailabilityZones().hashCode());
        hashCode = 31 * hashCode + (this.getSourceSnapshotIds() == null ? 0 : this.getSourceSnapshotIds().hashCode());
        return hashCode;
    }

    public EnableFastSnapshotRestoresRequest clone() {
        return (EnableFastSnapshotRestoresRequest)super.clone();
    }
}

