/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.ecs.model.ProtectedTask;
import java.util.Date;

@SdkInternalApi
public class ProtectedTaskMarshaller {
    private static final MarshallingInfo<String> TASKARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("taskArn").build();
    private static final MarshallingInfo<Boolean> PROTECTIONENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("protectionEnabled").build();
    private static final MarshallingInfo<Date> EXPIRATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expirationDate").timestampFormat("unixTimestamp").build();
    private static final ProtectedTaskMarshaller instance = new ProtectedTaskMarshaller();

    public static ProtectedTaskMarshaller getInstance() {
        return instance;
    }

    public void marshall(ProtectedTask protectedTask, ProtocolMarshaller protocolMarshaller) {
        if (protectedTask == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)protectedTask.getTaskArn(), TASKARN_BINDING);
            protocolMarshaller.marshall((Object)protectedTask.getProtectionEnabled(), PROTECTIONENABLED_BINDING);
            protocolMarshaller.marshall((Object)protectedTask.getExpirationDate(), EXPIRATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

