/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticache.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticache.model.DescribeServiceUpdatesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeServiceUpdatesRequestMarshaller
implements Marshaller<Request<DescribeServiceUpdatesRequest>, DescribeServiceUpdatesRequest> {
    public Request<DescribeServiceUpdatesRequest> marshall(DescribeServiceUpdatesRequest describeServiceUpdatesRequest) {
        if (describeServiceUpdatesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeServiceUpdatesRequest, "AmazonElastiCache");
        request.addParameter("Action", "DescribeServiceUpdates");
        request.addParameter("Version", "2015-02-02");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeServiceUpdatesRequest.getServiceUpdateName() != null) {
            request.addParameter("ServiceUpdateName", StringUtils.fromString((String)describeServiceUpdatesRequest.getServiceUpdateName()));
        }
        if (!describeServiceUpdatesRequest.getServiceUpdateStatus().isEmpty() || !((SdkInternalList)describeServiceUpdatesRequest.getServiceUpdateStatus()).isAutoConstruct()) {
            SdkInternalList serviceUpdateStatusList = (SdkInternalList)describeServiceUpdatesRequest.getServiceUpdateStatus();
            int serviceUpdateStatusListIndex = 1;
            for (String serviceUpdateStatusListValue : serviceUpdateStatusList) {
                if (serviceUpdateStatusListValue != null) {
                    request.addParameter("ServiceUpdateStatus.member." + serviceUpdateStatusListIndex, StringUtils.fromString((String)serviceUpdateStatusListValue));
                }
                ++serviceUpdateStatusListIndex;
            }
        }
        if (describeServiceUpdatesRequest.getMaxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeServiceUpdatesRequest.getMaxRecords()));
        }
        if (describeServiceUpdatesRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeServiceUpdatesRequest.getMarker()));
        }
        return request;
    }
}

