/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.forecast.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.forecast.model.ForecastSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListForecastsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<ForecastSummary> forecasts;
    private String nextToken;

    public List<ForecastSummary> getForecasts() {
        return this.forecasts;
    }

    public void setForecasts(Collection<ForecastSummary> forecasts) {
        if (forecasts == null) {
            this.forecasts = null;
            return;
        }
        this.forecasts = new ArrayList<ForecastSummary>(forecasts);
    }

    public ListForecastsResult withForecasts(ForecastSummary ... forecasts) {
        if (this.forecasts == null) {
            this.setForecasts(new ArrayList<ForecastSummary>(forecasts.length));
        }
        for (ForecastSummary ele : forecasts) {
            this.forecasts.add(ele);
        }
        return this;
    }

    public ListForecastsResult withForecasts(Collection<ForecastSummary> forecasts) {
        this.setForecasts(forecasts);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListForecastsResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getForecasts() != null) {
            sb.append("Forecasts: ").append(this.getForecasts()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListForecastsResult)) {
            return false;
        }
        ListForecastsResult other = (ListForecastsResult)obj;
        if (other.getForecasts() == null ^ this.getForecasts() == null) {
            return false;
        }
        if (other.getForecasts() != null && !other.getForecasts().equals(this.getForecasts())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getForecasts() == null ? 0 : this.getForecasts().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListForecastsResult clone() {
        try {
            return (ListForecastsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

