/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.FileCacheNFSConfiguration;
import com.amazonaws.services.fsx.model.transform.FileCacheDataRepositoryAssociationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FileCacheDataRepositoryAssociation
implements Serializable,
Cloneable,
StructuredPojo {
    private String fileCachePath;
    private String dataRepositoryPath;
    private List<String> dataRepositorySubdirectories;
    private FileCacheNFSConfiguration nFS;

    public void setFileCachePath(String fileCachePath) {
        this.fileCachePath = fileCachePath;
    }

    public String getFileCachePath() {
        return this.fileCachePath;
    }

    public FileCacheDataRepositoryAssociation withFileCachePath(String fileCachePath) {
        this.setFileCachePath(fileCachePath);
        return this;
    }

    public void setDataRepositoryPath(String dataRepositoryPath) {
        this.dataRepositoryPath = dataRepositoryPath;
    }

    public String getDataRepositoryPath() {
        return this.dataRepositoryPath;
    }

    public FileCacheDataRepositoryAssociation withDataRepositoryPath(String dataRepositoryPath) {
        this.setDataRepositoryPath(dataRepositoryPath);
        return this;
    }

    public List<String> getDataRepositorySubdirectories() {
        return this.dataRepositorySubdirectories;
    }

    public void setDataRepositorySubdirectories(Collection<String> dataRepositorySubdirectories) {
        if (dataRepositorySubdirectories == null) {
            this.dataRepositorySubdirectories = null;
            return;
        }
        this.dataRepositorySubdirectories = new ArrayList<String>(dataRepositorySubdirectories);
    }

    public FileCacheDataRepositoryAssociation withDataRepositorySubdirectories(String ... dataRepositorySubdirectories) {
        if (this.dataRepositorySubdirectories == null) {
            this.setDataRepositorySubdirectories(new ArrayList<String>(dataRepositorySubdirectories.length));
        }
        for (String ele : dataRepositorySubdirectories) {
            this.dataRepositorySubdirectories.add(ele);
        }
        return this;
    }

    public FileCacheDataRepositoryAssociation withDataRepositorySubdirectories(Collection<String> dataRepositorySubdirectories) {
        this.setDataRepositorySubdirectories(dataRepositorySubdirectories);
        return this;
    }

    public void setNFS(FileCacheNFSConfiguration nFS) {
        this.nFS = nFS;
    }

    public FileCacheNFSConfiguration getNFS() {
        return this.nFS;
    }

    public FileCacheDataRepositoryAssociation withNFS(FileCacheNFSConfiguration nFS) {
        this.setNFS(nFS);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFileCachePath() != null) {
            sb.append("FileCachePath: ").append(this.getFileCachePath()).append(",");
        }
        if (this.getDataRepositoryPath() != null) {
            sb.append("DataRepositoryPath: ").append(this.getDataRepositoryPath()).append(",");
        }
        if (this.getDataRepositorySubdirectories() != null) {
            sb.append("DataRepositorySubdirectories: ").append(this.getDataRepositorySubdirectories()).append(",");
        }
        if (this.getNFS() != null) {
            sb.append("NFS: ").append(this.getNFS());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileCacheDataRepositoryAssociation)) {
            return false;
        }
        FileCacheDataRepositoryAssociation other = (FileCacheDataRepositoryAssociation)obj;
        if (other.getFileCachePath() == null ^ this.getFileCachePath() == null) {
            return false;
        }
        if (other.getFileCachePath() != null && !other.getFileCachePath().equals(this.getFileCachePath())) {
            return false;
        }
        if (other.getDataRepositoryPath() == null ^ this.getDataRepositoryPath() == null) {
            return false;
        }
        if (other.getDataRepositoryPath() != null && !other.getDataRepositoryPath().equals(this.getDataRepositoryPath())) {
            return false;
        }
        if (other.getDataRepositorySubdirectories() == null ^ this.getDataRepositorySubdirectories() == null) {
            return false;
        }
        if (other.getDataRepositorySubdirectories() != null && !other.getDataRepositorySubdirectories().equals(this.getDataRepositorySubdirectories())) {
            return false;
        }
        if (other.getNFS() == null ^ this.getNFS() == null) {
            return false;
        }
        return other.getNFS() == null || other.getNFS().equals(this.getNFS());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFileCachePath() == null ? 0 : this.getFileCachePath().hashCode());
        hashCode = 31 * hashCode + (this.getDataRepositoryPath() == null ? 0 : this.getDataRepositoryPath().hashCode());
        hashCode = 31 * hashCode + (this.getDataRepositorySubdirectories() == null ? 0 : this.getDataRepositorySubdirectories().hashCode());
        hashCode = 31 * hashCode + (this.getNFS() == null ? 0 : this.getNFS().hashCode());
        return hashCode;
    }

    public FileCacheDataRepositoryAssociation clone() {
        try {
            return (FileCacheDataRepositoryAssociation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FileCacheDataRepositoryAssociationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

