/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.gamelift.model.FleetAction;
import com.amazonaws.services.gamelift.model.LocationState;
import com.amazonaws.services.gamelift.model.LocationUpdateStatus;
import com.amazonaws.services.gamelift.model.transform.LocationAttributesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class LocationAttributes
implements Serializable,
Cloneable,
StructuredPojo {
    private LocationState locationState;
    private List<String> stoppedActions;
    private String updateStatus;

    public void setLocationState(LocationState locationState) {
        this.locationState = locationState;
    }

    public LocationState getLocationState() {
        return this.locationState;
    }

    public LocationAttributes withLocationState(LocationState locationState) {
        this.setLocationState(locationState);
        return this;
    }

    public List<String> getStoppedActions() {
        return this.stoppedActions;
    }

    public void setStoppedActions(Collection<String> stoppedActions) {
        if (stoppedActions == null) {
            this.stoppedActions = null;
            return;
        }
        this.stoppedActions = new ArrayList<String>(stoppedActions);
    }

    public LocationAttributes withStoppedActions(String ... stoppedActions) {
        if (this.stoppedActions == null) {
            this.setStoppedActions(new ArrayList<String>(stoppedActions.length));
        }
        for (String ele : stoppedActions) {
            this.stoppedActions.add(ele);
        }
        return this;
    }

    public LocationAttributes withStoppedActions(Collection<String> stoppedActions) {
        this.setStoppedActions(stoppedActions);
        return this;
    }

    public LocationAttributes withStoppedActions(FleetAction ... stoppedActions) {
        ArrayList<String> stoppedActionsCopy = new ArrayList<String>(stoppedActions.length);
        for (FleetAction value : stoppedActions) {
            stoppedActionsCopy.add(value.toString());
        }
        if (this.getStoppedActions() == null) {
            this.setStoppedActions(stoppedActionsCopy);
        } else {
            this.getStoppedActions().addAll(stoppedActionsCopy);
        }
        return this;
    }

    public void setUpdateStatus(String updateStatus) {
        this.updateStatus = updateStatus;
    }

    public String getUpdateStatus() {
        return this.updateStatus;
    }

    public LocationAttributes withUpdateStatus(String updateStatus) {
        this.setUpdateStatus(updateStatus);
        return this;
    }

    public LocationAttributes withUpdateStatus(LocationUpdateStatus updateStatus) {
        this.updateStatus = updateStatus.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLocationState() != null) {
            sb.append("LocationState: ").append(this.getLocationState()).append(",");
        }
        if (this.getStoppedActions() != null) {
            sb.append("StoppedActions: ").append(this.getStoppedActions()).append(",");
        }
        if (this.getUpdateStatus() != null) {
            sb.append("UpdateStatus: ").append(this.getUpdateStatus());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LocationAttributes)) {
            return false;
        }
        LocationAttributes other = (LocationAttributes)obj;
        if (other.getLocationState() == null ^ this.getLocationState() == null) {
            return false;
        }
        if (other.getLocationState() != null && !other.getLocationState().equals(this.getLocationState())) {
            return false;
        }
        if (other.getStoppedActions() == null ^ this.getStoppedActions() == null) {
            return false;
        }
        if (other.getStoppedActions() != null && !other.getStoppedActions().equals(this.getStoppedActions())) {
            return false;
        }
        if (other.getUpdateStatus() == null ^ this.getUpdateStatus() == null) {
            return false;
        }
        return other.getUpdateStatus() == null || other.getUpdateStatus().equals(this.getUpdateStatus());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLocationState() == null ? 0 : this.getLocationState().hashCode());
        hashCode = 31 * hashCode + (this.getStoppedActions() == null ? 0 : this.getStoppedActions().hashCode());
        hashCode = 31 * hashCode + (this.getUpdateStatus() == null ? 0 : this.getUpdateStatus().hashCode());
        return hashCode;
    }

    public LocationAttributes clone() {
        try {
            return (LocationAttributes)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LocationAttributesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

