/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.glue.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.glue.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * JobCommand JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class JobCommandJsonUnmarshaller implements Unmarshaller<JobCommand, JsonUnmarshallerContext> {

    public JobCommand unmarshall(JsonUnmarshallerContext context) throws Exception {
        JobCommand jobCommand = new JobCommand();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    jobCommand.setName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ScriptLocation", targetDepth)) {
                    context.nextToken();
                    jobCommand.setScriptLocation(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("PythonVersion", targetDepth)) {
                    context.nextToken();
                    jobCommand.setPythonVersion(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return jobCommand;
    }

    private static JobCommandJsonUnmarshaller instance;

    public static JobCommandJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new JobCommandJsonUnmarshaller();
        return instance;
    }
}
