/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.honeycode.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.honeycode.model.Format;
import com.amazonaws.services.honeycode.model.transform.CellMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Cell
implements Serializable,
Cloneable,
StructuredPojo {
    private String formula;
    private String format;
    private String rawValue;
    private String formattedValue;
    private List<String> formattedValues;

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getFormula() {
        return this.formula;
    }

    public Cell withFormula(String formula) {
        this.setFormula(formula);
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public Cell withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public Cell withFormat(Format format) {
        this.format = format.toString();
        return this;
    }

    public void setRawValue(String rawValue) {
        this.rawValue = rawValue;
    }

    public String getRawValue() {
        return this.rawValue;
    }

    public Cell withRawValue(String rawValue) {
        this.setRawValue(rawValue);
        return this;
    }

    public void setFormattedValue(String formattedValue) {
        this.formattedValue = formattedValue;
    }

    public String getFormattedValue() {
        return this.formattedValue;
    }

    public Cell withFormattedValue(String formattedValue) {
        this.setFormattedValue(formattedValue);
        return this;
    }

    public List<String> getFormattedValues() {
        return this.formattedValues;
    }

    public void setFormattedValues(Collection<String> formattedValues) {
        if (formattedValues == null) {
            this.formattedValues = null;
            return;
        }
        this.formattedValues = new ArrayList<String>(formattedValues);
    }

    public Cell withFormattedValues(String ... formattedValues) {
        if (this.formattedValues == null) {
            this.setFormattedValues(new ArrayList<String>(formattedValues.length));
        }
        for (String ele : formattedValues) {
            this.formattedValues.add(ele);
        }
        return this;
    }

    public Cell withFormattedValues(Collection<String> formattedValues) {
        this.setFormattedValues(formattedValues);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFormula() != null) {
            sb.append("Formula: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getRawValue() != null) {
            sb.append("RawValue: ").append(this.getRawValue()).append(",");
        }
        if (this.getFormattedValue() != null) {
            sb.append("FormattedValue: ").append(this.getFormattedValue()).append(",");
        }
        if (this.getFormattedValues() != null) {
            sb.append("FormattedValues: ").append(this.getFormattedValues());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cell)) {
            return false;
        }
        Cell other = (Cell)obj;
        if (other.getFormula() == null ^ this.getFormula() == null) {
            return false;
        }
        if (other.getFormula() != null && !other.getFormula().equals(this.getFormula())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getRawValue() == null ^ this.getRawValue() == null) {
            return false;
        }
        if (other.getRawValue() != null && !other.getRawValue().equals(this.getRawValue())) {
            return false;
        }
        if (other.getFormattedValue() == null ^ this.getFormattedValue() == null) {
            return false;
        }
        if (other.getFormattedValue() != null && !other.getFormattedValue().equals(this.getFormattedValue())) {
            return false;
        }
        if (other.getFormattedValues() == null ^ this.getFormattedValues() == null) {
            return false;
        }
        return other.getFormattedValues() == null || other.getFormattedValues().equals(this.getFormattedValues());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFormula() == null ? 0 : this.getFormula().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getRawValue() == null ? 0 : this.getRawValue().hashCode());
        hashCode = 31 * hashCode + (this.getFormattedValue() == null ? 0 : this.getFormattedValue().hashCode());
        hashCode = 31 * hashCode + (this.getFormattedValues() == null ? 0 : this.getFormattedValues().hashCode());
        return hashCode;
    }

    public Cell clone() {
        try {
            return (Cell)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CellMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

