/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.iot.model.StreamFile;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateStreamRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String streamId;
    private String description;
    private List<StreamFile> files;
    private String roleArn;

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    public String getStreamId() {
        return this.streamId;
    }

    public CreateStreamRequest withStreamId(String streamId) {
        this.setStreamId(streamId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateStreamRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<StreamFile> getFiles() {
        return this.files;
    }

    public void setFiles(Collection<StreamFile> files) {
        if (files == null) {
            this.files = null;
            return;
        }
        this.files = new ArrayList<StreamFile>(files);
    }

    public CreateStreamRequest withFiles(StreamFile ... files) {
        if (this.files == null) {
            this.setFiles(new ArrayList<StreamFile>(files.length));
        }
        for (StreamFile ele : files) {
            this.files.add(ele);
        }
        return this;
    }

    public CreateStreamRequest withFiles(Collection<StreamFile> files) {
        this.setFiles(files);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateStreamRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStreamId() != null) {
            sb.append("StreamId: ").append(this.getStreamId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getFiles() != null) {
            sb.append("Files: ").append(this.getFiles()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamRequest)) {
            return false;
        }
        CreateStreamRequest other = (CreateStreamRequest)obj;
        if (other.getStreamId() == null ^ this.getStreamId() == null) {
            return false;
        }
        if (other.getStreamId() != null && !other.getStreamId().equals(this.getStreamId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getFiles() == null ^ this.getFiles() == null) {
            return false;
        }
        if (other.getFiles() != null && !other.getFiles().equals(this.getFiles())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        return other.getRoleArn() == null || other.getRoleArn().equals(this.getRoleArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStreamId() == null ? 0 : this.getStreamId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getFiles() == null ? 0 : this.getFiles().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        return hashCode;
    }

    public CreateStreamRequest clone() {
        return (CreateStreamRequest)super.clone();
    }
}

