/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iot.model.transform.HttpContextMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class HttpContext
implements Serializable,
Cloneable,
StructuredPojo {
    private Map<String, String> headers;
    private String queryString;

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public HttpContext withHeaders(Map<String, String> headers) {
        this.setHeaders(headers);
        return this;
    }

    public HttpContext addHeadersEntry(String key, String value) {
        if (null == this.headers) {
            this.headers = new HashMap<String, String>();
        }
        if (this.headers.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.headers.put(key, value);
        return this;
    }

    public HttpContext clearHeadersEntries() {
        this.headers = null;
        return this;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public HttpContext withQueryString(String queryString) {
        this.setQueryString(queryString);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHeaders() != null) {
            sb.append("Headers: ").append(this.getHeaders()).append(",");
        }
        if (this.getQueryString() != null) {
            sb.append("QueryString: ").append(this.getQueryString());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HttpContext)) {
            return false;
        }
        HttpContext other = (HttpContext)obj;
        if (other.getHeaders() == null ^ this.getHeaders() == null) {
            return false;
        }
        if (other.getHeaders() != null && !other.getHeaders().equals(this.getHeaders())) {
            return false;
        }
        if (other.getQueryString() == null ^ this.getQueryString() == null) {
            return false;
        }
        return other.getQueryString() == null || other.getQueryString().equals(this.getQueryString());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHeaders() == null ? 0 : this.getHeaders().hashCode());
        hashCode = 31 * hashCode + (this.getQueryString() == null ? 0 : this.getQueryString().hashCode());
        return hashCode;
    }

    public HttpContext clone() {
        try {
            return (HttpContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HttpContextMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

