/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.iot1clickprojects;

import javax.annotation.Generated;

import com.amazonaws.services.iot1clickprojects.model.*;

/**
 * Abstract implementation of {@code AWSIoT1ClickProjectsAsync}. Convenient method forms pass through to the
 * corresponding overload that takes a request object and an {@code AsyncHandler}, which throws an
 * {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSIoT1ClickProjectsAsync extends AbstractAWSIoT1ClickProjects implements AWSIoT1ClickProjectsAsync {

    protected AbstractAWSIoT1ClickProjectsAsync() {
    }

    @Override
    public java.util.concurrent.Future<AssociateDeviceWithPlacementResult> associateDeviceWithPlacementAsync(AssociateDeviceWithPlacementRequest request) {

        return associateDeviceWithPlacementAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<AssociateDeviceWithPlacementResult> associateDeviceWithPlacementAsync(AssociateDeviceWithPlacementRequest request,
            com.amazonaws.handlers.AsyncHandler<AssociateDeviceWithPlacementRequest, AssociateDeviceWithPlacementResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreatePlacementResult> createPlacementAsync(CreatePlacementRequest request) {

        return createPlacementAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreatePlacementResult> createPlacementAsync(CreatePlacementRequest request,
            com.amazonaws.handlers.AsyncHandler<CreatePlacementRequest, CreatePlacementResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request) {

        return createProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateProjectResult> createProjectAsync(CreateProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateProjectRequest, CreateProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeletePlacementResult> deletePlacementAsync(DeletePlacementRequest request) {

        return deletePlacementAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeletePlacementResult> deletePlacementAsync(DeletePlacementRequest request,
            com.amazonaws.handlers.AsyncHandler<DeletePlacementRequest, DeletePlacementResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request) {

        return deleteProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteProjectResult> deleteProjectAsync(DeleteProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteProjectRequest, DeleteProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribePlacementResult> describePlacementAsync(DescribePlacementRequest request) {

        return describePlacementAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribePlacementResult> describePlacementAsync(DescribePlacementRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribePlacementRequest, DescribePlacementResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DescribeProjectResult> describeProjectAsync(DescribeProjectRequest request) {

        return describeProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DescribeProjectResult> describeProjectAsync(DescribeProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<DescribeProjectRequest, DescribeProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DisassociateDeviceFromPlacementResult> disassociateDeviceFromPlacementAsync(
            DisassociateDeviceFromPlacementRequest request) {

        return disassociateDeviceFromPlacementAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DisassociateDeviceFromPlacementResult> disassociateDeviceFromPlacementAsync(
            DisassociateDeviceFromPlacementRequest request,
            com.amazonaws.handlers.AsyncHandler<DisassociateDeviceFromPlacementRequest, DisassociateDeviceFromPlacementResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetDevicesInPlacementResult> getDevicesInPlacementAsync(GetDevicesInPlacementRequest request) {

        return getDevicesInPlacementAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetDevicesInPlacementResult> getDevicesInPlacementAsync(GetDevicesInPlacementRequest request,
            com.amazonaws.handlers.AsyncHandler<GetDevicesInPlacementRequest, GetDevicesInPlacementResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPlacementsResult> listPlacementsAsync(ListPlacementsRequest request) {

        return listPlacementsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPlacementsResult> listPlacementsAsync(ListPlacementsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPlacementsRequest, ListPlacementsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request) {

        return listProjectsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListProjectsResult> listProjectsAsync(ListProjectsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListProjectsRequest, ListProjectsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdatePlacementResult> updatePlacementAsync(UpdatePlacementRequest request) {

        return updatePlacementAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdatePlacementResult> updatePlacementAsync(UpdatePlacementRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdatePlacementRequest, UpdatePlacementResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request) {

        return updateProjectAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateProjectResult> updateProjectAsync(UpdateProjectRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateProjectRequest, UpdateProjectResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
