/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotfleetwise.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotfleetwise.model.Node;

@SdkInternalApi
public class NodeMarshaller {
    private static final MarshallingInfo<StructuredPojo> BRANCH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("branch").build();
    private static final MarshallingInfo<StructuredPojo> SENSOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sensor").build();
    private static final MarshallingInfo<StructuredPojo> ACTUATOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actuator").build();
    private static final MarshallingInfo<StructuredPojo> ATTRIBUTE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("attribute").build();
    private static final NodeMarshaller instance = new NodeMarshaller();

    public static NodeMarshaller getInstance() {
        return instance;
    }

    public void marshall(Node node, ProtocolMarshaller protocolMarshaller) {
        if (node == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)node.getBranch(), BRANCH_BINDING);
            protocolMarshaller.marshall((Object)node.getSensor(), SENSOR_BINDING);
            protocolMarshaller.marshall((Object)node.getActuator(), ACTUATOR_BINDING);
            protocolMarshaller.marshall((Object)node.getAttribute(), ATTRIBUTE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

