/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.kms.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/ReplicateKey" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ReplicateKeyRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * Identifies the multi-Region primary key that is being replicated. To determine whether a KMS key is a
     * multi-Region primary key, use the <a>DescribeKey</a> operation to check the value of the
     * <code>MultiRegionKeyType</code> property.
     * </p>
     * <p>
     * Specify the key ID or key ARN of a multi-Region primary key.
     * </p>
     * <p>
     * For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the key ID and key ARN for a KMS key, use <a>ListKeys</a> or <a>DescribeKey</a>.
     * </p>
     */
    private String keyId;
    /**
     * <p>
     * The Region ID of the Amazon Web Services Region for this replica key.
     * </p>
     * <p>
     * Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. For a list of Amazon Web
     * Services Regions in which KMS is supported, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region">KMS service endpoints</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * <note>
     * <p>
     * HMAC KMS keys are not supported in all Amazon Web Services Regions. If you try to replicate an HMAC KMS key in an
     * Amazon Web Services Region in which HMAC keys are not supported, the <code>ReplicateKey</code> operation returns
     * an <code>UnsupportedOperationException</code>. For a list of Regions in which HMAC KMS keys are supported, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html">HMAC keys in KMS</a> in the <i>Key
     * Management Service Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * The replica must be in a different Amazon Web Services Region than its primary key and other replicas of that
     * primary key, but in the same Amazon Web Services partition. KMS must be available in the replica Region. If the
     * Region is not enabled by default, the Amazon Web Services account must be enabled in the Region. For information
     * about Amazon Web Services partitions, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For information about enabling and disabling
     * Regions, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">Enabling a Region</a>
     * and <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-disable">Disabling a
     * Region</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     */
    private String replicaRegion;
    /**
     * <p>
     * The key policy to attach to the KMS key. This parameter is optional. If you do not provide a key policy, KMS
     * attaches the <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">default key
     * policy</a> to the KMS key.
     * </p>
     * <p>
     * The key policy is not a shared property of multi-Region keys. You can specify the same key policy or a different
     * key policy for each key in a set of related multi-Region keys. KMS does not synchronize this property.
     * </p>
     * <p>
     * If you provide a key policy, it must meet the following criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must give the caller
     * <code>kms:PutKeyPolicy</code> permission on the replica key. This reduces the risk that the KMS key becomes
     * unmanageable. For more information, refer to the scenario in the <a href=
     * "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     * >Default Key Policy</a> section of the <i> <i>Key Management Service Developer Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each statement in the key policy must contain one or more principals. The principals in the key policy must exist
     * and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM user or role),
     * you might need to enforce a delay before including the new principal in a key policy because the new principal
     * might not be immediately visible to KMS. For more information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency"
     * >Changes that I make are not always immediately visible</a> in the <i> <i>Identity and Access Management User
     * Guide</i> </i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A key policy document can include only the following characters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Printable ASCII characters from the space character (<code>\u0020</code>) through the end of the ASCII character
     * range.
     * </p>
     * </li>
     * <li>
     * <p>
     * Printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>) special
     * characters
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about key policies, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Key policies in KMS</a> in the
     * <i>Key Management Service Developer Guide</i>. For help writing and formatting a JSON policy document, see the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON Policy Reference</a> in
     * the <i> <i>Identity and Access Management User Guide</i> </i>.
     * </p>
     */
    private String policy;
    /**
     * <p>
     * A flag to indicate whether to bypass the key policy lockout safety check.
     * </p>
     * <important>
     * <p>
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to
     * true indiscriminately.
     * </p>
     * <p>
     * For more information, refer to the scenario in the <a href=
     * "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     * >Default Key Policy</a> section in the <i>Key Management Service Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * Use this parameter only when you intend to prevent the principal that is making the request from making a
     * subsequent <code>PutKeyPolicy</code> request on the KMS key.
     * </p>
     * <p>
     * The default value is false.
     * </p>
     */
    private Boolean bypassPolicyLockoutSafetyCheck;
    /**
     * <p>
     * A description of the KMS key. The default value is an empty string (no description).
     * </p>
     * <p>
     * The description is not a shared property of multi-Region keys. You can specify the same description or a
     * different description for each key in a set of related multi-Region keys. KMS does not synchronize this property.
     * </p>
     */
    private String description;
    /**
     * <p>
     * Assigns one or more tags to the replica key. Use this parameter to tag the KMS key when it is created. To tag an
     * existing KMS key, use the <a>TagResource</a> operation.
     * </p>
     * <note>
     * <p>
     * Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC in KMS</a> in the <i>Key Management
     * Service Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * To use this parameter, you must have <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html"
     * >kms:TagResource</a> permission in an IAM policy.
     * </p>
     * <p>
     * Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for each key
     * in a set of related multi-Region keys. KMS does not synchronize this property.
     * </p>
     * <p>
     * Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag
     * value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you
     * specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified
     * one.
     * </p>
     * <p>
     * When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation report with
     * usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging Keys</a>.
     * </p>
     */
    private com.amazonaws.internal.SdkInternalList<Tag> tags;

    /**
     * <p>
     * Identifies the multi-Region primary key that is being replicated. To determine whether a KMS key is a
     * multi-Region primary key, use the <a>DescribeKey</a> operation to check the value of the
     * <code>MultiRegionKeyType</code> property.
     * </p>
     * <p>
     * Specify the key ID or key ARN of a multi-Region primary key.
     * </p>
     * <p>
     * For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the key ID and key ARN for a KMS key, use <a>ListKeys</a> or <a>DescribeKey</a>.
     * </p>
     * 
     * @param keyId
     *        Identifies the multi-Region primary key that is being replicated. To determine whether a KMS key is a
     *        multi-Region primary key, use the <a>DescribeKey</a> operation to check the value of the
     *        <code>MultiRegionKeyType</code> property.</p>
     *        <p>
     *        Specify the key ID or key ARN of a multi-Region primary key.
     *        </p>
     *        <p>
     *        For example:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code>
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        To get the key ID and key ARN for a KMS key, use <a>ListKeys</a> or <a>DescribeKey</a>.
     */

    public void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    /**
     * <p>
     * Identifies the multi-Region primary key that is being replicated. To determine whether a KMS key is a
     * multi-Region primary key, use the <a>DescribeKey</a> operation to check the value of the
     * <code>MultiRegionKeyType</code> property.
     * </p>
     * <p>
     * Specify the key ID or key ARN of a multi-Region primary key.
     * </p>
     * <p>
     * For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the key ID and key ARN for a KMS key, use <a>ListKeys</a> or <a>DescribeKey</a>.
     * </p>
     * 
     * @return Identifies the multi-Region primary key that is being replicated. To determine whether a KMS key is a
     *         multi-Region primary key, use the <a>DescribeKey</a> operation to check the value of the
     *         <code>MultiRegionKeyType</code> property.</p>
     *         <p>
     *         Specify the key ID or key ARN of a multi-Region primary key.
     *         </p>
     *         <p>
     *         For example:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To get the key ID and key ARN for a KMS key, use <a>ListKeys</a> or <a>DescribeKey</a>.
     */

    public String getKeyId() {
        return this.keyId;
    }

    /**
     * <p>
     * Identifies the multi-Region primary key that is being replicated. To determine whether a KMS key is a
     * multi-Region primary key, use the <a>DescribeKey</a> operation to check the value of the
     * <code>MultiRegionKeyType</code> property.
     * </p>
     * <p>
     * Specify the key ID or key ARN of a multi-Region primary key.
     * </p>
     * <p>
     * For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To get the key ID and key ARN for a KMS key, use <a>ListKeys</a> or <a>DescribeKey</a>.
     * </p>
     * 
     * @param keyId
     *        Identifies the multi-Region primary key that is being replicated. To determine whether a KMS key is a
     *        multi-Region primary key, use the <a>DescribeKey</a> operation to check the value of the
     *        <code>MultiRegionKeyType</code> property.</p>
     *        <p>
     *        Specify the key ID or key ARN of a multi-Region primary key.
     *        </p>
     *        <p>
     *        For example:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code>
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code>
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        To get the key ID and key ARN for a KMS key, use <a>ListKeys</a> or <a>DescribeKey</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ReplicateKeyRequest withKeyId(String keyId) {
        setKeyId(keyId);
        return this;
    }

    /**
     * <p>
     * The Region ID of the Amazon Web Services Region for this replica key.
     * </p>
     * <p>
     * Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. For a list of Amazon Web
     * Services Regions in which KMS is supported, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region">KMS service endpoints</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * <note>
     * <p>
     * HMAC KMS keys are not supported in all Amazon Web Services Regions. If you try to replicate an HMAC KMS key in an
     * Amazon Web Services Region in which HMAC keys are not supported, the <code>ReplicateKey</code> operation returns
     * an <code>UnsupportedOperationException</code>. For a list of Regions in which HMAC KMS keys are supported, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html">HMAC keys in KMS</a> in the <i>Key
     * Management Service Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * The replica must be in a different Amazon Web Services Region than its primary key and other replicas of that
     * primary key, but in the same Amazon Web Services partition. KMS must be available in the replica Region. If the
     * Region is not enabled by default, the Amazon Web Services account must be enabled in the Region. For information
     * about Amazon Web Services partitions, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For information about enabling and disabling
     * Regions, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">Enabling a Region</a>
     * and <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-disable">Disabling a
     * Region</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @param replicaRegion
     *        The Region ID of the Amazon Web Services Region for this replica key. </p>
     *        <p>
     *        Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. For a list of Amazon
     *        Web Services Regions in which KMS is supported, see <a
     *        href="https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region">KMS service endpoints</a> in the
     *        <i>Amazon Web Services General Reference</i>.
     *        </p>
     *        <note>
     *        <p>
     *        HMAC KMS keys are not supported in all Amazon Web Services Regions. If you try to replicate an HMAC KMS
     *        key in an Amazon Web Services Region in which HMAC keys are not supported, the <code>ReplicateKey</code>
     *        operation returns an <code>UnsupportedOperationException</code>. For a list of Regions in which HMAC KMS
     *        keys are supported, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html">HMAC
     *        keys in KMS</a> in the <i>Key Management Service Developer Guide</i>.
     *        </p>
     *        </note>
     *        <p>
     *        The replica must be in a different Amazon Web Services Region than its primary key and other replicas of
     *        that primary key, but in the same Amazon Web Services partition. KMS must be available in the replica
     *        Region. If the Region is not enabled by default, the Amazon Web Services account must be enabled in the
     *        Region. For information about Amazon Web Services partitions, see <a
     *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *        (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For information about enabling and
     *        disabling Regions, see <a
     *        href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">Enabling a
     *        Region</a> and <a
     *        href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-disable">Disabling a
     *        Region</a> in the <i>Amazon Web Services General Reference</i>.
     */

    public void setReplicaRegion(String replicaRegion) {
        this.replicaRegion = replicaRegion;
    }

    /**
     * <p>
     * The Region ID of the Amazon Web Services Region for this replica key.
     * </p>
     * <p>
     * Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. For a list of Amazon Web
     * Services Regions in which KMS is supported, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region">KMS service endpoints</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * <note>
     * <p>
     * HMAC KMS keys are not supported in all Amazon Web Services Regions. If you try to replicate an HMAC KMS key in an
     * Amazon Web Services Region in which HMAC keys are not supported, the <code>ReplicateKey</code> operation returns
     * an <code>UnsupportedOperationException</code>. For a list of Regions in which HMAC KMS keys are supported, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html">HMAC keys in KMS</a> in the <i>Key
     * Management Service Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * The replica must be in a different Amazon Web Services Region than its primary key and other replicas of that
     * primary key, but in the same Amazon Web Services partition. KMS must be available in the replica Region. If the
     * Region is not enabled by default, the Amazon Web Services account must be enabled in the Region. For information
     * about Amazon Web Services partitions, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For information about enabling and disabling
     * Regions, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">Enabling a Region</a>
     * and <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-disable">Disabling a
     * Region</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @return The Region ID of the Amazon Web Services Region for this replica key. </p>
     *         <p>
     *         Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. For a list of Amazon
     *         Web Services Regions in which KMS is supported, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region">KMS service endpoints</a> in the
     *         <i>Amazon Web Services General Reference</i>.
     *         </p>
     *         <note>
     *         <p>
     *         HMAC KMS keys are not supported in all Amazon Web Services Regions. If you try to replicate an HMAC KMS
     *         key in an Amazon Web Services Region in which HMAC keys are not supported, the <code>ReplicateKey</code>
     *         operation returns an <code>UnsupportedOperationException</code>. For a list of Regions in which HMAC KMS
     *         keys are supported, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html">HMAC
     *         keys in KMS</a> in the <i>Key Management Service Developer Guide</i>.
     *         </p>
     *         </note>
     *         <p>
     *         The replica must be in a different Amazon Web Services Region than its primary key and other replicas of
     *         that primary key, but in the same Amazon Web Services partition. KMS must be available in the replica
     *         Region. If the Region is not enabled by default, the Amazon Web Services account must be enabled in the
     *         Region. For information about Amazon Web Services partitions, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For information about enabling and
     *         disabling Regions, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">Enabling a
     *         Region</a> and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-disable">Disabling a
     *         Region</a> in the <i>Amazon Web Services General Reference</i>.
     */

    public String getReplicaRegion() {
        return this.replicaRegion;
    }

    /**
     * <p>
     * The Region ID of the Amazon Web Services Region for this replica key.
     * </p>
     * <p>
     * Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. For a list of Amazon Web
     * Services Regions in which KMS is supported, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region">KMS service endpoints</a> in the
     * <i>Amazon Web Services General Reference</i>.
     * </p>
     * <note>
     * <p>
     * HMAC KMS keys are not supported in all Amazon Web Services Regions. If you try to replicate an HMAC KMS key in an
     * Amazon Web Services Region in which HMAC keys are not supported, the <code>ReplicateKey</code> operation returns
     * an <code>UnsupportedOperationException</code>. For a list of Regions in which HMAC KMS keys are supported, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html">HMAC keys in KMS</a> in the <i>Key
     * Management Service Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * The replica must be in a different Amazon Web Services Region than its primary key and other replicas of that
     * primary key, but in the same Amazon Web Services partition. KMS must be available in the replica Region. If the
     * Region is not enabled by default, the Amazon Web Services account must be enabled in the Region. For information
     * about Amazon Web Services partitions, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     * (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For information about enabling and disabling
     * Regions, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">Enabling a Region</a>
     * and <a href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-disable">Disabling a
     * Region</a> in the <i>Amazon Web Services General Reference</i>.
     * </p>
     * 
     * @param replicaRegion
     *        The Region ID of the Amazon Web Services Region for this replica key. </p>
     *        <p>
     *        Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. For a list of Amazon
     *        Web Services Regions in which KMS is supported, see <a
     *        href="https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region">KMS service endpoints</a> in the
     *        <i>Amazon Web Services General Reference</i>.
     *        </p>
     *        <note>
     *        <p>
     *        HMAC KMS keys are not supported in all Amazon Web Services Regions. If you try to replicate an HMAC KMS
     *        key in an Amazon Web Services Region in which HMAC keys are not supported, the <code>ReplicateKey</code>
     *        operation returns an <code>UnsupportedOperationException</code>. For a list of Regions in which HMAC KMS
     *        keys are supported, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html">HMAC
     *        keys in KMS</a> in the <i>Key Management Service Developer Guide</i>.
     *        </p>
     *        </note>
     *        <p>
     *        The replica must be in a different Amazon Web Services Region than its primary key and other replicas of
     *        that primary key, but in the same Amazon Web Services partition. KMS must be available in the replica
     *        Region. If the Region is not enabled by default, the Amazon Web Services account must be enabled in the
     *        Region. For information about Amazon Web Services partitions, see <a
     *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *        (ARNs)</a> in the <i>Amazon Web Services General Reference</i>. For information about enabling and
     *        disabling Regions, see <a
     *        href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-enable">Enabling a
     *        Region</a> and <a
     *        href="https://docs.aws.amazon.com/general/latest/gr/rande-manage.html#rande-manage-disable">Disabling a
     *        Region</a> in the <i>Amazon Web Services General Reference</i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ReplicateKeyRequest withReplicaRegion(String replicaRegion) {
        setReplicaRegion(replicaRegion);
        return this;
    }

    /**
     * <p>
     * The key policy to attach to the KMS key. This parameter is optional. If you do not provide a key policy, KMS
     * attaches the <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">default key
     * policy</a> to the KMS key.
     * </p>
     * <p>
     * The key policy is not a shared property of multi-Region keys. You can specify the same key policy or a different
     * key policy for each key in a set of related multi-Region keys. KMS does not synchronize this property.
     * </p>
     * <p>
     * If you provide a key policy, it must meet the following criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must give the caller
     * <code>kms:PutKeyPolicy</code> permission on the replica key. This reduces the risk that the KMS key becomes
     * unmanageable. For more information, refer to the scenario in the <a href=
     * "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     * >Default Key Policy</a> section of the <i> <i>Key Management Service Developer Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each statement in the key policy must contain one or more principals. The principals in the key policy must exist
     * and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM user or role),
     * you might need to enforce a delay before including the new principal in a key policy because the new principal
     * might not be immediately visible to KMS. For more information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency"
     * >Changes that I make are not always immediately visible</a> in the <i> <i>Identity and Access Management User
     * Guide</i> </i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A key policy document can include only the following characters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Printable ASCII characters from the space character (<code>\u0020</code>) through the end of the ASCII character
     * range.
     * </p>
     * </li>
     * <li>
     * <p>
     * Printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>) special
     * characters
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about key policies, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Key policies in KMS</a> in the
     * <i>Key Management Service Developer Guide</i>. For help writing and formatting a JSON policy document, see the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON Policy Reference</a> in
     * the <i> <i>Identity and Access Management User Guide</i> </i>.
     * </p>
     * 
     * @param policy
     *        The key policy to attach to the KMS key. This parameter is optional. If you do not provide a key policy,
     *        KMS attaches the <a
     *        href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">default
     *        key policy</a> to the KMS key.</p>
     *        <p>
     *        The key policy is not a shared property of multi-Region keys. You can specify the same key policy or a
     *        different key policy for each key in a set of related multi-Region keys. KMS does not synchronize this
     *        property.
     *        </p>
     *        <p>
     *        If you provide a key policy, it must meet the following criteria:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must give the caller
     *        <code>kms:PutKeyPolicy</code> permission on the replica key. This reduces the risk that the KMS key
     *        becomes unmanageable. For more information, refer to the scenario in the <a href=
     *        "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     *        >Default Key Policy</a> section of the <i> <i>Key Management Service Developer Guide</i> </i>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Each statement in the key policy must contain one or more principals. The principals in the key policy
     *        must exist and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM
     *        user or role), you might need to enforce a delay before including the new principal in a key policy
     *        because the new principal might not be immediately visible to KMS. For more information, see <a href=
     *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency"
     *        >Changes that I make are not always immediately visible</a> in the <i> <i>Identity and Access Management
     *        User Guide</i> </i>.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        A key policy document can include only the following characters:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Printable ASCII characters from the space character (<code>\u0020</code>) through the end of the ASCII
     *        character range.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
     *        ).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)
     *        special characters
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        For information about key policies, see <a
     *        href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Key policies in KMS</a> in
     *        the <i>Key Management Service Developer Guide</i>. For help writing and formatting a JSON policy document,
     *        see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON Policy
     *        Reference</a> in the <i> <i>Identity and Access Management User Guide</i> </i>.
     */

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    /**
     * <p>
     * The key policy to attach to the KMS key. This parameter is optional. If you do not provide a key policy, KMS
     * attaches the <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">default key
     * policy</a> to the KMS key.
     * </p>
     * <p>
     * The key policy is not a shared property of multi-Region keys. You can specify the same key policy or a different
     * key policy for each key in a set of related multi-Region keys. KMS does not synchronize this property.
     * </p>
     * <p>
     * If you provide a key policy, it must meet the following criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must give the caller
     * <code>kms:PutKeyPolicy</code> permission on the replica key. This reduces the risk that the KMS key becomes
     * unmanageable. For more information, refer to the scenario in the <a href=
     * "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     * >Default Key Policy</a> section of the <i> <i>Key Management Service Developer Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each statement in the key policy must contain one or more principals. The principals in the key policy must exist
     * and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM user or role),
     * you might need to enforce a delay before including the new principal in a key policy because the new principal
     * might not be immediately visible to KMS. For more information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency"
     * >Changes that I make are not always immediately visible</a> in the <i> <i>Identity and Access Management User
     * Guide</i> </i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A key policy document can include only the following characters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Printable ASCII characters from the space character (<code>\u0020</code>) through the end of the ASCII character
     * range.
     * </p>
     * </li>
     * <li>
     * <p>
     * Printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>) special
     * characters
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about key policies, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Key policies in KMS</a> in the
     * <i>Key Management Service Developer Guide</i>. For help writing and formatting a JSON policy document, see the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON Policy Reference</a> in
     * the <i> <i>Identity and Access Management User Guide</i> </i>.
     * </p>
     * 
     * @return The key policy to attach to the KMS key. This parameter is optional. If you do not provide a key policy,
     *         KMS attaches the <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">default
     *         key policy</a> to the KMS key.</p>
     *         <p>
     *         The key policy is not a shared property of multi-Region keys. You can specify the same key policy or a
     *         different key policy for each key in a set of related multi-Region keys. KMS does not synchronize this
     *         property.
     *         </p>
     *         <p>
     *         If you provide a key policy, it must meet the following criteria:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must give the caller
     *         <code>kms:PutKeyPolicy</code> permission on the replica key. This reduces the risk that the KMS key
     *         becomes unmanageable. For more information, refer to the scenario in the <a href=
     *         "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     *         >Default Key Policy</a> section of the <i> <i>Key Management Service Developer Guide</i> </i>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Each statement in the key policy must contain one or more principals. The principals in the key policy
     *         must exist and be visible to KMS. When you create a new Amazon Web Services principal (for example, an
     *         IAM user or role), you might need to enforce a delay before including the new principal in a key policy
     *         because the new principal might not be immediately visible to KMS. For more information, see <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency"
     *         >Changes that I make are not always immediately visible</a> in the <i> <i>Identity and Access Management
     *         User Guide</i> </i>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         A key policy document can include only the following characters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Printable ASCII characters from the space character (<code>\u0020</code>) through the end of the ASCII
     *         character range.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
     *         ).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)
     *         special characters
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For information about key policies, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Key policies in KMS</a> in
     *         the <i>Key Management Service Developer Guide</i>. For help writing and formatting a JSON policy
     *         document, see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM
     *         JSON Policy Reference</a> in the <i> <i>Identity and Access Management User Guide</i> </i>.
     */

    public String getPolicy() {
        return this.policy;
    }

    /**
     * <p>
     * The key policy to attach to the KMS key. This parameter is optional. If you do not provide a key policy, KMS
     * attaches the <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">default key
     * policy</a> to the KMS key.
     * </p>
     * <p>
     * The key policy is not a shared property of multi-Region keys. You can specify the same key policy or a different
     * key policy for each key in a set of related multi-Region keys. KMS does not synchronize this property.
     * </p>
     * <p>
     * If you provide a key policy, it must meet the following criteria:
     * </p>
     * <ul>
     * <li>
     * <p>
     * If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must give the caller
     * <code>kms:PutKeyPolicy</code> permission on the replica key. This reduces the risk that the KMS key becomes
     * unmanageable. For more information, refer to the scenario in the <a href=
     * "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     * >Default Key Policy</a> section of the <i> <i>Key Management Service Developer Guide</i> </i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Each statement in the key policy must contain one or more principals. The principals in the key policy must exist
     * and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM user or role),
     * you might need to enforce a delay before including the new principal in a key policy because the new principal
     * might not be immediately visible to KMS. For more information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency"
     * >Changes that I make are not always immediately visible</a> in the <i> <i>Identity and Access Management User
     * Guide</i> </i>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A key policy document can include only the following characters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Printable ASCII characters from the space character (<code>\u0020</code>) through the end of the ASCII character
     * range.
     * </p>
     * </li>
     * <li>
     * <p>
     * Printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>) special
     * characters
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about key policies, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Key policies in KMS</a> in the
     * <i>Key Management Service Developer Guide</i>. For help writing and formatting a JSON policy document, see the <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON Policy Reference</a> in
     * the <i> <i>Identity and Access Management User Guide</i> </i>.
     * </p>
     * 
     * @param policy
     *        The key policy to attach to the KMS key. This parameter is optional. If you do not provide a key policy,
     *        KMS attaches the <a
     *        href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default">default
     *        key policy</a> to the KMS key.</p>
     *        <p>
     *        The key policy is not a shared property of multi-Region keys. You can specify the same key policy or a
     *        different key policy for each key in a set of related multi-Region keys. KMS does not synchronize this
     *        property.
     *        </p>
     *        <p>
     *        If you provide a key policy, it must meet the following criteria:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        If you don't set <code>BypassPolicyLockoutSafetyCheck</code> to true, the key policy must give the caller
     *        <code>kms:PutKeyPolicy</code> permission on the replica key. This reduces the risk that the KMS key
     *        becomes unmanageable. For more information, refer to the scenario in the <a href=
     *        "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     *        >Default Key Policy</a> section of the <i> <i>Key Management Service Developer Guide</i> </i>.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Each statement in the key policy must contain one or more principals. The principals in the key policy
     *        must exist and be visible to KMS. When you create a new Amazon Web Services principal (for example, an IAM
     *        user or role), you might need to enforce a delay before including the new principal in a key policy
     *        because the new principal might not be immediately visible to KMS. For more information, see <a href=
     *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency"
     *        >Changes that I make are not always immediately visible</a> in the <i> <i>Identity and Access Management
     *        User Guide</i> </i>.
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        A key policy document can include only the following characters:
     *        </p>
     *        <ul>
     *        <li>
     *        <p>
     *        Printable ASCII characters from the space character (<code>\u0020</code>) through the end of the ASCII
     *        character range.
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        Printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
     *        ).
     *        </p>
     *        </li>
     *        <li>
     *        <p>
     *        The tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)
     *        special characters
     *        </p>
     *        </li>
     *        </ul>
     *        <p>
     *        For information about key policies, see <a
     *        href="https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html">Key policies in KMS</a> in
     *        the <i>Key Management Service Developer Guide</i>. For help writing and formatting a JSON policy document,
     *        see the <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html">IAM JSON Policy
     *        Reference</a> in the <i> <i>Identity and Access Management User Guide</i> </i>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ReplicateKeyRequest withPolicy(String policy) {
        setPolicy(policy);
        return this;
    }

    /**
     * <p>
     * A flag to indicate whether to bypass the key policy lockout safety check.
     * </p>
     * <important>
     * <p>
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to
     * true indiscriminately.
     * </p>
     * <p>
     * For more information, refer to the scenario in the <a href=
     * "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     * >Default Key Policy</a> section in the <i>Key Management Service Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * Use this parameter only when you intend to prevent the principal that is making the request from making a
     * subsequent <code>PutKeyPolicy</code> request on the KMS key.
     * </p>
     * <p>
     * The default value is false.
     * </p>
     * 
     * @param bypassPolicyLockoutSafetyCheck
     *        A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>
     *        <p>
     *        Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value
     *        to true indiscriminately.
     *        </p>
     *        <p>
     *        For more information, refer to the scenario in the <a href=
     *        "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     *        >Default Key Policy</a> section in the <i>Key Management Service Developer Guide</i>.
     *        </p>
     *        </important>
     *        <p>
     *        Use this parameter only when you intend to prevent the principal that is making the request from making a
     *        subsequent <code>PutKeyPolicy</code> request on the KMS key.
     *        </p>
     *        <p>
     *        The default value is false.
     */

    public void setBypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
        this.bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck;
    }

    /**
     * <p>
     * A flag to indicate whether to bypass the key policy lockout safety check.
     * </p>
     * <important>
     * <p>
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to
     * true indiscriminately.
     * </p>
     * <p>
     * For more information, refer to the scenario in the <a href=
     * "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     * >Default Key Policy</a> section in the <i>Key Management Service Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * Use this parameter only when you intend to prevent the principal that is making the request from making a
     * subsequent <code>PutKeyPolicy</code> request on the KMS key.
     * </p>
     * <p>
     * The default value is false.
     * </p>
     * 
     * @return A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>
     *         <p>
     *         Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this
     *         value to true indiscriminately.
     *         </p>
     *         <p>
     *         For more information, refer to the scenario in the <a href=
     *         "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     *         >Default Key Policy</a> section in the <i>Key Management Service Developer Guide</i>.
     *         </p>
     *         </important>
     *         <p>
     *         Use this parameter only when you intend to prevent the principal that is making the request from making a
     *         subsequent <code>PutKeyPolicy</code> request on the KMS key.
     *         </p>
     *         <p>
     *         The default value is false.
     */

    public Boolean getBypassPolicyLockoutSafetyCheck() {
        return this.bypassPolicyLockoutSafetyCheck;
    }

    /**
     * <p>
     * A flag to indicate whether to bypass the key policy lockout safety check.
     * </p>
     * <important>
     * <p>
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to
     * true indiscriminately.
     * </p>
     * <p>
     * For more information, refer to the scenario in the <a href=
     * "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     * >Default Key Policy</a> section in the <i>Key Management Service Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * Use this parameter only when you intend to prevent the principal that is making the request from making a
     * subsequent <code>PutKeyPolicy</code> request on the KMS key.
     * </p>
     * <p>
     * The default value is false.
     * </p>
     * 
     * @param bypassPolicyLockoutSafetyCheck
     *        A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>
     *        <p>
     *        Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value
     *        to true indiscriminately.
     *        </p>
     *        <p>
     *        For more information, refer to the scenario in the <a href=
     *        "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     *        >Default Key Policy</a> section in the <i>Key Management Service Developer Guide</i>.
     *        </p>
     *        </important>
     *        <p>
     *        Use this parameter only when you intend to prevent the principal that is making the request from making a
     *        subsequent <code>PutKeyPolicy</code> request on the KMS key.
     *        </p>
     *        <p>
     *        The default value is false.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ReplicateKeyRequest withBypassPolicyLockoutSafetyCheck(Boolean bypassPolicyLockoutSafetyCheck) {
        setBypassPolicyLockoutSafetyCheck(bypassPolicyLockoutSafetyCheck);
        return this;
    }

    /**
     * <p>
     * A flag to indicate whether to bypass the key policy lockout safety check.
     * </p>
     * <important>
     * <p>
     * Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this value to
     * true indiscriminately.
     * </p>
     * <p>
     * For more information, refer to the scenario in the <a href=
     * "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     * >Default Key Policy</a> section in the <i>Key Management Service Developer Guide</i>.
     * </p>
     * </important>
     * <p>
     * Use this parameter only when you intend to prevent the principal that is making the request from making a
     * subsequent <code>PutKeyPolicy</code> request on the KMS key.
     * </p>
     * <p>
     * The default value is false.
     * </p>
     * 
     * @return A flag to indicate whether to bypass the key policy lockout safety check.</p> <important>
     *         <p>
     *         Setting this value to true increases the risk that the KMS key becomes unmanageable. Do not set this
     *         value to true indiscriminately.
     *         </p>
     *         <p>
     *         For more information, refer to the scenario in the <a href=
     *         "https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam"
     *         >Default Key Policy</a> section in the <i>Key Management Service Developer Guide</i>.
     *         </p>
     *         </important>
     *         <p>
     *         Use this parameter only when you intend to prevent the principal that is making the request from making a
     *         subsequent <code>PutKeyPolicy</code> request on the KMS key.
     *         </p>
     *         <p>
     *         The default value is false.
     */

    public Boolean isBypassPolicyLockoutSafetyCheck() {
        return this.bypassPolicyLockoutSafetyCheck;
    }

    /**
     * <p>
     * A description of the KMS key. The default value is an empty string (no description).
     * </p>
     * <p>
     * The description is not a shared property of multi-Region keys. You can specify the same description or a
     * different description for each key in a set of related multi-Region keys. KMS does not synchronize this property.
     * </p>
     * 
     * @param description
     *        A description of the KMS key. The default value is an empty string (no description).</p>
     *        <p>
     *        The description is not a shared property of multi-Region keys. You can specify the same description or a
     *        different description for each key in a set of related multi-Region keys. KMS does not synchronize this
     *        property.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * A description of the KMS key. The default value is an empty string (no description).
     * </p>
     * <p>
     * The description is not a shared property of multi-Region keys. You can specify the same description or a
     * different description for each key in a set of related multi-Region keys. KMS does not synchronize this property.
     * </p>
     * 
     * @return A description of the KMS key. The default value is an empty string (no description).</p>
     *         <p>
     *         The description is not a shared property of multi-Region keys. You can specify the same description or a
     *         different description for each key in a set of related multi-Region keys. KMS does not synchronize this
     *         property.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * A description of the KMS key. The default value is an empty string (no description).
     * </p>
     * <p>
     * The description is not a shared property of multi-Region keys. You can specify the same description or a
     * different description for each key in a set of related multi-Region keys. KMS does not synchronize this property.
     * </p>
     * 
     * @param description
     *        A description of the KMS key. The default value is an empty string (no description).</p>
     *        <p>
     *        The description is not a shared property of multi-Region keys. You can specify the same description or a
     *        different description for each key in a set of related multi-Region keys. KMS does not synchronize this
     *        property.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ReplicateKeyRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * Assigns one or more tags to the replica key. Use this parameter to tag the KMS key when it is created. To tag an
     * existing KMS key, use the <a>TagResource</a> operation.
     * </p>
     * <note>
     * <p>
     * Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC in KMS</a> in the <i>Key Management
     * Service Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * To use this parameter, you must have <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html"
     * >kms:TagResource</a> permission in an IAM policy.
     * </p>
     * <p>
     * Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for each key
     * in a set of related multi-Region keys. KMS does not synchronize this property.
     * </p>
     * <p>
     * Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag
     * value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you
     * specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified
     * one.
     * </p>
     * <p>
     * When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation report with
     * usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging Keys</a>.
     * </p>
     * 
     * @return Assigns one or more tags to the replica key. Use this parameter to tag the KMS key when it is created. To
     *         tag an existing KMS key, use the <a>TagResource</a> operation.</p> <note>
     *         <p>
     *         Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC in KMS</a> in the <i>Key
     *         Management Service Developer Guide</i>.
     *         </p>
     *         </note>
     *         <p>
     *         To use this parameter, you must have <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html"
     *         >kms:TagResource</a> permission in an IAM policy.
     *         </p>
     *         <p>
     *         Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for
     *         each key in a set of related multi-Region keys. KMS does not synchronize this property.
     *         </p>
     *         <p>
     *         Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the
     *         tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag
     *         key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value
     *         with the specified one.
     *         </p>
     *         <p>
     *         When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation
     *         report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For
     *         details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging
     *         Keys</a>.
     */

    public java.util.List<Tag> getTags() {
        if (tags == null) {
            tags = new com.amazonaws.internal.SdkInternalList<Tag>();
        }
        return tags;
    }

    /**
     * <p>
     * Assigns one or more tags to the replica key. Use this parameter to tag the KMS key when it is created. To tag an
     * existing KMS key, use the <a>TagResource</a> operation.
     * </p>
     * <note>
     * <p>
     * Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC in KMS</a> in the <i>Key Management
     * Service Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * To use this parameter, you must have <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html"
     * >kms:TagResource</a> permission in an IAM policy.
     * </p>
     * <p>
     * Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for each key
     * in a set of related multi-Region keys. KMS does not synchronize this property.
     * </p>
     * <p>
     * Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag
     * value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you
     * specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified
     * one.
     * </p>
     * <p>
     * When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation report with
     * usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging Keys</a>.
     * </p>
     * 
     * @param tags
     *        Assigns one or more tags to the replica key. Use this parameter to tag the KMS key when it is created. To
     *        tag an existing KMS key, use the <a>TagResource</a> operation.</p> <note>
     *        <p>
     *        Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a
     *        href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC in KMS</a> in the <i>Key
     *        Management Service Developer Guide</i>.
     *        </p>
     *        </note>
     *        <p>
     *        To use this parameter, you must have <a
     *        href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html"
     *        >kms:TagResource</a> permission in an IAM policy.
     *        </p>
     *        <p>
     *        Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for
     *        each key in a set of related multi-Region keys. KMS does not synchronize this property.
     *        </p>
     *        <p>
     *        Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the
     *        tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag
     *        key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value
     *        with the specified one.
     *        </p>
     *        <p>
     *        When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation
     *        report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For
     *        details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging
     *        Keys</a>.
     */

    public void setTags(java.util.Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }

        this.tags = new com.amazonaws.internal.SdkInternalList<Tag>(tags);
    }

    /**
     * <p>
     * Assigns one or more tags to the replica key. Use this parameter to tag the KMS key when it is created. To tag an
     * existing KMS key, use the <a>TagResource</a> operation.
     * </p>
     * <note>
     * <p>
     * Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC in KMS</a> in the <i>Key Management
     * Service Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * To use this parameter, you must have <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html"
     * >kms:TagResource</a> permission in an IAM policy.
     * </p>
     * <p>
     * Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for each key
     * in a set of related multi-Region keys. KMS does not synchronize this property.
     * </p>
     * <p>
     * Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag
     * value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you
     * specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified
     * one.
     * </p>
     * <p>
     * When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation report with
     * usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging Keys</a>.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTags(java.util.Collection)} or {@link #withTags(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param tags
     *        Assigns one or more tags to the replica key. Use this parameter to tag the KMS key when it is created. To
     *        tag an existing KMS key, use the <a>TagResource</a> operation.</p> <note>
     *        <p>
     *        Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a
     *        href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC in KMS</a> in the <i>Key
     *        Management Service Developer Guide</i>.
     *        </p>
     *        </note>
     *        <p>
     *        To use this parameter, you must have <a
     *        href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html"
     *        >kms:TagResource</a> permission in an IAM policy.
     *        </p>
     *        <p>
     *        Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for
     *        each key in a set of related multi-Region keys. KMS does not synchronize this property.
     *        </p>
     *        <p>
     *        Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the
     *        tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag
     *        key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value
     *        with the specified one.
     *        </p>
     *        <p>
     *        When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation
     *        report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For
     *        details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging
     *        Keys</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ReplicateKeyRequest withTags(Tag... tags) {
        if (this.tags == null) {
            setTags(new com.amazonaws.internal.SdkInternalList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Assigns one or more tags to the replica key. Use this parameter to tag the KMS key when it is created. To tag an
     * existing KMS key, use the <a>TagResource</a> operation.
     * </p>
     * <note>
     * <p>
     * Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC in KMS</a> in the <i>Key Management
     * Service Developer Guide</i>.
     * </p>
     * </note>
     * <p>
     * To use this parameter, you must have <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html"
     * >kms:TagResource</a> permission in an IAM policy.
     * </p>
     * <p>
     * Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for each key
     * in a set of related multi-Region keys. KMS does not synchronize this property.
     * </p>
     * <p>
     * Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the tag
     * value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag key. If you
     * specify an existing tag key with a different tag value, KMS replaces the current tag value with the specified
     * one.
     * </p>
     * <p>
     * When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation report with
     * usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For details, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging Keys</a>.
     * </p>
     * 
     * @param tags
     *        Assigns one or more tags to the replica key. Use this parameter to tag the KMS key when it is created. To
     *        tag an existing KMS key, use the <a>TagResource</a> operation.</p> <note>
     *        <p>
     *        Tagging or untagging a KMS key can allow or deny permission to the KMS key. For details, see <a
     *        href="https://docs.aws.amazon.com/kms/latest/developerguide/abac.html">ABAC in KMS</a> in the <i>Key
     *        Management Service Developer Guide</i>.
     *        </p>
     *        </note>
     *        <p>
     *        To use this parameter, you must have <a
     *        href="https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html"
     *        >kms:TagResource</a> permission in an IAM policy.
     *        </p>
     *        <p>
     *        Tags are not a shared property of multi-Region keys. You can specify the same tags or different tags for
     *        each key in a set of related multi-Region keys. KMS does not synchronize this property.
     *        </p>
     *        <p>
     *        Each tag consists of a tag key and a tag value. Both the tag key and the tag value are required, but the
     *        tag value can be an empty (null) string. You cannot have more than one tag on a KMS key with the same tag
     *        key. If you specify an existing tag key with a different tag value, KMS replaces the current tag value
     *        with the specified one.
     *        </p>
     *        <p>
     *        When you add tags to an Amazon Web Services resource, Amazon Web Services generates a cost allocation
     *        report with usage and costs aggregated by tags. Tags can also be used to control access to a KMS key. For
     *        details, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/tagging-keys.html">Tagging
     *        Keys</a>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ReplicateKeyRequest withTags(java.util.Collection<Tag> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getKeyId() != null)
            sb.append("KeyId: ").append(getKeyId()).append(",");
        if (getReplicaRegion() != null)
            sb.append("ReplicaRegion: ").append(getReplicaRegion()).append(",");
        if (getPolicy() != null)
            sb.append("Policy: ").append(getPolicy()).append(",");
        if (getBypassPolicyLockoutSafetyCheck() != null)
            sb.append("BypassPolicyLockoutSafetyCheck: ").append(getBypassPolicyLockoutSafetyCheck()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ReplicateKeyRequest == false)
            return false;
        ReplicateKeyRequest other = (ReplicateKeyRequest) obj;
        if (other.getKeyId() == null ^ this.getKeyId() == null)
            return false;
        if (other.getKeyId() != null && other.getKeyId().equals(this.getKeyId()) == false)
            return false;
        if (other.getReplicaRegion() == null ^ this.getReplicaRegion() == null)
            return false;
        if (other.getReplicaRegion() != null && other.getReplicaRegion().equals(this.getReplicaRegion()) == false)
            return false;
        if (other.getPolicy() == null ^ this.getPolicy() == null)
            return false;
        if (other.getPolicy() != null && other.getPolicy().equals(this.getPolicy()) == false)
            return false;
        if (other.getBypassPolicyLockoutSafetyCheck() == null ^ this.getBypassPolicyLockoutSafetyCheck() == null)
            return false;
        if (other.getBypassPolicyLockoutSafetyCheck() != null
                && other.getBypassPolicyLockoutSafetyCheck().equals(this.getBypassPolicyLockoutSafetyCheck()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getKeyId() == null) ? 0 : getKeyId().hashCode());
        hashCode = prime * hashCode + ((getReplicaRegion() == null) ? 0 : getReplicaRegion().hashCode());
        hashCode = prime * hashCode + ((getPolicy() == null) ? 0 : getPolicy().hashCode());
        hashCode = prime * hashCode + ((getBypassPolicyLockoutSafetyCheck() == null) ? 0 : getBypassPolicyLockoutSafetyCheck().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public ReplicateKeyRequest clone() {
        return (ReplicateKeyRequest) super.clone();
    }

}
