/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.macie2.model.IpOwner;

@SdkInternalApi
public class IpOwnerMarshaller {
    private static final MarshallingInfo<String> ASN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("asn").build();
    private static final MarshallingInfo<String> ASNORG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("asnOrg").build();
    private static final MarshallingInfo<String> ISP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("isp").build();
    private static final MarshallingInfo<String> ORG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("org").build();
    private static final IpOwnerMarshaller instance = new IpOwnerMarshaller();

    public static IpOwnerMarshaller getInstance() {
        return instance;
    }

    public void marshall(IpOwner ipOwner, ProtocolMarshaller protocolMarshaller) {
        if (ipOwner == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ipOwner.getAsn(), ASN_BINDING);
            protocolMarshaller.marshall((Object)ipOwner.getAsnOrg(), ASNORG_BINDING);
            protocolMarshaller.marshall((Object)ipOwner.getIsp(), ISP_BINDING);
            protocolMarshaller.marshall((Object)ipOwner.getOrg(), ORG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

