/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.macie2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.macie2.model.S3Bucket;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class S3BucketMarshaller {
    private static final MarshallingInfo<String> ALLOWSUNENCRYPTEDOBJECTUPLOADS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("allowsUnencryptedObjectUploads").build();
    private static final MarshallingInfo<String> ARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("arn").build();
    private static final MarshallingInfo<Date> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").timestampFormat("iso8601").build();
    private static final MarshallingInfo<StructuredPojo> DEFAULTSERVERSIDEENCRYPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("defaultServerSideEncryption").build();
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").build();
    private static final MarshallingInfo<StructuredPojo> OWNER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("owner").build();
    private static final MarshallingInfo<StructuredPojo> PUBLICACCESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("publicAccess").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").build();
    private static final S3BucketMarshaller instance = new S3BucketMarshaller();

    public static S3BucketMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3Bucket s3Bucket, ProtocolMarshaller protocolMarshaller) {
        if (s3Bucket == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3Bucket.getAllowsUnencryptedObjectUploads(), ALLOWSUNENCRYPTEDOBJECTUPLOADS_BINDING);
            protocolMarshaller.marshall((Object)s3Bucket.getArn(), ARN_BINDING);
            protocolMarshaller.marshall((Object)s3Bucket.getCreatedAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)s3Bucket.getDefaultServerSideEncryption(), DEFAULTSERVERSIDEENCRYPTION_BINDING);
            protocolMarshaller.marshall((Object)s3Bucket.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)s3Bucket.getOwner(), OWNER_BINDING);
            protocolMarshaller.marshall((Object)s3Bucket.getPublicAccess(), PUBLICACCESS_BINDING);
            protocolMarshaller.marshall(s3Bucket.getTags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

