/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.medialive.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * The Renewal settings for Reservations
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/medialive-2017-10-14/RenewalSettings" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class RenewalSettings implements Serializable, Cloneable, StructuredPojo {

    /** Automatic renewal status for the reservation */
    private String automaticRenewal;
    /** Count for the reservation renewal */
    private Integer renewalCount;

    /**
     * Automatic renewal status for the reservation
     * 
     * @param automaticRenewal
     *        Automatic renewal status for the reservation
     * @see ReservationAutomaticRenewal
     */

    public void setAutomaticRenewal(String automaticRenewal) {
        this.automaticRenewal = automaticRenewal;
    }

    /**
     * Automatic renewal status for the reservation
     * 
     * @return Automatic renewal status for the reservation
     * @see ReservationAutomaticRenewal
     */

    public String getAutomaticRenewal() {
        return this.automaticRenewal;
    }

    /**
     * Automatic renewal status for the reservation
     * 
     * @param automaticRenewal
     *        Automatic renewal status for the reservation
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ReservationAutomaticRenewal
     */

    public RenewalSettings withAutomaticRenewal(String automaticRenewal) {
        setAutomaticRenewal(automaticRenewal);
        return this;
    }

    /**
     * Automatic renewal status for the reservation
     * 
     * @param automaticRenewal
     *        Automatic renewal status for the reservation
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see ReservationAutomaticRenewal
     */

    public RenewalSettings withAutomaticRenewal(ReservationAutomaticRenewal automaticRenewal) {
        this.automaticRenewal = automaticRenewal.toString();
        return this;
    }

    /**
     * Count for the reservation renewal
     * 
     * @param renewalCount
     *        Count for the reservation renewal
     */

    public void setRenewalCount(Integer renewalCount) {
        this.renewalCount = renewalCount;
    }

    /**
     * Count for the reservation renewal
     * 
     * @return Count for the reservation renewal
     */

    public Integer getRenewalCount() {
        return this.renewalCount;
    }

    /**
     * Count for the reservation renewal
     * 
     * @param renewalCount
     *        Count for the reservation renewal
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public RenewalSettings withRenewalCount(Integer renewalCount) {
        setRenewalCount(renewalCount);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getAutomaticRenewal() != null)
            sb.append("AutomaticRenewal: ").append(getAutomaticRenewal()).append(",");
        if (getRenewalCount() != null)
            sb.append("RenewalCount: ").append(getRenewalCount());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof RenewalSettings == false)
            return false;
        RenewalSettings other = (RenewalSettings) obj;
        if (other.getAutomaticRenewal() == null ^ this.getAutomaticRenewal() == null)
            return false;
        if (other.getAutomaticRenewal() != null && other.getAutomaticRenewal().equals(this.getAutomaticRenewal()) == false)
            return false;
        if (other.getRenewalCount() == null ^ this.getRenewalCount() == null)
            return false;
        if (other.getRenewalCount() != null && other.getRenewalCount().equals(this.getRenewalCount()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getAutomaticRenewal() == null) ? 0 : getAutomaticRenewal().hashCode());
        hashCode = prime * hashCode + ((getRenewalCount() == null) ? 0 : getRenewalCount().hashCode());
        return hashCode;
    }

    @Override
    public RenewalSettings clone() {
        try {
            return (RenewalSettings) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.medialive.model.transform.RenewalSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
