/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.nimblestudio.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * A studio member is an association of a user from your studio identity source to elevated permissions that they are
 * granted in the studio.
 * </p>
 * <p>
 * When you add a user to your studio using the Nimble Studio console, they are given access to the studio's IAM
 * Identity Center application and are given access to log in to the Nimble Studio portal. These users have the
 * permissions provided by the studio's user IAM role and do not appear in the studio membership collection. Only studio
 * admins appear in studio membership.
 * </p>
 * <p>
 * When you add a user to studio membership with the persona ADMIN, upon logging in to the Nimble Studio portal, they
 * are granted permissions specified by the Studio's Admin IAM role.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/nimble-2020-08-01/StudioMembership" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class StudioMembership implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The ID of the identity store.
     * </p>
     */
    private String identityStoreId;
    /**
     * <p>
     * The persona.
     * </p>
     */
    private String persona;
    /**
     * <p>
     * The principal ID.
     * </p>
     */
    private String principalId;
    /**
     * <p>
     * The Active Directory Security Identifier for this user, if available.
     * </p>
     */
    private String sid;

    /**
     * <p>
     * The ID of the identity store.
     * </p>
     * 
     * @param identityStoreId
     *        The ID of the identity store.
     */

    public void setIdentityStoreId(String identityStoreId) {
        this.identityStoreId = identityStoreId;
    }

    /**
     * <p>
     * The ID of the identity store.
     * </p>
     * 
     * @return The ID of the identity store.
     */

    public String getIdentityStoreId() {
        return this.identityStoreId;
    }

    /**
     * <p>
     * The ID of the identity store.
     * </p>
     * 
     * @param identityStoreId
     *        The ID of the identity store.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StudioMembership withIdentityStoreId(String identityStoreId) {
        setIdentityStoreId(identityStoreId);
        return this;
    }

    /**
     * <p>
     * The persona.
     * </p>
     * 
     * @param persona
     *        The persona.
     * @see StudioPersona
     */

    public void setPersona(String persona) {
        this.persona = persona;
    }

    /**
     * <p>
     * The persona.
     * </p>
     * 
     * @return The persona.
     * @see StudioPersona
     */

    public String getPersona() {
        return this.persona;
    }

    /**
     * <p>
     * The persona.
     * </p>
     * 
     * @param persona
     *        The persona.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StudioPersona
     */

    public StudioMembership withPersona(String persona) {
        setPersona(persona);
        return this;
    }

    /**
     * <p>
     * The persona.
     * </p>
     * 
     * @param persona
     *        The persona.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StudioPersona
     */

    public StudioMembership withPersona(StudioPersona persona) {
        this.persona = persona.toString();
        return this;
    }

    /**
     * <p>
     * The principal ID.
     * </p>
     * 
     * @param principalId
     *        The principal ID.
     */

    public void setPrincipalId(String principalId) {
        this.principalId = principalId;
    }

    /**
     * <p>
     * The principal ID.
     * </p>
     * 
     * @return The principal ID.
     */

    public String getPrincipalId() {
        return this.principalId;
    }

    /**
     * <p>
     * The principal ID.
     * </p>
     * 
     * @param principalId
     *        The principal ID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StudioMembership withPrincipalId(String principalId) {
        setPrincipalId(principalId);
        return this;
    }

    /**
     * <p>
     * The Active Directory Security Identifier for this user, if available.
     * </p>
     * 
     * @param sid
     *        The Active Directory Security Identifier for this user, if available.
     */

    public void setSid(String sid) {
        this.sid = sid;
    }

    /**
     * <p>
     * The Active Directory Security Identifier for this user, if available.
     * </p>
     * 
     * @return The Active Directory Security Identifier for this user, if available.
     */

    public String getSid() {
        return this.sid;
    }

    /**
     * <p>
     * The Active Directory Security Identifier for this user, if available.
     * </p>
     * 
     * @param sid
     *        The Active Directory Security Identifier for this user, if available.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public StudioMembership withSid(String sid) {
        setSid(sid);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getIdentityStoreId() != null)
            sb.append("IdentityStoreId: ").append(getIdentityStoreId()).append(",");
        if (getPersona() != null)
            sb.append("Persona: ").append(getPersona()).append(",");
        if (getPrincipalId() != null)
            sb.append("PrincipalId: ").append(getPrincipalId()).append(",");
        if (getSid() != null)
            sb.append("Sid: ").append(getSid());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof StudioMembership == false)
            return false;
        StudioMembership other = (StudioMembership) obj;
        if (other.getIdentityStoreId() == null ^ this.getIdentityStoreId() == null)
            return false;
        if (other.getIdentityStoreId() != null && other.getIdentityStoreId().equals(this.getIdentityStoreId()) == false)
            return false;
        if (other.getPersona() == null ^ this.getPersona() == null)
            return false;
        if (other.getPersona() != null && other.getPersona().equals(this.getPersona()) == false)
            return false;
        if (other.getPrincipalId() == null ^ this.getPrincipalId() == null)
            return false;
        if (other.getPrincipalId() != null && other.getPrincipalId().equals(this.getPrincipalId()) == false)
            return false;
        if (other.getSid() == null ^ this.getSid() == null)
            return false;
        if (other.getSid() != null && other.getSid().equals(this.getSid()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getIdentityStoreId() == null) ? 0 : getIdentityStoreId().hashCode());
        hashCode = prime * hashCode + ((getPersona() == null) ? 0 : getPersona().hashCode());
        hashCode = prime * hashCode + ((getPrincipalId() == null) ? 0 : getPrincipalId().hashCode());
        hashCode = prime * hashCode + ((getSid() == null) ? 0 : getSid().hashCode());
        return hashCode;
    }

    @Override
    public StudioMembership clone() {
        try {
            return (StudioMembership) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.nimblestudio.model.transform.StudioMembershipMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
