/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.quicksight.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The experience that you are embedding. You can use this object to generate a url that embeds a visual into your
 * application.
 * </p>
 * 
 * @see <a
 *      href="http://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/AnonymousUserDashboardVisualEmbeddingConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AnonymousUserDashboardVisualEmbeddingConfiguration implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The visual ID for the visual that you want the user to see. This ID is included in the output URL. When the URL
     * in response is accessed, Amazon QuickSight renders this visual.
     * </p>
     * <p>
     * The Amazon Resource Name (ARN) of the dashboard that the visual belongs to must be included in the
     * <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with
     * <code>InvalidParameterValueException</code>.
     * </p>
     */
    private DashboardVisualId initialDashboardVisualId;

    /**
     * <p>
     * The visual ID for the visual that you want the user to see. This ID is included in the output URL. When the URL
     * in response is accessed, Amazon QuickSight renders this visual.
     * </p>
     * <p>
     * The Amazon Resource Name (ARN) of the dashboard that the visual belongs to must be included in the
     * <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with
     * <code>InvalidParameterValueException</code>.
     * </p>
     * 
     * @param initialDashboardVisualId
     *        The visual ID for the visual that you want the user to see. This ID is included in the output URL. When
     *        the URL in response is accessed, Amazon QuickSight renders this visual.</p>
     *        <p>
     *        The Amazon Resource Name (ARN) of the dashboard that the visual belongs to must be included in the
     *        <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with
     *        <code>InvalidParameterValueException</code>.
     */

    public void setInitialDashboardVisualId(DashboardVisualId initialDashboardVisualId) {
        this.initialDashboardVisualId = initialDashboardVisualId;
    }

    /**
     * <p>
     * The visual ID for the visual that you want the user to see. This ID is included in the output URL. When the URL
     * in response is accessed, Amazon QuickSight renders this visual.
     * </p>
     * <p>
     * The Amazon Resource Name (ARN) of the dashboard that the visual belongs to must be included in the
     * <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with
     * <code>InvalidParameterValueException</code>.
     * </p>
     * 
     * @return The visual ID for the visual that you want the user to see. This ID is included in the output URL. When
     *         the URL in response is accessed, Amazon QuickSight renders this visual.</p>
     *         <p>
     *         The Amazon Resource Name (ARN) of the dashboard that the visual belongs to must be included in the
     *         <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with
     *         <code>InvalidParameterValueException</code>.
     */

    public DashboardVisualId getInitialDashboardVisualId() {
        return this.initialDashboardVisualId;
    }

    /**
     * <p>
     * The visual ID for the visual that you want the user to see. This ID is included in the output URL. When the URL
     * in response is accessed, Amazon QuickSight renders this visual.
     * </p>
     * <p>
     * The Amazon Resource Name (ARN) of the dashboard that the visual belongs to must be included in the
     * <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with
     * <code>InvalidParameterValueException</code>.
     * </p>
     * 
     * @param initialDashboardVisualId
     *        The visual ID for the visual that you want the user to see. This ID is included in the output URL. When
     *        the URL in response is accessed, Amazon QuickSight renders this visual.</p>
     *        <p>
     *        The Amazon Resource Name (ARN) of the dashboard that the visual belongs to must be included in the
     *        <code>AuthorizedResourceArns</code> parameter. Otherwise, the request will fail with
     *        <code>InvalidParameterValueException</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AnonymousUserDashboardVisualEmbeddingConfiguration withInitialDashboardVisualId(DashboardVisualId initialDashboardVisualId) {
        setInitialDashboardVisualId(initialDashboardVisualId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getInitialDashboardVisualId() != null)
            sb.append("InitialDashboardVisualId: ").append(getInitialDashboardVisualId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AnonymousUserDashboardVisualEmbeddingConfiguration == false)
            return false;
        AnonymousUserDashboardVisualEmbeddingConfiguration other = (AnonymousUserDashboardVisualEmbeddingConfiguration) obj;
        if (other.getInitialDashboardVisualId() == null ^ this.getInitialDashboardVisualId() == null)
            return false;
        if (other.getInitialDashboardVisualId() != null && other.getInitialDashboardVisualId().equals(this.getInitialDashboardVisualId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getInitialDashboardVisualId() == null) ? 0 : getInitialDashboardVisualId().hashCode());
        return hashCode;
    }

    @Override
    public AnonymousUserDashboardVisualEmbeddingConfiguration clone() {
        try {
            return (AnonymousUserDashboardVisualEmbeddingConfiguration) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.quicksight.model.transform.AnonymousUserDashboardVisualEmbeddingConfigurationMarshaller.getInstance().marshall(this,
                protocolMarshaller);
    }
}
