/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ram.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ram.model.ResourceShareAssociation;
import com.amazonaws.services.ram.model.ResourceShareInvitationStatus;
import com.amazonaws.services.ram.model.transform.ResourceShareInvitationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ResourceShareInvitation
implements Serializable,
Cloneable,
StructuredPojo {
    private String resourceShareInvitationArn;
    private String resourceShareName;
    private String resourceShareArn;
    private String senderAccountId;
    private String receiverAccountId;
    private Date invitationTimestamp;
    private String status;
    private List<ResourceShareAssociation> resourceShareAssociations;

    public void setResourceShareInvitationArn(String resourceShareInvitationArn) {
        this.resourceShareInvitationArn = resourceShareInvitationArn;
    }

    public String getResourceShareInvitationArn() {
        return this.resourceShareInvitationArn;
    }

    public ResourceShareInvitation withResourceShareInvitationArn(String resourceShareInvitationArn) {
        this.setResourceShareInvitationArn(resourceShareInvitationArn);
        return this;
    }

    public void setResourceShareName(String resourceShareName) {
        this.resourceShareName = resourceShareName;
    }

    public String getResourceShareName() {
        return this.resourceShareName;
    }

    public ResourceShareInvitation withResourceShareName(String resourceShareName) {
        this.setResourceShareName(resourceShareName);
        return this;
    }

    public void setResourceShareArn(String resourceShareArn) {
        this.resourceShareArn = resourceShareArn;
    }

    public String getResourceShareArn() {
        return this.resourceShareArn;
    }

    public ResourceShareInvitation withResourceShareArn(String resourceShareArn) {
        this.setResourceShareArn(resourceShareArn);
        return this;
    }

    public void setSenderAccountId(String senderAccountId) {
        this.senderAccountId = senderAccountId;
    }

    public String getSenderAccountId() {
        return this.senderAccountId;
    }

    public ResourceShareInvitation withSenderAccountId(String senderAccountId) {
        this.setSenderAccountId(senderAccountId);
        return this;
    }

    public void setReceiverAccountId(String receiverAccountId) {
        this.receiverAccountId = receiverAccountId;
    }

    public String getReceiverAccountId() {
        return this.receiverAccountId;
    }

    public ResourceShareInvitation withReceiverAccountId(String receiverAccountId) {
        this.setReceiverAccountId(receiverAccountId);
        return this;
    }

    public void setInvitationTimestamp(Date invitationTimestamp) {
        this.invitationTimestamp = invitationTimestamp;
    }

    public Date getInvitationTimestamp() {
        return this.invitationTimestamp;
    }

    public ResourceShareInvitation withInvitationTimestamp(Date invitationTimestamp) {
        this.setInvitationTimestamp(invitationTimestamp);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public ResourceShareInvitation withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public ResourceShareInvitation withStatus(ResourceShareInvitationStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<ResourceShareAssociation> getResourceShareAssociations() {
        return this.resourceShareAssociations;
    }

    public void setResourceShareAssociations(Collection<ResourceShareAssociation> resourceShareAssociations) {
        if (resourceShareAssociations == null) {
            this.resourceShareAssociations = null;
            return;
        }
        this.resourceShareAssociations = new ArrayList<ResourceShareAssociation>(resourceShareAssociations);
    }

    public ResourceShareInvitation withResourceShareAssociations(ResourceShareAssociation ... resourceShareAssociations) {
        if (this.resourceShareAssociations == null) {
            this.setResourceShareAssociations(new ArrayList<ResourceShareAssociation>(resourceShareAssociations.length));
        }
        for (ResourceShareAssociation ele : resourceShareAssociations) {
            this.resourceShareAssociations.add(ele);
        }
        return this;
    }

    public ResourceShareInvitation withResourceShareAssociations(Collection<ResourceShareAssociation> resourceShareAssociations) {
        this.setResourceShareAssociations(resourceShareAssociations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceShareInvitationArn() != null) {
            sb.append("ResourceShareInvitationArn: ").append(this.getResourceShareInvitationArn()).append(",");
        }
        if (this.getResourceShareName() != null) {
            sb.append("ResourceShareName: ").append(this.getResourceShareName()).append(",");
        }
        if (this.getResourceShareArn() != null) {
            sb.append("ResourceShareArn: ").append(this.getResourceShareArn()).append(",");
        }
        if (this.getSenderAccountId() != null) {
            sb.append("SenderAccountId: ").append(this.getSenderAccountId()).append(",");
        }
        if (this.getReceiverAccountId() != null) {
            sb.append("ReceiverAccountId: ").append(this.getReceiverAccountId()).append(",");
        }
        if (this.getInvitationTimestamp() != null) {
            sb.append("InvitationTimestamp: ").append(this.getInvitationTimestamp()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getResourceShareAssociations() != null) {
            sb.append("ResourceShareAssociations: ").append(this.getResourceShareAssociations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceShareInvitation)) {
            return false;
        }
        ResourceShareInvitation other = (ResourceShareInvitation)obj;
        if (other.getResourceShareInvitationArn() == null ^ this.getResourceShareInvitationArn() == null) {
            return false;
        }
        if (other.getResourceShareInvitationArn() != null && !other.getResourceShareInvitationArn().equals(this.getResourceShareInvitationArn())) {
            return false;
        }
        if (other.getResourceShareName() == null ^ this.getResourceShareName() == null) {
            return false;
        }
        if (other.getResourceShareName() != null && !other.getResourceShareName().equals(this.getResourceShareName())) {
            return false;
        }
        if (other.getResourceShareArn() == null ^ this.getResourceShareArn() == null) {
            return false;
        }
        if (other.getResourceShareArn() != null && !other.getResourceShareArn().equals(this.getResourceShareArn())) {
            return false;
        }
        if (other.getSenderAccountId() == null ^ this.getSenderAccountId() == null) {
            return false;
        }
        if (other.getSenderAccountId() != null && !other.getSenderAccountId().equals(this.getSenderAccountId())) {
            return false;
        }
        if (other.getReceiverAccountId() == null ^ this.getReceiverAccountId() == null) {
            return false;
        }
        if (other.getReceiverAccountId() != null && !other.getReceiverAccountId().equals(this.getReceiverAccountId())) {
            return false;
        }
        if (other.getInvitationTimestamp() == null ^ this.getInvitationTimestamp() == null) {
            return false;
        }
        if (other.getInvitationTimestamp() != null && !other.getInvitationTimestamp().equals(this.getInvitationTimestamp())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getResourceShareAssociations() == null ^ this.getResourceShareAssociations() == null) {
            return false;
        }
        return other.getResourceShareAssociations() == null || other.getResourceShareAssociations().equals(this.getResourceShareAssociations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceShareInvitationArn() == null ? 0 : this.getResourceShareInvitationArn().hashCode());
        hashCode = 31 * hashCode + (this.getResourceShareName() == null ? 0 : this.getResourceShareName().hashCode());
        hashCode = 31 * hashCode + (this.getResourceShareArn() == null ? 0 : this.getResourceShareArn().hashCode());
        hashCode = 31 * hashCode + (this.getSenderAccountId() == null ? 0 : this.getSenderAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getReceiverAccountId() == null ? 0 : this.getReceiverAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getInvitationTimestamp() == null ? 0 : this.getInvitationTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getResourceShareAssociations() == null ? 0 : this.getResourceShareAssociations().hashCode());
        return hashCode;
    }

    public ResourceShareInvitation clone() {
        try {
            return (ResourceShareInvitation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResourceShareInvitationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

