/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.ActivityStreamMode;
import com.amazonaws.services.rds.model.ActivityStreamPolicyStatus;
import com.amazonaws.services.rds.model.ActivityStreamStatus;
import com.amazonaws.services.rds.model.AutomationMode;
import com.amazonaws.services.rds.model.DBInstanceAutomatedBackupsReplication;
import com.amazonaws.services.rds.model.DBInstanceRole;
import com.amazonaws.services.rds.model.DBInstanceStatusInfo;
import com.amazonaws.services.rds.model.DBParameterGroupStatus;
import com.amazonaws.services.rds.model.DBSecurityGroupMembership;
import com.amazonaws.services.rds.model.DBSubnetGroup;
import com.amazonaws.services.rds.model.DomainMembership;
import com.amazonaws.services.rds.model.Endpoint;
import com.amazonaws.services.rds.model.OptionGroupMembership;
import com.amazonaws.services.rds.model.PendingModifiedValues;
import com.amazonaws.services.rds.model.ProcessorFeature;
import com.amazonaws.services.rds.model.ReplicaMode;
import com.amazonaws.services.rds.model.Tag;
import com.amazonaws.services.rds.model.VpcSecurityGroupMembership;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class DBInstance
implements Serializable,
Cloneable {
    private String dBInstanceIdentifier;
    private String dBInstanceClass;
    private String engine;
    private String dBInstanceStatus;
    private Date automaticRestartTime;
    private String masterUsername;
    private String dBName;
    private Endpoint endpoint;
    private Integer allocatedStorage;
    private Date instanceCreateTime;
    private String preferredBackupWindow;
    private Integer backupRetentionPeriod;
    private SdkInternalList<DBSecurityGroupMembership> dBSecurityGroups;
    private SdkInternalList<VpcSecurityGroupMembership> vpcSecurityGroups;
    private SdkInternalList<DBParameterGroupStatus> dBParameterGroups;
    private String availabilityZone;
    private DBSubnetGroup dBSubnetGroup;
    private String preferredMaintenanceWindow;
    private PendingModifiedValues pendingModifiedValues;
    private Date latestRestorableTime;
    private Boolean multiAZ;
    private String engineVersion;
    private Boolean autoMinorVersionUpgrade;
    private String readReplicaSourceDBInstanceIdentifier;
    private SdkInternalList<String> readReplicaDBInstanceIdentifiers;
    private SdkInternalList<String> readReplicaDBClusterIdentifiers;
    private String replicaMode;
    private String licenseModel;
    private Integer iops;
    private SdkInternalList<OptionGroupMembership> optionGroupMemberships;
    private String characterSetName;
    private String ncharCharacterSetName;
    private String secondaryAvailabilityZone;
    private Boolean publiclyAccessible;
    private SdkInternalList<DBInstanceStatusInfo> statusInfos;
    private String storageType;
    private String tdeCredentialArn;
    private Integer dbInstancePort;
    private String dBClusterIdentifier;
    private Boolean storageEncrypted;
    private String kmsKeyId;
    private String dbiResourceId;
    private String cACertificateIdentifier;
    private SdkInternalList<DomainMembership> domainMemberships;
    private Boolean copyTagsToSnapshot;
    private Integer monitoringInterval;
    private String enhancedMonitoringResourceArn;
    private String monitoringRoleArn;
    private Integer promotionTier;
    private String dBInstanceArn;
    private String timezone;
    private Boolean iAMDatabaseAuthenticationEnabled;
    private Boolean performanceInsightsEnabled;
    private String performanceInsightsKMSKeyId;
    private Integer performanceInsightsRetentionPeriod;
    private SdkInternalList<String> enabledCloudwatchLogsExports;
    private SdkInternalList<ProcessorFeature> processorFeatures;
    private Boolean deletionProtection;
    private SdkInternalList<DBInstanceRole> associatedRoles;
    private Endpoint listenerEndpoint;
    private Integer maxAllocatedStorage;
    private SdkInternalList<Tag> tagList;
    private SdkInternalList<DBInstanceAutomatedBackupsReplication> dBInstanceAutomatedBackupsReplications;
    private Boolean customerOwnedIpEnabled;
    private String awsBackupRecoveryPointArn;
    private String activityStreamStatus;
    private String activityStreamKmsKeyId;
    private String activityStreamKinesisStreamName;
    private String activityStreamMode;
    private Boolean activityStreamEngineNativeAuditFieldsIncluded;
    private String automationMode;
    private Date resumeFullAutomationModeTime;
    private String customIamInstanceProfile;
    private String backupTarget;
    private String networkType;
    private String activityStreamPolicyStatus;
    private Integer storageThroughput;

    public void setDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
    }

    public String getDBInstanceIdentifier() {
        return this.dBInstanceIdentifier;
    }

    public DBInstance withDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.setDBInstanceIdentifier(dBInstanceIdentifier);
        return this;
    }

    public void setDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
    }

    public String getDBInstanceClass() {
        return this.dBInstanceClass;
    }

    public DBInstance withDBInstanceClass(String dBInstanceClass) {
        this.setDBInstanceClass(dBInstanceClass);
        return this;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getEngine() {
        return this.engine;
    }

    public DBInstance withEngine(String engine) {
        this.setEngine(engine);
        return this;
    }

    public void setDBInstanceStatus(String dBInstanceStatus) {
        this.dBInstanceStatus = dBInstanceStatus;
    }

    public String getDBInstanceStatus() {
        return this.dBInstanceStatus;
    }

    public DBInstance withDBInstanceStatus(String dBInstanceStatus) {
        this.setDBInstanceStatus(dBInstanceStatus);
        return this;
    }

    public void setAutomaticRestartTime(Date automaticRestartTime) {
        this.automaticRestartTime = automaticRestartTime;
    }

    public Date getAutomaticRestartTime() {
        return this.automaticRestartTime;
    }

    public DBInstance withAutomaticRestartTime(Date automaticRestartTime) {
        this.setAutomaticRestartTime(automaticRestartTime);
        return this;
    }

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    public String getMasterUsername() {
        return this.masterUsername;
    }

    public DBInstance withMasterUsername(String masterUsername) {
        this.setMasterUsername(masterUsername);
        return this;
    }

    public void setDBName(String dBName) {
        this.dBName = dBName;
    }

    public String getDBName() {
        return this.dBName;
    }

    public DBInstance withDBName(String dBName) {
        this.setDBName(dBName);
        return this;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public DBInstance withEndpoint(Endpoint endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    public DBInstance withAllocatedStorage(Integer allocatedStorage) {
        this.setAllocatedStorage(allocatedStorage);
        return this;
    }

    public void setInstanceCreateTime(Date instanceCreateTime) {
        this.instanceCreateTime = instanceCreateTime;
    }

    public Date getInstanceCreateTime() {
        return this.instanceCreateTime;
    }

    public DBInstance withInstanceCreateTime(Date instanceCreateTime) {
        this.setInstanceCreateTime(instanceCreateTime);
        return this;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public DBInstance withPreferredBackupWindow(String preferredBackupWindow) {
        this.setPreferredBackupWindow(preferredBackupWindow);
        return this;
    }

    public void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
    }

    public Integer getBackupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public DBInstance withBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.setBackupRetentionPeriod(backupRetentionPeriod);
        return this;
    }

    public List<DBSecurityGroupMembership> getDBSecurityGroups() {
        if (this.dBSecurityGroups == null) {
            this.dBSecurityGroups = new SdkInternalList();
        }
        return this.dBSecurityGroups;
    }

    public void setDBSecurityGroups(Collection<DBSecurityGroupMembership> dBSecurityGroups) {
        if (dBSecurityGroups == null) {
            this.dBSecurityGroups = null;
            return;
        }
        this.dBSecurityGroups = new SdkInternalList(dBSecurityGroups);
    }

    public DBInstance withDBSecurityGroups(DBSecurityGroupMembership ... dBSecurityGroups) {
        if (this.dBSecurityGroups == null) {
            this.setDBSecurityGroups((Collection<DBSecurityGroupMembership>)new SdkInternalList(dBSecurityGroups.length));
        }
        for (DBSecurityGroupMembership ele : dBSecurityGroups) {
            this.dBSecurityGroups.add((Object)ele);
        }
        return this;
    }

    public DBInstance withDBSecurityGroups(Collection<DBSecurityGroupMembership> dBSecurityGroups) {
        this.setDBSecurityGroups(dBSecurityGroups);
        return this;
    }

    public List<VpcSecurityGroupMembership> getVpcSecurityGroups() {
        if (this.vpcSecurityGroups == null) {
            this.vpcSecurityGroups = new SdkInternalList();
        }
        return this.vpcSecurityGroups;
    }

    public void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        if (vpcSecurityGroups == null) {
            this.vpcSecurityGroups = null;
            return;
        }
        this.vpcSecurityGroups = new SdkInternalList(vpcSecurityGroups);
    }

    public DBInstance withVpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
        if (this.vpcSecurityGroups == null) {
            this.setVpcSecurityGroups((Collection<VpcSecurityGroupMembership>)new SdkInternalList(vpcSecurityGroups.length));
        }
        for (VpcSecurityGroupMembership ele : vpcSecurityGroups) {
            this.vpcSecurityGroups.add((Object)ele);
        }
        return this;
    }

    public DBInstance withVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        this.setVpcSecurityGroups(vpcSecurityGroups);
        return this;
    }

    public List<DBParameterGroupStatus> getDBParameterGroups() {
        if (this.dBParameterGroups == null) {
            this.dBParameterGroups = new SdkInternalList();
        }
        return this.dBParameterGroups;
    }

    public void setDBParameterGroups(Collection<DBParameterGroupStatus> dBParameterGroups) {
        if (dBParameterGroups == null) {
            this.dBParameterGroups = null;
            return;
        }
        this.dBParameterGroups = new SdkInternalList(dBParameterGroups);
    }

    public DBInstance withDBParameterGroups(DBParameterGroupStatus ... dBParameterGroups) {
        if (this.dBParameterGroups == null) {
            this.setDBParameterGroups((Collection<DBParameterGroupStatus>)new SdkInternalList(dBParameterGroups.length));
        }
        for (DBParameterGroupStatus ele : dBParameterGroups) {
            this.dBParameterGroups.add((Object)ele);
        }
        return this;
    }

    public DBInstance withDBParameterGroups(Collection<DBParameterGroupStatus> dBParameterGroups) {
        this.setDBParameterGroups(dBParameterGroups);
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public DBInstance withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setDBSubnetGroup(DBSubnetGroup dBSubnetGroup) {
        this.dBSubnetGroup = dBSubnetGroup;
    }

    public DBSubnetGroup getDBSubnetGroup() {
        return this.dBSubnetGroup;
    }

    public DBInstance withDBSubnetGroup(DBSubnetGroup dBSubnetGroup) {
        this.setDBSubnetGroup(dBSubnetGroup);
        return this;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public DBInstance withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    public void setPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public PendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public DBInstance withPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.setPendingModifiedValues(pendingModifiedValues);
        return this;
    }

    public void setLatestRestorableTime(Date latestRestorableTime) {
        this.latestRestorableTime = latestRestorableTime;
    }

    public Date getLatestRestorableTime() {
        return this.latestRestorableTime;
    }

    public DBInstance withLatestRestorableTime(Date latestRestorableTime) {
        this.setLatestRestorableTime(latestRestorableTime);
        return this;
    }

    public void setMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
    }

    public Boolean getMultiAZ() {
        return this.multiAZ;
    }

    public DBInstance withMultiAZ(Boolean multiAZ) {
        this.setMultiAZ(multiAZ);
        return this;
    }

    public Boolean isMultiAZ() {
        return this.multiAZ;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public DBInstance withEngineVersion(String engineVersion) {
        this.setEngineVersion(engineVersion);
        return this;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public DBInstance withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.setAutoMinorVersionUpgrade(autoMinorVersionUpgrade);
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setReadReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier) {
        this.readReplicaSourceDBInstanceIdentifier = readReplicaSourceDBInstanceIdentifier;
    }

    public String getReadReplicaSourceDBInstanceIdentifier() {
        return this.readReplicaSourceDBInstanceIdentifier;
    }

    public DBInstance withReadReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier) {
        this.setReadReplicaSourceDBInstanceIdentifier(readReplicaSourceDBInstanceIdentifier);
        return this;
    }

    public List<String> getReadReplicaDBInstanceIdentifiers() {
        if (this.readReplicaDBInstanceIdentifiers == null) {
            this.readReplicaDBInstanceIdentifiers = new SdkInternalList();
        }
        return this.readReplicaDBInstanceIdentifiers;
    }

    public void setReadReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers) {
        if (readReplicaDBInstanceIdentifiers == null) {
            this.readReplicaDBInstanceIdentifiers = null;
            return;
        }
        this.readReplicaDBInstanceIdentifiers = new SdkInternalList(readReplicaDBInstanceIdentifiers);
    }

    public DBInstance withReadReplicaDBInstanceIdentifiers(String ... readReplicaDBInstanceIdentifiers) {
        if (this.readReplicaDBInstanceIdentifiers == null) {
            this.setReadReplicaDBInstanceIdentifiers((Collection<String>)new SdkInternalList(readReplicaDBInstanceIdentifiers.length));
        }
        for (String ele : readReplicaDBInstanceIdentifiers) {
            this.readReplicaDBInstanceIdentifiers.add((Object)ele);
        }
        return this;
    }

    public DBInstance withReadReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers) {
        this.setReadReplicaDBInstanceIdentifiers(readReplicaDBInstanceIdentifiers);
        return this;
    }

    public List<String> getReadReplicaDBClusterIdentifiers() {
        if (this.readReplicaDBClusterIdentifiers == null) {
            this.readReplicaDBClusterIdentifiers = new SdkInternalList();
        }
        return this.readReplicaDBClusterIdentifiers;
    }

    public void setReadReplicaDBClusterIdentifiers(Collection<String> readReplicaDBClusterIdentifiers) {
        if (readReplicaDBClusterIdentifiers == null) {
            this.readReplicaDBClusterIdentifiers = null;
            return;
        }
        this.readReplicaDBClusterIdentifiers = new SdkInternalList(readReplicaDBClusterIdentifiers);
    }

    public DBInstance withReadReplicaDBClusterIdentifiers(String ... readReplicaDBClusterIdentifiers) {
        if (this.readReplicaDBClusterIdentifiers == null) {
            this.setReadReplicaDBClusterIdentifiers((Collection<String>)new SdkInternalList(readReplicaDBClusterIdentifiers.length));
        }
        for (String ele : readReplicaDBClusterIdentifiers) {
            this.readReplicaDBClusterIdentifiers.add((Object)ele);
        }
        return this;
    }

    public DBInstance withReadReplicaDBClusterIdentifiers(Collection<String> readReplicaDBClusterIdentifiers) {
        this.setReadReplicaDBClusterIdentifiers(readReplicaDBClusterIdentifiers);
        return this;
    }

    public void setReplicaMode(String replicaMode) {
        this.replicaMode = replicaMode;
    }

    public String getReplicaMode() {
        return this.replicaMode;
    }

    public DBInstance withReplicaMode(String replicaMode) {
        this.setReplicaMode(replicaMode);
        return this;
    }

    public DBInstance withReplicaMode(ReplicaMode replicaMode) {
        this.replicaMode = replicaMode.toString();
        return this;
    }

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public DBInstance withLicenseModel(String licenseModel) {
        this.setLicenseModel(licenseModel);
        return this;
    }

    public void setIops(Integer iops) {
        this.iops = iops;
    }

    public Integer getIops() {
        return this.iops;
    }

    public DBInstance withIops(Integer iops) {
        this.setIops(iops);
        return this;
    }

    public List<OptionGroupMembership> getOptionGroupMemberships() {
        if (this.optionGroupMemberships == null) {
            this.optionGroupMemberships = new SdkInternalList();
        }
        return this.optionGroupMemberships;
    }

    public void setOptionGroupMemberships(Collection<OptionGroupMembership> optionGroupMemberships) {
        if (optionGroupMemberships == null) {
            this.optionGroupMemberships = null;
            return;
        }
        this.optionGroupMemberships = new SdkInternalList(optionGroupMemberships);
    }

    public DBInstance withOptionGroupMemberships(OptionGroupMembership ... optionGroupMemberships) {
        if (this.optionGroupMemberships == null) {
            this.setOptionGroupMemberships((Collection<OptionGroupMembership>)new SdkInternalList(optionGroupMemberships.length));
        }
        for (OptionGroupMembership ele : optionGroupMemberships) {
            this.optionGroupMemberships.add((Object)ele);
        }
        return this;
    }

    public DBInstance withOptionGroupMemberships(Collection<OptionGroupMembership> optionGroupMemberships) {
        this.setOptionGroupMemberships(optionGroupMemberships);
        return this;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public DBInstance withCharacterSetName(String characterSetName) {
        this.setCharacterSetName(characterSetName);
        return this;
    }

    public void setNcharCharacterSetName(String ncharCharacterSetName) {
        this.ncharCharacterSetName = ncharCharacterSetName;
    }

    public String getNcharCharacterSetName() {
        return this.ncharCharacterSetName;
    }

    public DBInstance withNcharCharacterSetName(String ncharCharacterSetName) {
        this.setNcharCharacterSetName(ncharCharacterSetName);
        return this;
    }

    public void setSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
        this.secondaryAvailabilityZone = secondaryAvailabilityZone;
    }

    public String getSecondaryAvailabilityZone() {
        return this.secondaryAvailabilityZone;
    }

    public DBInstance withSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
        this.setSecondaryAvailabilityZone(secondaryAvailabilityZone);
        return this;
    }

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public DBInstance withPubliclyAccessible(Boolean publiclyAccessible) {
        this.setPubliclyAccessible(publiclyAccessible);
        return this;
    }

    public Boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public List<DBInstanceStatusInfo> getStatusInfos() {
        if (this.statusInfos == null) {
            this.statusInfos = new SdkInternalList();
        }
        return this.statusInfos;
    }

    public void setStatusInfos(Collection<DBInstanceStatusInfo> statusInfos) {
        if (statusInfos == null) {
            this.statusInfos = null;
            return;
        }
        this.statusInfos = new SdkInternalList(statusInfos);
    }

    public DBInstance withStatusInfos(DBInstanceStatusInfo ... statusInfos) {
        if (this.statusInfos == null) {
            this.setStatusInfos((Collection<DBInstanceStatusInfo>)new SdkInternalList(statusInfos.length));
        }
        for (DBInstanceStatusInfo ele : statusInfos) {
            this.statusInfos.add((Object)ele);
        }
        return this;
    }

    public DBInstance withStatusInfos(Collection<DBInstanceStatusInfo> statusInfos) {
        this.setStatusInfos(statusInfos);
        return this;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public DBInstance withStorageType(String storageType) {
        this.setStorageType(storageType);
        return this;
    }

    public void setTdeCredentialArn(String tdeCredentialArn) {
        this.tdeCredentialArn = tdeCredentialArn;
    }

    public String getTdeCredentialArn() {
        return this.tdeCredentialArn;
    }

    public DBInstance withTdeCredentialArn(String tdeCredentialArn) {
        this.setTdeCredentialArn(tdeCredentialArn);
        return this;
    }

    public void setDbInstancePort(Integer dbInstancePort) {
        this.dbInstancePort = dbInstancePort;
    }

    public Integer getDbInstancePort() {
        return this.dbInstancePort;
    }

    public DBInstance withDbInstancePort(Integer dbInstancePort) {
        this.setDbInstancePort(dbInstancePort);
        return this;
    }

    public void setDBClusterIdentifier(String dBClusterIdentifier) {
        this.dBClusterIdentifier = dBClusterIdentifier;
    }

    public String getDBClusterIdentifier() {
        return this.dBClusterIdentifier;
    }

    public DBInstance withDBClusterIdentifier(String dBClusterIdentifier) {
        this.setDBClusterIdentifier(dBClusterIdentifier);
        return this;
    }

    public void setStorageEncrypted(Boolean storageEncrypted) {
        this.storageEncrypted = storageEncrypted;
    }

    public Boolean getStorageEncrypted() {
        return this.storageEncrypted;
    }

    public DBInstance withStorageEncrypted(Boolean storageEncrypted) {
        this.setStorageEncrypted(storageEncrypted);
        return this;
    }

    public Boolean isStorageEncrypted() {
        return this.storageEncrypted;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public DBInstance withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setDbiResourceId(String dbiResourceId) {
        this.dbiResourceId = dbiResourceId;
    }

    public String getDbiResourceId() {
        return this.dbiResourceId;
    }

    public DBInstance withDbiResourceId(String dbiResourceId) {
        this.setDbiResourceId(dbiResourceId);
        return this;
    }

    public void setCACertificateIdentifier(String cACertificateIdentifier) {
        this.cACertificateIdentifier = cACertificateIdentifier;
    }

    public String getCACertificateIdentifier() {
        return this.cACertificateIdentifier;
    }

    public DBInstance withCACertificateIdentifier(String cACertificateIdentifier) {
        this.setCACertificateIdentifier(cACertificateIdentifier);
        return this;
    }

    public List<DomainMembership> getDomainMemberships() {
        if (this.domainMemberships == null) {
            this.domainMemberships = new SdkInternalList();
        }
        return this.domainMemberships;
    }

    public void setDomainMemberships(Collection<DomainMembership> domainMemberships) {
        if (domainMemberships == null) {
            this.domainMemberships = null;
            return;
        }
        this.domainMemberships = new SdkInternalList(domainMemberships);
    }

    public DBInstance withDomainMemberships(DomainMembership ... domainMemberships) {
        if (this.domainMemberships == null) {
            this.setDomainMemberships((Collection<DomainMembership>)new SdkInternalList(domainMemberships.length));
        }
        for (DomainMembership ele : domainMemberships) {
            this.domainMemberships.add((Object)ele);
        }
        return this;
    }

    public DBInstance withDomainMemberships(Collection<DomainMembership> domainMemberships) {
        this.setDomainMemberships(domainMemberships);
        return this;
    }

    public void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
        this.copyTagsToSnapshot = copyTagsToSnapshot;
    }

    public Boolean getCopyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public DBInstance withCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
        this.setCopyTagsToSnapshot(copyTagsToSnapshot);
        return this;
    }

    public Boolean isCopyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public void setMonitoringInterval(Integer monitoringInterval) {
        this.monitoringInterval = monitoringInterval;
    }

    public Integer getMonitoringInterval() {
        return this.monitoringInterval;
    }

    public DBInstance withMonitoringInterval(Integer monitoringInterval) {
        this.setMonitoringInterval(monitoringInterval);
        return this;
    }

    public void setEnhancedMonitoringResourceArn(String enhancedMonitoringResourceArn) {
        this.enhancedMonitoringResourceArn = enhancedMonitoringResourceArn;
    }

    public String getEnhancedMonitoringResourceArn() {
        return this.enhancedMonitoringResourceArn;
    }

    public DBInstance withEnhancedMonitoringResourceArn(String enhancedMonitoringResourceArn) {
        this.setEnhancedMonitoringResourceArn(enhancedMonitoringResourceArn);
        return this;
    }

    public void setMonitoringRoleArn(String monitoringRoleArn) {
        this.monitoringRoleArn = monitoringRoleArn;
    }

    public String getMonitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public DBInstance withMonitoringRoleArn(String monitoringRoleArn) {
        this.setMonitoringRoleArn(monitoringRoleArn);
        return this;
    }

    public void setPromotionTier(Integer promotionTier) {
        this.promotionTier = promotionTier;
    }

    public Integer getPromotionTier() {
        return this.promotionTier;
    }

    public DBInstance withPromotionTier(Integer promotionTier) {
        this.setPromotionTier(promotionTier);
        return this;
    }

    public void setDBInstanceArn(String dBInstanceArn) {
        this.dBInstanceArn = dBInstanceArn;
    }

    public String getDBInstanceArn() {
        return this.dBInstanceArn;
    }

    public DBInstance withDBInstanceArn(String dBInstanceArn) {
        this.setDBInstanceArn(dBInstanceArn);
        return this;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public DBInstance withTimezone(String timezone) {
        this.setTimezone(timezone);
        return this;
    }

    public void setIAMDatabaseAuthenticationEnabled(Boolean iAMDatabaseAuthenticationEnabled) {
        this.iAMDatabaseAuthenticationEnabled = iAMDatabaseAuthenticationEnabled;
    }

    public Boolean getIAMDatabaseAuthenticationEnabled() {
        return this.iAMDatabaseAuthenticationEnabled;
    }

    public DBInstance withIAMDatabaseAuthenticationEnabled(Boolean iAMDatabaseAuthenticationEnabled) {
        this.setIAMDatabaseAuthenticationEnabled(iAMDatabaseAuthenticationEnabled);
        return this;
    }

    public Boolean isIAMDatabaseAuthenticationEnabled() {
        return this.iAMDatabaseAuthenticationEnabled;
    }

    public void setPerformanceInsightsEnabled(Boolean performanceInsightsEnabled) {
        this.performanceInsightsEnabled = performanceInsightsEnabled;
    }

    public Boolean getPerformanceInsightsEnabled() {
        return this.performanceInsightsEnabled;
    }

    public DBInstance withPerformanceInsightsEnabled(Boolean performanceInsightsEnabled) {
        this.setPerformanceInsightsEnabled(performanceInsightsEnabled);
        return this;
    }

    public Boolean isPerformanceInsightsEnabled() {
        return this.performanceInsightsEnabled;
    }

    public void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
        this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
    }

    public String getPerformanceInsightsKMSKeyId() {
        return this.performanceInsightsKMSKeyId;
    }

    public DBInstance withPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
        this.setPerformanceInsightsKMSKeyId(performanceInsightsKMSKeyId);
        return this;
    }

    public void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
        this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
    }

    public Integer getPerformanceInsightsRetentionPeriod() {
        return this.performanceInsightsRetentionPeriod;
    }

    public DBInstance withPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
        this.setPerformanceInsightsRetentionPeriod(performanceInsightsRetentionPeriod);
        return this;
    }

    public List<String> getEnabledCloudwatchLogsExports() {
        if (this.enabledCloudwatchLogsExports == null) {
            this.enabledCloudwatchLogsExports = new SdkInternalList();
        }
        return this.enabledCloudwatchLogsExports;
    }

    public void setEnabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
        if (enabledCloudwatchLogsExports == null) {
            this.enabledCloudwatchLogsExports = null;
            return;
        }
        this.enabledCloudwatchLogsExports = new SdkInternalList(enabledCloudwatchLogsExports);
    }

    public DBInstance withEnabledCloudwatchLogsExports(String ... enabledCloudwatchLogsExports) {
        if (this.enabledCloudwatchLogsExports == null) {
            this.setEnabledCloudwatchLogsExports((Collection<String>)new SdkInternalList(enabledCloudwatchLogsExports.length));
        }
        for (String ele : enabledCloudwatchLogsExports) {
            this.enabledCloudwatchLogsExports.add((Object)ele);
        }
        return this;
    }

    public DBInstance withEnabledCloudwatchLogsExports(Collection<String> enabledCloudwatchLogsExports) {
        this.setEnabledCloudwatchLogsExports(enabledCloudwatchLogsExports);
        return this;
    }

    public List<ProcessorFeature> getProcessorFeatures() {
        if (this.processorFeatures == null) {
            this.processorFeatures = new SdkInternalList();
        }
        return this.processorFeatures;
    }

    public void setProcessorFeatures(Collection<ProcessorFeature> processorFeatures) {
        if (processorFeatures == null) {
            this.processorFeatures = null;
            return;
        }
        this.processorFeatures = new SdkInternalList(processorFeatures);
    }

    public DBInstance withProcessorFeatures(ProcessorFeature ... processorFeatures) {
        if (this.processorFeatures == null) {
            this.setProcessorFeatures((Collection<ProcessorFeature>)new SdkInternalList(processorFeatures.length));
        }
        for (ProcessorFeature ele : processorFeatures) {
            this.processorFeatures.add((Object)ele);
        }
        return this;
    }

    public DBInstance withProcessorFeatures(Collection<ProcessorFeature> processorFeatures) {
        this.setProcessorFeatures(processorFeatures);
        return this;
    }

    public void setDeletionProtection(Boolean deletionProtection) {
        this.deletionProtection = deletionProtection;
    }

    public Boolean getDeletionProtection() {
        return this.deletionProtection;
    }

    public DBInstance withDeletionProtection(Boolean deletionProtection) {
        this.setDeletionProtection(deletionProtection);
        return this;
    }

    public Boolean isDeletionProtection() {
        return this.deletionProtection;
    }

    public List<DBInstanceRole> getAssociatedRoles() {
        if (this.associatedRoles == null) {
            this.associatedRoles = new SdkInternalList();
        }
        return this.associatedRoles;
    }

    public void setAssociatedRoles(Collection<DBInstanceRole> associatedRoles) {
        if (associatedRoles == null) {
            this.associatedRoles = null;
            return;
        }
        this.associatedRoles = new SdkInternalList(associatedRoles);
    }

    public DBInstance withAssociatedRoles(DBInstanceRole ... associatedRoles) {
        if (this.associatedRoles == null) {
            this.setAssociatedRoles((Collection<DBInstanceRole>)new SdkInternalList(associatedRoles.length));
        }
        for (DBInstanceRole ele : associatedRoles) {
            this.associatedRoles.add((Object)ele);
        }
        return this;
    }

    public DBInstance withAssociatedRoles(Collection<DBInstanceRole> associatedRoles) {
        this.setAssociatedRoles(associatedRoles);
        return this;
    }

    public void setListenerEndpoint(Endpoint listenerEndpoint) {
        this.listenerEndpoint = listenerEndpoint;
    }

    public Endpoint getListenerEndpoint() {
        return this.listenerEndpoint;
    }

    public DBInstance withListenerEndpoint(Endpoint listenerEndpoint) {
        this.setListenerEndpoint(listenerEndpoint);
        return this;
    }

    public void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
        this.maxAllocatedStorage = maxAllocatedStorage;
    }

    public Integer getMaxAllocatedStorage() {
        return this.maxAllocatedStorage;
    }

    public DBInstance withMaxAllocatedStorage(Integer maxAllocatedStorage) {
        this.setMaxAllocatedStorage(maxAllocatedStorage);
        return this;
    }

    public List<Tag> getTagList() {
        if (this.tagList == null) {
            this.tagList = new SdkInternalList();
        }
        return this.tagList;
    }

    public void setTagList(Collection<Tag> tagList) {
        if (tagList == null) {
            this.tagList = null;
            return;
        }
        this.tagList = new SdkInternalList(tagList);
    }

    public DBInstance withTagList(Tag ... tagList) {
        if (this.tagList == null) {
            this.setTagList((Collection<Tag>)new SdkInternalList(tagList.length));
        }
        for (Tag ele : tagList) {
            this.tagList.add((Object)ele);
        }
        return this;
    }

    public DBInstance withTagList(Collection<Tag> tagList) {
        this.setTagList(tagList);
        return this;
    }

    public List<DBInstanceAutomatedBackupsReplication> getDBInstanceAutomatedBackupsReplications() {
        if (this.dBInstanceAutomatedBackupsReplications == null) {
            this.dBInstanceAutomatedBackupsReplications = new SdkInternalList();
        }
        return this.dBInstanceAutomatedBackupsReplications;
    }

    public void setDBInstanceAutomatedBackupsReplications(Collection<DBInstanceAutomatedBackupsReplication> dBInstanceAutomatedBackupsReplications) {
        if (dBInstanceAutomatedBackupsReplications == null) {
            this.dBInstanceAutomatedBackupsReplications = null;
            return;
        }
        this.dBInstanceAutomatedBackupsReplications = new SdkInternalList(dBInstanceAutomatedBackupsReplications);
    }

    public DBInstance withDBInstanceAutomatedBackupsReplications(DBInstanceAutomatedBackupsReplication ... dBInstanceAutomatedBackupsReplications) {
        if (this.dBInstanceAutomatedBackupsReplications == null) {
            this.setDBInstanceAutomatedBackupsReplications((Collection<DBInstanceAutomatedBackupsReplication>)new SdkInternalList(dBInstanceAutomatedBackupsReplications.length));
        }
        for (DBInstanceAutomatedBackupsReplication ele : dBInstanceAutomatedBackupsReplications) {
            this.dBInstanceAutomatedBackupsReplications.add((Object)ele);
        }
        return this;
    }

    public DBInstance withDBInstanceAutomatedBackupsReplications(Collection<DBInstanceAutomatedBackupsReplication> dBInstanceAutomatedBackupsReplications) {
        this.setDBInstanceAutomatedBackupsReplications(dBInstanceAutomatedBackupsReplications);
        return this;
    }

    public void setCustomerOwnedIpEnabled(Boolean customerOwnedIpEnabled) {
        this.customerOwnedIpEnabled = customerOwnedIpEnabled;
    }

    public Boolean getCustomerOwnedIpEnabled() {
        return this.customerOwnedIpEnabled;
    }

    public DBInstance withCustomerOwnedIpEnabled(Boolean customerOwnedIpEnabled) {
        this.setCustomerOwnedIpEnabled(customerOwnedIpEnabled);
        return this;
    }

    public Boolean isCustomerOwnedIpEnabled() {
        return this.customerOwnedIpEnabled;
    }

    public void setAwsBackupRecoveryPointArn(String awsBackupRecoveryPointArn) {
        this.awsBackupRecoveryPointArn = awsBackupRecoveryPointArn;
    }

    public String getAwsBackupRecoveryPointArn() {
        return this.awsBackupRecoveryPointArn;
    }

    public DBInstance withAwsBackupRecoveryPointArn(String awsBackupRecoveryPointArn) {
        this.setAwsBackupRecoveryPointArn(awsBackupRecoveryPointArn);
        return this;
    }

    public void setActivityStreamStatus(String activityStreamStatus) {
        this.activityStreamStatus = activityStreamStatus;
    }

    public String getActivityStreamStatus() {
        return this.activityStreamStatus;
    }

    public DBInstance withActivityStreamStatus(String activityStreamStatus) {
        this.setActivityStreamStatus(activityStreamStatus);
        return this;
    }

    public DBInstance withActivityStreamStatus(ActivityStreamStatus activityStreamStatus) {
        this.activityStreamStatus = activityStreamStatus.toString();
        return this;
    }

    public void setActivityStreamKmsKeyId(String activityStreamKmsKeyId) {
        this.activityStreamKmsKeyId = activityStreamKmsKeyId;
    }

    public String getActivityStreamKmsKeyId() {
        return this.activityStreamKmsKeyId;
    }

    public DBInstance withActivityStreamKmsKeyId(String activityStreamKmsKeyId) {
        this.setActivityStreamKmsKeyId(activityStreamKmsKeyId);
        return this;
    }

    public void setActivityStreamKinesisStreamName(String activityStreamKinesisStreamName) {
        this.activityStreamKinesisStreamName = activityStreamKinesisStreamName;
    }

    public String getActivityStreamKinesisStreamName() {
        return this.activityStreamKinesisStreamName;
    }

    public DBInstance withActivityStreamKinesisStreamName(String activityStreamKinesisStreamName) {
        this.setActivityStreamKinesisStreamName(activityStreamKinesisStreamName);
        return this;
    }

    public void setActivityStreamMode(String activityStreamMode) {
        this.activityStreamMode = activityStreamMode;
    }

    public String getActivityStreamMode() {
        return this.activityStreamMode;
    }

    public DBInstance withActivityStreamMode(String activityStreamMode) {
        this.setActivityStreamMode(activityStreamMode);
        return this;
    }

    public DBInstance withActivityStreamMode(ActivityStreamMode activityStreamMode) {
        this.activityStreamMode = activityStreamMode.toString();
        return this;
    }

    public void setActivityStreamEngineNativeAuditFieldsIncluded(Boolean activityStreamEngineNativeAuditFieldsIncluded) {
        this.activityStreamEngineNativeAuditFieldsIncluded = activityStreamEngineNativeAuditFieldsIncluded;
    }

    public Boolean getActivityStreamEngineNativeAuditFieldsIncluded() {
        return this.activityStreamEngineNativeAuditFieldsIncluded;
    }

    public DBInstance withActivityStreamEngineNativeAuditFieldsIncluded(Boolean activityStreamEngineNativeAuditFieldsIncluded) {
        this.setActivityStreamEngineNativeAuditFieldsIncluded(activityStreamEngineNativeAuditFieldsIncluded);
        return this;
    }

    public Boolean isActivityStreamEngineNativeAuditFieldsIncluded() {
        return this.activityStreamEngineNativeAuditFieldsIncluded;
    }

    public void setAutomationMode(String automationMode) {
        this.automationMode = automationMode;
    }

    public String getAutomationMode() {
        return this.automationMode;
    }

    public DBInstance withAutomationMode(String automationMode) {
        this.setAutomationMode(automationMode);
        return this;
    }

    public DBInstance withAutomationMode(AutomationMode automationMode) {
        this.automationMode = automationMode.toString();
        return this;
    }

    public void setResumeFullAutomationModeTime(Date resumeFullAutomationModeTime) {
        this.resumeFullAutomationModeTime = resumeFullAutomationModeTime;
    }

    public Date getResumeFullAutomationModeTime() {
        return this.resumeFullAutomationModeTime;
    }

    public DBInstance withResumeFullAutomationModeTime(Date resumeFullAutomationModeTime) {
        this.setResumeFullAutomationModeTime(resumeFullAutomationModeTime);
        return this;
    }

    public void setCustomIamInstanceProfile(String customIamInstanceProfile) {
        this.customIamInstanceProfile = customIamInstanceProfile;
    }

    public String getCustomIamInstanceProfile() {
        return this.customIamInstanceProfile;
    }

    public DBInstance withCustomIamInstanceProfile(String customIamInstanceProfile) {
        this.setCustomIamInstanceProfile(customIamInstanceProfile);
        return this;
    }

    public void setBackupTarget(String backupTarget) {
        this.backupTarget = backupTarget;
    }

    public String getBackupTarget() {
        return this.backupTarget;
    }

    public DBInstance withBackupTarget(String backupTarget) {
        this.setBackupTarget(backupTarget);
        return this;
    }

    public void setNetworkType(String networkType) {
        this.networkType = networkType;
    }

    public String getNetworkType() {
        return this.networkType;
    }

    public DBInstance withNetworkType(String networkType) {
        this.setNetworkType(networkType);
        return this;
    }

    public void setActivityStreamPolicyStatus(String activityStreamPolicyStatus) {
        this.activityStreamPolicyStatus = activityStreamPolicyStatus;
    }

    public String getActivityStreamPolicyStatus() {
        return this.activityStreamPolicyStatus;
    }

    public DBInstance withActivityStreamPolicyStatus(String activityStreamPolicyStatus) {
        this.setActivityStreamPolicyStatus(activityStreamPolicyStatus);
        return this;
    }

    public DBInstance withActivityStreamPolicyStatus(ActivityStreamPolicyStatus activityStreamPolicyStatus) {
        this.activityStreamPolicyStatus = activityStreamPolicyStatus.toString();
        return this;
    }

    public void setStorageThroughput(Integer storageThroughput) {
        this.storageThroughput = storageThroughput;
    }

    public Integer getStorageThroughput() {
        return this.storageThroughput;
    }

    public DBInstance withStorageThroughput(Integer storageThroughput) {
        this.setStorageThroughput(storageThroughput);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDBInstanceIdentifier() != null) {
            sb.append("DBInstanceIdentifier: ").append(this.getDBInstanceIdentifier()).append(",");
        }
        if (this.getDBInstanceClass() != null) {
            sb.append("DBInstanceClass: ").append(this.getDBInstanceClass()).append(",");
        }
        if (this.getEngine() != null) {
            sb.append("Engine: ").append(this.getEngine()).append(",");
        }
        if (this.getDBInstanceStatus() != null) {
            sb.append("DBInstanceStatus: ").append(this.getDBInstanceStatus()).append(",");
        }
        if (this.getAutomaticRestartTime() != null) {
            sb.append("AutomaticRestartTime: ").append(this.getAutomaticRestartTime()).append(",");
        }
        if (this.getMasterUsername() != null) {
            sb.append("MasterUsername: ").append(this.getMasterUsername()).append(",");
        }
        if (this.getDBName() != null) {
            sb.append("DBName: ").append(this.getDBName()).append(",");
        }
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: ").append(this.getEndpoint()).append(",");
        }
        if (this.getAllocatedStorage() != null) {
            sb.append("AllocatedStorage: ").append(this.getAllocatedStorage()).append(",");
        }
        if (this.getInstanceCreateTime() != null) {
            sb.append("InstanceCreateTime: ").append(this.getInstanceCreateTime()).append(",");
        }
        if (this.getPreferredBackupWindow() != null) {
            sb.append("PreferredBackupWindow: ").append(this.getPreferredBackupWindow()).append(",");
        }
        if (this.getBackupRetentionPeriod() != null) {
            sb.append("BackupRetentionPeriod: ").append(this.getBackupRetentionPeriod()).append(",");
        }
        if (this.getDBSecurityGroups() != null) {
            sb.append("DBSecurityGroups: ").append(this.getDBSecurityGroups()).append(",");
        }
        if (this.getVpcSecurityGroups() != null) {
            sb.append("VpcSecurityGroups: ").append(this.getVpcSecurityGroups()).append(",");
        }
        if (this.getDBParameterGroups() != null) {
            sb.append("DBParameterGroups: ").append(this.getDBParameterGroups()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getDBSubnetGroup() != null) {
            sb.append("DBSubnetGroup: ").append(this.getDBSubnetGroup()).append(",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.getPreferredMaintenanceWindow()).append(",");
        }
        if (this.getPendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: ").append(this.getPendingModifiedValues()).append(",");
        }
        if (this.getLatestRestorableTime() != null) {
            sb.append("LatestRestorableTime: ").append(this.getLatestRestorableTime()).append(",");
        }
        if (this.getMultiAZ() != null) {
            sb.append("MultiAZ: ").append(this.getMultiAZ()).append(",");
        }
        if (this.getEngineVersion() != null) {
            sb.append("EngineVersion: ").append(this.getEngineVersion()).append(",");
        }
        if (this.getAutoMinorVersionUpgrade() != null) {
            sb.append("AutoMinorVersionUpgrade: ").append(this.getAutoMinorVersionUpgrade()).append(",");
        }
        if (this.getReadReplicaSourceDBInstanceIdentifier() != null) {
            sb.append("ReadReplicaSourceDBInstanceIdentifier: ").append(this.getReadReplicaSourceDBInstanceIdentifier()).append(",");
        }
        if (this.getReadReplicaDBInstanceIdentifiers() != null) {
            sb.append("ReadReplicaDBInstanceIdentifiers: ").append(this.getReadReplicaDBInstanceIdentifiers()).append(",");
        }
        if (this.getReadReplicaDBClusterIdentifiers() != null) {
            sb.append("ReadReplicaDBClusterIdentifiers: ").append(this.getReadReplicaDBClusterIdentifiers()).append(",");
        }
        if (this.getReplicaMode() != null) {
            sb.append("ReplicaMode: ").append(this.getReplicaMode()).append(",");
        }
        if (this.getLicenseModel() != null) {
            sb.append("LicenseModel: ").append(this.getLicenseModel()).append(",");
        }
        if (this.getIops() != null) {
            sb.append("Iops: ").append(this.getIops()).append(",");
        }
        if (this.getOptionGroupMemberships() != null) {
            sb.append("OptionGroupMemberships: ").append(this.getOptionGroupMemberships()).append(",");
        }
        if (this.getCharacterSetName() != null) {
            sb.append("CharacterSetName: ").append(this.getCharacterSetName()).append(",");
        }
        if (this.getNcharCharacterSetName() != null) {
            sb.append("NcharCharacterSetName: ").append(this.getNcharCharacterSetName()).append(",");
        }
        if (this.getSecondaryAvailabilityZone() != null) {
            sb.append("SecondaryAvailabilityZone: ").append(this.getSecondaryAvailabilityZone()).append(",");
        }
        if (this.getPubliclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.getPubliclyAccessible()).append(",");
        }
        if (this.getStatusInfos() != null) {
            sb.append("StatusInfos: ").append(this.getStatusInfos()).append(",");
        }
        if (this.getStorageType() != null) {
            sb.append("StorageType: ").append(this.getStorageType()).append(",");
        }
        if (this.getTdeCredentialArn() != null) {
            sb.append("TdeCredentialArn: ").append(this.getTdeCredentialArn()).append(",");
        }
        if (this.getDbInstancePort() != null) {
            sb.append("DbInstancePort: ").append(this.getDbInstancePort()).append(",");
        }
        if (this.getDBClusterIdentifier() != null) {
            sb.append("DBClusterIdentifier: ").append(this.getDBClusterIdentifier()).append(",");
        }
        if (this.getStorageEncrypted() != null) {
            sb.append("StorageEncrypted: ").append(this.getStorageEncrypted()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getDbiResourceId() != null) {
            sb.append("DbiResourceId: ").append(this.getDbiResourceId()).append(",");
        }
        if (this.getCACertificateIdentifier() != null) {
            sb.append("CACertificateIdentifier: ").append(this.getCACertificateIdentifier()).append(",");
        }
        if (this.getDomainMemberships() != null) {
            sb.append("DomainMemberships: ").append(this.getDomainMemberships()).append(",");
        }
        if (this.getCopyTagsToSnapshot() != null) {
            sb.append("CopyTagsToSnapshot: ").append(this.getCopyTagsToSnapshot()).append(",");
        }
        if (this.getMonitoringInterval() != null) {
            sb.append("MonitoringInterval: ").append(this.getMonitoringInterval()).append(",");
        }
        if (this.getEnhancedMonitoringResourceArn() != null) {
            sb.append("EnhancedMonitoringResourceArn: ").append(this.getEnhancedMonitoringResourceArn()).append(",");
        }
        if (this.getMonitoringRoleArn() != null) {
            sb.append("MonitoringRoleArn: ").append(this.getMonitoringRoleArn()).append(",");
        }
        if (this.getPromotionTier() != null) {
            sb.append("PromotionTier: ").append(this.getPromotionTier()).append(",");
        }
        if (this.getDBInstanceArn() != null) {
            sb.append("DBInstanceArn: ").append(this.getDBInstanceArn()).append(",");
        }
        if (this.getTimezone() != null) {
            sb.append("Timezone: ").append(this.getTimezone()).append(",");
        }
        if (this.getIAMDatabaseAuthenticationEnabled() != null) {
            sb.append("IAMDatabaseAuthenticationEnabled: ").append(this.getIAMDatabaseAuthenticationEnabled()).append(",");
        }
        if (this.getPerformanceInsightsEnabled() != null) {
            sb.append("PerformanceInsightsEnabled: ").append(this.getPerformanceInsightsEnabled()).append(",");
        }
        if (this.getPerformanceInsightsKMSKeyId() != null) {
            sb.append("PerformanceInsightsKMSKeyId: ").append(this.getPerformanceInsightsKMSKeyId()).append(",");
        }
        if (this.getPerformanceInsightsRetentionPeriod() != null) {
            sb.append("PerformanceInsightsRetentionPeriod: ").append(this.getPerformanceInsightsRetentionPeriod()).append(",");
        }
        if (this.getEnabledCloudwatchLogsExports() != null) {
            sb.append("EnabledCloudwatchLogsExports: ").append(this.getEnabledCloudwatchLogsExports()).append(",");
        }
        if (this.getProcessorFeatures() != null) {
            sb.append("ProcessorFeatures: ").append(this.getProcessorFeatures()).append(",");
        }
        if (this.getDeletionProtection() != null) {
            sb.append("DeletionProtection: ").append(this.getDeletionProtection()).append(",");
        }
        if (this.getAssociatedRoles() != null) {
            sb.append("AssociatedRoles: ").append(this.getAssociatedRoles()).append(",");
        }
        if (this.getListenerEndpoint() != null) {
            sb.append("ListenerEndpoint: ").append(this.getListenerEndpoint()).append(",");
        }
        if (this.getMaxAllocatedStorage() != null) {
            sb.append("MaxAllocatedStorage: ").append(this.getMaxAllocatedStorage()).append(",");
        }
        if (this.getTagList() != null) {
            sb.append("TagList: ").append(this.getTagList()).append(",");
        }
        if (this.getDBInstanceAutomatedBackupsReplications() != null) {
            sb.append("DBInstanceAutomatedBackupsReplications: ").append(this.getDBInstanceAutomatedBackupsReplications()).append(",");
        }
        if (this.getCustomerOwnedIpEnabled() != null) {
            sb.append("CustomerOwnedIpEnabled: ").append(this.getCustomerOwnedIpEnabled()).append(",");
        }
        if (this.getAwsBackupRecoveryPointArn() != null) {
            sb.append("AwsBackupRecoveryPointArn: ").append(this.getAwsBackupRecoveryPointArn()).append(",");
        }
        if (this.getActivityStreamStatus() != null) {
            sb.append("ActivityStreamStatus: ").append(this.getActivityStreamStatus()).append(",");
        }
        if (this.getActivityStreamKmsKeyId() != null) {
            sb.append("ActivityStreamKmsKeyId: ").append(this.getActivityStreamKmsKeyId()).append(",");
        }
        if (this.getActivityStreamKinesisStreamName() != null) {
            sb.append("ActivityStreamKinesisStreamName: ").append(this.getActivityStreamKinesisStreamName()).append(",");
        }
        if (this.getActivityStreamMode() != null) {
            sb.append("ActivityStreamMode: ").append(this.getActivityStreamMode()).append(",");
        }
        if (this.getActivityStreamEngineNativeAuditFieldsIncluded() != null) {
            sb.append("ActivityStreamEngineNativeAuditFieldsIncluded: ").append(this.getActivityStreamEngineNativeAuditFieldsIncluded()).append(",");
        }
        if (this.getAutomationMode() != null) {
            sb.append("AutomationMode: ").append(this.getAutomationMode()).append(",");
        }
        if (this.getResumeFullAutomationModeTime() != null) {
            sb.append("ResumeFullAutomationModeTime: ").append(this.getResumeFullAutomationModeTime()).append(",");
        }
        if (this.getCustomIamInstanceProfile() != null) {
            sb.append("CustomIamInstanceProfile: ").append(this.getCustomIamInstanceProfile()).append(",");
        }
        if (this.getBackupTarget() != null) {
            sb.append("BackupTarget: ").append(this.getBackupTarget()).append(",");
        }
        if (this.getNetworkType() != null) {
            sb.append("NetworkType: ").append(this.getNetworkType()).append(",");
        }
        if (this.getActivityStreamPolicyStatus() != null) {
            sb.append("ActivityStreamPolicyStatus: ").append(this.getActivityStreamPolicyStatus()).append(",");
        }
        if (this.getStorageThroughput() != null) {
            sb.append("StorageThroughput: ").append(this.getStorageThroughput());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBInstance)) {
            return false;
        }
        DBInstance other = (DBInstance)obj;
        if (other.getDBInstanceIdentifier() == null ^ this.getDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.getDBInstanceIdentifier() != null && !other.getDBInstanceIdentifier().equals(this.getDBInstanceIdentifier())) {
            return false;
        }
        if (other.getDBInstanceClass() == null ^ this.getDBInstanceClass() == null) {
            return false;
        }
        if (other.getDBInstanceClass() != null && !other.getDBInstanceClass().equals(this.getDBInstanceClass())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getDBInstanceStatus() == null ^ this.getDBInstanceStatus() == null) {
            return false;
        }
        if (other.getDBInstanceStatus() != null && !other.getDBInstanceStatus().equals(this.getDBInstanceStatus())) {
            return false;
        }
        if (other.getAutomaticRestartTime() == null ^ this.getAutomaticRestartTime() == null) {
            return false;
        }
        if (other.getAutomaticRestartTime() != null && !other.getAutomaticRestartTime().equals(this.getAutomaticRestartTime())) {
            return false;
        }
        if (other.getMasterUsername() == null ^ this.getMasterUsername() == null) {
            return false;
        }
        if (other.getMasterUsername() != null && !other.getMasterUsername().equals(this.getMasterUsername())) {
            return false;
        }
        if (other.getDBName() == null ^ this.getDBName() == null) {
            return false;
        }
        if (other.getDBName() != null && !other.getDBName().equals(this.getDBName())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getAllocatedStorage() == null ^ this.getAllocatedStorage() == null) {
            return false;
        }
        if (other.getAllocatedStorage() != null && !other.getAllocatedStorage().equals(this.getAllocatedStorage())) {
            return false;
        }
        if (other.getInstanceCreateTime() == null ^ this.getInstanceCreateTime() == null) {
            return false;
        }
        if (other.getInstanceCreateTime() != null && !other.getInstanceCreateTime().equals(this.getInstanceCreateTime())) {
            return false;
        }
        if (other.getPreferredBackupWindow() == null ^ this.getPreferredBackupWindow() == null) {
            return false;
        }
        if (other.getPreferredBackupWindow() != null && !other.getPreferredBackupWindow().equals(this.getPreferredBackupWindow())) {
            return false;
        }
        if (other.getBackupRetentionPeriod() == null ^ this.getBackupRetentionPeriod() == null) {
            return false;
        }
        if (other.getBackupRetentionPeriod() != null && !other.getBackupRetentionPeriod().equals(this.getBackupRetentionPeriod())) {
            return false;
        }
        if (other.getDBSecurityGroups() == null ^ this.getDBSecurityGroups() == null) {
            return false;
        }
        if (other.getDBSecurityGroups() != null && !other.getDBSecurityGroups().equals(this.getDBSecurityGroups())) {
            return false;
        }
        if (other.getVpcSecurityGroups() == null ^ this.getVpcSecurityGroups() == null) {
            return false;
        }
        if (other.getVpcSecurityGroups() != null && !other.getVpcSecurityGroups().equals(this.getVpcSecurityGroups())) {
            return false;
        }
        if (other.getDBParameterGroups() == null ^ this.getDBParameterGroups() == null) {
            return false;
        }
        if (other.getDBParameterGroups() != null && !other.getDBParameterGroups().equals(this.getDBParameterGroups())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getDBSubnetGroup() == null ^ this.getDBSubnetGroup() == null) {
            return false;
        }
        if (other.getDBSubnetGroup() != null && !other.getDBSubnetGroup().equals(this.getDBSubnetGroup())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getLatestRestorableTime() == null ^ this.getLatestRestorableTime() == null) {
            return false;
        }
        if (other.getLatestRestorableTime() != null && !other.getLatestRestorableTime().equals(this.getLatestRestorableTime())) {
            return false;
        }
        if (other.getMultiAZ() == null ^ this.getMultiAZ() == null) {
            return false;
        }
        if (other.getMultiAZ() != null && !other.getMultiAZ().equals(this.getMultiAZ())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() == null ^ this.getAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.getAutoMinorVersionUpgrade() != null && !other.getAutoMinorVersionUpgrade().equals(this.getAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getReadReplicaSourceDBInstanceIdentifier() == null ^ this.getReadReplicaSourceDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.getReadReplicaSourceDBInstanceIdentifier() != null && !other.getReadReplicaSourceDBInstanceIdentifier().equals(this.getReadReplicaSourceDBInstanceIdentifier())) {
            return false;
        }
        if (other.getReadReplicaDBInstanceIdentifiers() == null ^ this.getReadReplicaDBInstanceIdentifiers() == null) {
            return false;
        }
        if (other.getReadReplicaDBInstanceIdentifiers() != null && !other.getReadReplicaDBInstanceIdentifiers().equals(this.getReadReplicaDBInstanceIdentifiers())) {
            return false;
        }
        if (other.getReadReplicaDBClusterIdentifiers() == null ^ this.getReadReplicaDBClusterIdentifiers() == null) {
            return false;
        }
        if (other.getReadReplicaDBClusterIdentifiers() != null && !other.getReadReplicaDBClusterIdentifiers().equals(this.getReadReplicaDBClusterIdentifiers())) {
            return false;
        }
        if (other.getReplicaMode() == null ^ this.getReplicaMode() == null) {
            return false;
        }
        if (other.getReplicaMode() != null && !other.getReplicaMode().equals(this.getReplicaMode())) {
            return false;
        }
        if (other.getLicenseModel() == null ^ this.getLicenseModel() == null) {
            return false;
        }
        if (other.getLicenseModel() != null && !other.getLicenseModel().equals(this.getLicenseModel())) {
            return false;
        }
        if (other.getIops() == null ^ this.getIops() == null) {
            return false;
        }
        if (other.getIops() != null && !other.getIops().equals(this.getIops())) {
            return false;
        }
        if (other.getOptionGroupMemberships() == null ^ this.getOptionGroupMemberships() == null) {
            return false;
        }
        if (other.getOptionGroupMemberships() != null && !other.getOptionGroupMemberships().equals(this.getOptionGroupMemberships())) {
            return false;
        }
        if (other.getCharacterSetName() == null ^ this.getCharacterSetName() == null) {
            return false;
        }
        if (other.getCharacterSetName() != null && !other.getCharacterSetName().equals(this.getCharacterSetName())) {
            return false;
        }
        if (other.getNcharCharacterSetName() == null ^ this.getNcharCharacterSetName() == null) {
            return false;
        }
        if (other.getNcharCharacterSetName() != null && !other.getNcharCharacterSetName().equals(this.getNcharCharacterSetName())) {
            return false;
        }
        if (other.getSecondaryAvailabilityZone() == null ^ this.getSecondaryAvailabilityZone() == null) {
            return false;
        }
        if (other.getSecondaryAvailabilityZone() != null && !other.getSecondaryAvailabilityZone().equals(this.getSecondaryAvailabilityZone())) {
            return false;
        }
        if (other.getPubliclyAccessible() == null ^ this.getPubliclyAccessible() == null) {
            return false;
        }
        if (other.getPubliclyAccessible() != null && !other.getPubliclyAccessible().equals(this.getPubliclyAccessible())) {
            return false;
        }
        if (other.getStatusInfos() == null ^ this.getStatusInfos() == null) {
            return false;
        }
        if (other.getStatusInfos() != null && !other.getStatusInfos().equals(this.getStatusInfos())) {
            return false;
        }
        if (other.getStorageType() == null ^ this.getStorageType() == null) {
            return false;
        }
        if (other.getStorageType() != null && !other.getStorageType().equals(this.getStorageType())) {
            return false;
        }
        if (other.getTdeCredentialArn() == null ^ this.getTdeCredentialArn() == null) {
            return false;
        }
        if (other.getTdeCredentialArn() != null && !other.getTdeCredentialArn().equals(this.getTdeCredentialArn())) {
            return false;
        }
        if (other.getDbInstancePort() == null ^ this.getDbInstancePort() == null) {
            return false;
        }
        if (other.getDbInstancePort() != null && !other.getDbInstancePort().equals(this.getDbInstancePort())) {
            return false;
        }
        if (other.getDBClusterIdentifier() == null ^ this.getDBClusterIdentifier() == null) {
            return false;
        }
        if (other.getDBClusterIdentifier() != null && !other.getDBClusterIdentifier().equals(this.getDBClusterIdentifier())) {
            return false;
        }
        if (other.getStorageEncrypted() == null ^ this.getStorageEncrypted() == null) {
            return false;
        }
        if (other.getStorageEncrypted() != null && !other.getStorageEncrypted().equals(this.getStorageEncrypted())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getDbiResourceId() == null ^ this.getDbiResourceId() == null) {
            return false;
        }
        if (other.getDbiResourceId() != null && !other.getDbiResourceId().equals(this.getDbiResourceId())) {
            return false;
        }
        if (other.getCACertificateIdentifier() == null ^ this.getCACertificateIdentifier() == null) {
            return false;
        }
        if (other.getCACertificateIdentifier() != null && !other.getCACertificateIdentifier().equals(this.getCACertificateIdentifier())) {
            return false;
        }
        if (other.getDomainMemberships() == null ^ this.getDomainMemberships() == null) {
            return false;
        }
        if (other.getDomainMemberships() != null && !other.getDomainMemberships().equals(this.getDomainMemberships())) {
            return false;
        }
        if (other.getCopyTagsToSnapshot() == null ^ this.getCopyTagsToSnapshot() == null) {
            return false;
        }
        if (other.getCopyTagsToSnapshot() != null && !other.getCopyTagsToSnapshot().equals(this.getCopyTagsToSnapshot())) {
            return false;
        }
        if (other.getMonitoringInterval() == null ^ this.getMonitoringInterval() == null) {
            return false;
        }
        if (other.getMonitoringInterval() != null && !other.getMonitoringInterval().equals(this.getMonitoringInterval())) {
            return false;
        }
        if (other.getEnhancedMonitoringResourceArn() == null ^ this.getEnhancedMonitoringResourceArn() == null) {
            return false;
        }
        if (other.getEnhancedMonitoringResourceArn() != null && !other.getEnhancedMonitoringResourceArn().equals(this.getEnhancedMonitoringResourceArn())) {
            return false;
        }
        if (other.getMonitoringRoleArn() == null ^ this.getMonitoringRoleArn() == null) {
            return false;
        }
        if (other.getMonitoringRoleArn() != null && !other.getMonitoringRoleArn().equals(this.getMonitoringRoleArn())) {
            return false;
        }
        if (other.getPromotionTier() == null ^ this.getPromotionTier() == null) {
            return false;
        }
        if (other.getPromotionTier() != null && !other.getPromotionTier().equals(this.getPromotionTier())) {
            return false;
        }
        if (other.getDBInstanceArn() == null ^ this.getDBInstanceArn() == null) {
            return false;
        }
        if (other.getDBInstanceArn() != null && !other.getDBInstanceArn().equals(this.getDBInstanceArn())) {
            return false;
        }
        if (other.getTimezone() == null ^ this.getTimezone() == null) {
            return false;
        }
        if (other.getTimezone() != null && !other.getTimezone().equals(this.getTimezone())) {
            return false;
        }
        if (other.getIAMDatabaseAuthenticationEnabled() == null ^ this.getIAMDatabaseAuthenticationEnabled() == null) {
            return false;
        }
        if (other.getIAMDatabaseAuthenticationEnabled() != null && !other.getIAMDatabaseAuthenticationEnabled().equals(this.getIAMDatabaseAuthenticationEnabled())) {
            return false;
        }
        if (other.getPerformanceInsightsEnabled() == null ^ this.getPerformanceInsightsEnabled() == null) {
            return false;
        }
        if (other.getPerformanceInsightsEnabled() != null && !other.getPerformanceInsightsEnabled().equals(this.getPerformanceInsightsEnabled())) {
            return false;
        }
        if (other.getPerformanceInsightsKMSKeyId() == null ^ this.getPerformanceInsightsKMSKeyId() == null) {
            return false;
        }
        if (other.getPerformanceInsightsKMSKeyId() != null && !other.getPerformanceInsightsKMSKeyId().equals(this.getPerformanceInsightsKMSKeyId())) {
            return false;
        }
        if (other.getPerformanceInsightsRetentionPeriod() == null ^ this.getPerformanceInsightsRetentionPeriod() == null) {
            return false;
        }
        if (other.getPerformanceInsightsRetentionPeriod() != null && !other.getPerformanceInsightsRetentionPeriod().equals(this.getPerformanceInsightsRetentionPeriod())) {
            return false;
        }
        if (other.getEnabledCloudwatchLogsExports() == null ^ this.getEnabledCloudwatchLogsExports() == null) {
            return false;
        }
        if (other.getEnabledCloudwatchLogsExports() != null && !other.getEnabledCloudwatchLogsExports().equals(this.getEnabledCloudwatchLogsExports())) {
            return false;
        }
        if (other.getProcessorFeatures() == null ^ this.getProcessorFeatures() == null) {
            return false;
        }
        if (other.getProcessorFeatures() != null && !other.getProcessorFeatures().equals(this.getProcessorFeatures())) {
            return false;
        }
        if (other.getDeletionProtection() == null ^ this.getDeletionProtection() == null) {
            return false;
        }
        if (other.getDeletionProtection() != null && !other.getDeletionProtection().equals(this.getDeletionProtection())) {
            return false;
        }
        if (other.getAssociatedRoles() == null ^ this.getAssociatedRoles() == null) {
            return false;
        }
        if (other.getAssociatedRoles() != null && !other.getAssociatedRoles().equals(this.getAssociatedRoles())) {
            return false;
        }
        if (other.getListenerEndpoint() == null ^ this.getListenerEndpoint() == null) {
            return false;
        }
        if (other.getListenerEndpoint() != null && !other.getListenerEndpoint().equals(this.getListenerEndpoint())) {
            return false;
        }
        if (other.getMaxAllocatedStorage() == null ^ this.getMaxAllocatedStorage() == null) {
            return false;
        }
        if (other.getMaxAllocatedStorage() != null && !other.getMaxAllocatedStorage().equals(this.getMaxAllocatedStorage())) {
            return false;
        }
        if (other.getTagList() == null ^ this.getTagList() == null) {
            return false;
        }
        if (other.getTagList() != null && !other.getTagList().equals(this.getTagList())) {
            return false;
        }
        if (other.getDBInstanceAutomatedBackupsReplications() == null ^ this.getDBInstanceAutomatedBackupsReplications() == null) {
            return false;
        }
        if (other.getDBInstanceAutomatedBackupsReplications() != null && !other.getDBInstanceAutomatedBackupsReplications().equals(this.getDBInstanceAutomatedBackupsReplications())) {
            return false;
        }
        if (other.getCustomerOwnedIpEnabled() == null ^ this.getCustomerOwnedIpEnabled() == null) {
            return false;
        }
        if (other.getCustomerOwnedIpEnabled() != null && !other.getCustomerOwnedIpEnabled().equals(this.getCustomerOwnedIpEnabled())) {
            return false;
        }
        if (other.getAwsBackupRecoveryPointArn() == null ^ this.getAwsBackupRecoveryPointArn() == null) {
            return false;
        }
        if (other.getAwsBackupRecoveryPointArn() != null && !other.getAwsBackupRecoveryPointArn().equals(this.getAwsBackupRecoveryPointArn())) {
            return false;
        }
        if (other.getActivityStreamStatus() == null ^ this.getActivityStreamStatus() == null) {
            return false;
        }
        if (other.getActivityStreamStatus() != null && !other.getActivityStreamStatus().equals(this.getActivityStreamStatus())) {
            return false;
        }
        if (other.getActivityStreamKmsKeyId() == null ^ this.getActivityStreamKmsKeyId() == null) {
            return false;
        }
        if (other.getActivityStreamKmsKeyId() != null && !other.getActivityStreamKmsKeyId().equals(this.getActivityStreamKmsKeyId())) {
            return false;
        }
        if (other.getActivityStreamKinesisStreamName() == null ^ this.getActivityStreamKinesisStreamName() == null) {
            return false;
        }
        if (other.getActivityStreamKinesisStreamName() != null && !other.getActivityStreamKinesisStreamName().equals(this.getActivityStreamKinesisStreamName())) {
            return false;
        }
        if (other.getActivityStreamMode() == null ^ this.getActivityStreamMode() == null) {
            return false;
        }
        if (other.getActivityStreamMode() != null && !other.getActivityStreamMode().equals(this.getActivityStreamMode())) {
            return false;
        }
        if (other.getActivityStreamEngineNativeAuditFieldsIncluded() == null ^ this.getActivityStreamEngineNativeAuditFieldsIncluded() == null) {
            return false;
        }
        if (other.getActivityStreamEngineNativeAuditFieldsIncluded() != null && !other.getActivityStreamEngineNativeAuditFieldsIncluded().equals(this.getActivityStreamEngineNativeAuditFieldsIncluded())) {
            return false;
        }
        if (other.getAutomationMode() == null ^ this.getAutomationMode() == null) {
            return false;
        }
        if (other.getAutomationMode() != null && !other.getAutomationMode().equals(this.getAutomationMode())) {
            return false;
        }
        if (other.getResumeFullAutomationModeTime() == null ^ this.getResumeFullAutomationModeTime() == null) {
            return false;
        }
        if (other.getResumeFullAutomationModeTime() != null && !other.getResumeFullAutomationModeTime().equals(this.getResumeFullAutomationModeTime())) {
            return false;
        }
        if (other.getCustomIamInstanceProfile() == null ^ this.getCustomIamInstanceProfile() == null) {
            return false;
        }
        if (other.getCustomIamInstanceProfile() != null && !other.getCustomIamInstanceProfile().equals(this.getCustomIamInstanceProfile())) {
            return false;
        }
        if (other.getBackupTarget() == null ^ this.getBackupTarget() == null) {
            return false;
        }
        if (other.getBackupTarget() != null && !other.getBackupTarget().equals(this.getBackupTarget())) {
            return false;
        }
        if (other.getNetworkType() == null ^ this.getNetworkType() == null) {
            return false;
        }
        if (other.getNetworkType() != null && !other.getNetworkType().equals(this.getNetworkType())) {
            return false;
        }
        if (other.getActivityStreamPolicyStatus() == null ^ this.getActivityStreamPolicyStatus() == null) {
            return false;
        }
        if (other.getActivityStreamPolicyStatus() != null && !other.getActivityStreamPolicyStatus().equals(this.getActivityStreamPolicyStatus())) {
            return false;
        }
        if (other.getStorageThroughput() == null ^ this.getStorageThroughput() == null) {
            return false;
        }
        return other.getStorageThroughput() == null || other.getStorageThroughput().equals(this.getStorageThroughput());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBInstanceIdentifier() == null ? 0 : this.getDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceClass() == null ? 0 : this.getDBInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceStatus() == null ? 0 : this.getDBInstanceStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAutomaticRestartTime() == null ? 0 : this.getAutomaticRestartTime().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUsername() == null ? 0 : this.getMasterUsername().hashCode());
        hashCode = 31 * hashCode + (this.getDBName() == null ? 0 : this.getDBName().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getAllocatedStorage() == null ? 0 : this.getAllocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCreateTime() == null ? 0 : this.getInstanceCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredBackupWindow() == null ? 0 : this.getPreferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.getBackupRetentionPeriod() == null ? 0 : this.getBackupRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getDBSecurityGroups() == null ? 0 : this.getDBSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroups() == null ? 0 : this.getVpcSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getDBParameterGroups() == null ? 0 : this.getDBParameterGroups().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getDBSubnetGroup() == null ? 0 : this.getDBSubnetGroup().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getLatestRestorableTime() == null ? 0 : this.getLatestRestorableTime().hashCode());
        hashCode = 31 * hashCode + (this.getMultiAZ() == null ? 0 : this.getMultiAZ().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAutoMinorVersionUpgrade() == null ? 0 : this.getAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getReadReplicaSourceDBInstanceIdentifier() == null ? 0 : this.getReadReplicaSourceDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getReadReplicaDBInstanceIdentifiers() == null ? 0 : this.getReadReplicaDBInstanceIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getReadReplicaDBClusterIdentifiers() == null ? 0 : this.getReadReplicaDBClusterIdentifiers().hashCode());
        hashCode = 31 * hashCode + (this.getReplicaMode() == null ? 0 : this.getReplicaMode().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseModel() == null ? 0 : this.getLicenseModel().hashCode());
        hashCode = 31 * hashCode + (this.getIops() == null ? 0 : this.getIops().hashCode());
        hashCode = 31 * hashCode + (this.getOptionGroupMemberships() == null ? 0 : this.getOptionGroupMemberships().hashCode());
        hashCode = 31 * hashCode + (this.getCharacterSetName() == null ? 0 : this.getCharacterSetName().hashCode());
        hashCode = 31 * hashCode + (this.getNcharCharacterSetName() == null ? 0 : this.getNcharCharacterSetName().hashCode());
        hashCode = 31 * hashCode + (this.getSecondaryAvailabilityZone() == null ? 0 : this.getSecondaryAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getPubliclyAccessible() == null ? 0 : this.getPubliclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.getStatusInfos() == null ? 0 : this.getStatusInfos().hashCode());
        hashCode = 31 * hashCode + (this.getStorageType() == null ? 0 : this.getStorageType().hashCode());
        hashCode = 31 * hashCode + (this.getTdeCredentialArn() == null ? 0 : this.getTdeCredentialArn().hashCode());
        hashCode = 31 * hashCode + (this.getDbInstancePort() == null ? 0 : this.getDbInstancePort().hashCode());
        hashCode = 31 * hashCode + (this.getDBClusterIdentifier() == null ? 0 : this.getDBClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getStorageEncrypted() == null ? 0 : this.getStorageEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getDbiResourceId() == null ? 0 : this.getDbiResourceId().hashCode());
        hashCode = 31 * hashCode + (this.getCACertificateIdentifier() == null ? 0 : this.getCACertificateIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getDomainMemberships() == null ? 0 : this.getDomainMemberships().hashCode());
        hashCode = 31 * hashCode + (this.getCopyTagsToSnapshot() == null ? 0 : this.getCopyTagsToSnapshot().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoringInterval() == null ? 0 : this.getMonitoringInterval().hashCode());
        hashCode = 31 * hashCode + (this.getEnhancedMonitoringResourceArn() == null ? 0 : this.getEnhancedMonitoringResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoringRoleArn() == null ? 0 : this.getMonitoringRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getPromotionTier() == null ? 0 : this.getPromotionTier().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceArn() == null ? 0 : this.getDBInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getTimezone() == null ? 0 : this.getTimezone().hashCode());
        hashCode = 31 * hashCode + (this.getIAMDatabaseAuthenticationEnabled() == null ? 0 : this.getIAMDatabaseAuthenticationEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getPerformanceInsightsEnabled() == null ? 0 : this.getPerformanceInsightsEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getPerformanceInsightsKMSKeyId() == null ? 0 : this.getPerformanceInsightsKMSKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getPerformanceInsightsRetentionPeriod() == null ? 0 : this.getPerformanceInsightsRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getEnabledCloudwatchLogsExports() == null ? 0 : this.getEnabledCloudwatchLogsExports().hashCode());
        hashCode = 31 * hashCode + (this.getProcessorFeatures() == null ? 0 : this.getProcessorFeatures().hashCode());
        hashCode = 31 * hashCode + (this.getDeletionProtection() == null ? 0 : this.getDeletionProtection().hashCode());
        hashCode = 31 * hashCode + (this.getAssociatedRoles() == null ? 0 : this.getAssociatedRoles().hashCode());
        hashCode = 31 * hashCode + (this.getListenerEndpoint() == null ? 0 : this.getListenerEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getMaxAllocatedStorage() == null ? 0 : this.getMaxAllocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.getTagList() == null ? 0 : this.getTagList().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceAutomatedBackupsReplications() == null ? 0 : this.getDBInstanceAutomatedBackupsReplications().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerOwnedIpEnabled() == null ? 0 : this.getCustomerOwnedIpEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getAwsBackupRecoveryPointArn() == null ? 0 : this.getAwsBackupRecoveryPointArn().hashCode());
        hashCode = 31 * hashCode + (this.getActivityStreamStatus() == null ? 0 : this.getActivityStreamStatus().hashCode());
        hashCode = 31 * hashCode + (this.getActivityStreamKmsKeyId() == null ? 0 : this.getActivityStreamKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getActivityStreamKinesisStreamName() == null ? 0 : this.getActivityStreamKinesisStreamName().hashCode());
        hashCode = 31 * hashCode + (this.getActivityStreamMode() == null ? 0 : this.getActivityStreamMode().hashCode());
        hashCode = 31 * hashCode + (this.getActivityStreamEngineNativeAuditFieldsIncluded() == null ? 0 : this.getActivityStreamEngineNativeAuditFieldsIncluded().hashCode());
        hashCode = 31 * hashCode + (this.getAutomationMode() == null ? 0 : this.getAutomationMode().hashCode());
        hashCode = 31 * hashCode + (this.getResumeFullAutomationModeTime() == null ? 0 : this.getResumeFullAutomationModeTime().hashCode());
        hashCode = 31 * hashCode + (this.getCustomIamInstanceProfile() == null ? 0 : this.getCustomIamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.getBackupTarget() == null ? 0 : this.getBackupTarget().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkType() == null ? 0 : this.getNetworkType().hashCode());
        hashCode = 31 * hashCode + (this.getActivityStreamPolicyStatus() == null ? 0 : this.getActivityStreamPolicyStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStorageThroughput() == null ? 0 : this.getStorageThroughput().hashCode());
        return hashCode;
    }

    public DBInstance clone() {
        try {
            return (DBInstance)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

