/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rdsdata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.rdsdata.model.Record;
import com.amazonaws.services.rdsdata.model.ResultSetMetadata;
import com.amazonaws.services.rdsdata.model.transform.ResultFrameMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ResultFrame
implements Serializable,
Cloneable,
StructuredPojo {
    private ResultSetMetadata resultSetMetadata;
    private List<Record> records;

    public void setResultSetMetadata(ResultSetMetadata resultSetMetadata) {
        this.resultSetMetadata = resultSetMetadata;
    }

    public ResultSetMetadata getResultSetMetadata() {
        return this.resultSetMetadata;
    }

    public ResultFrame withResultSetMetadata(ResultSetMetadata resultSetMetadata) {
        this.setResultSetMetadata(resultSetMetadata);
        return this;
    }

    public List<Record> getRecords() {
        return this.records;
    }

    public void setRecords(Collection<Record> records) {
        if (records == null) {
            this.records = null;
            return;
        }
        this.records = new ArrayList<Record>(records);
    }

    public ResultFrame withRecords(Record ... records) {
        if (this.records == null) {
            this.setRecords(new ArrayList<Record>(records.length));
        }
        for (Record ele : records) {
            this.records.add(ele);
        }
        return this;
    }

    public ResultFrame withRecords(Collection<Record> records) {
        this.setRecords(records);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResultSetMetadata() != null) {
            sb.append("ResultSetMetadata: ").append(this.getResultSetMetadata()).append(",");
        }
        if (this.getRecords() != null) {
            sb.append("Records: ").append(this.getRecords());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultFrame)) {
            return false;
        }
        ResultFrame other = (ResultFrame)obj;
        if (other.getResultSetMetadata() == null ^ this.getResultSetMetadata() == null) {
            return false;
        }
        if (other.getResultSetMetadata() != null && !other.getResultSetMetadata().equals(this.getResultSetMetadata())) {
            return false;
        }
        if (other.getRecords() == null ^ this.getRecords() == null) {
            return false;
        }
        return other.getRecords() == null || other.getRecords().equals(this.getRecords());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResultSetMetadata() == null ? 0 : this.getResultSetMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getRecords() == null ? 0 : this.getRecords().hashCode());
        return hashCode;
    }

    public ResultFrame clone() {
        try {
            return (ResultFrame)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ResultFrameMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

