/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.redshift.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.redshift.model.ClusterIamRole;
import com.amazonaws.services.redshift.model.ClusterNode;
import com.amazonaws.services.redshift.model.ClusterParameterGroupStatus;
import com.amazonaws.services.redshift.model.ClusterSecurityGroupMembership;
import com.amazonaws.services.redshift.model.ClusterSnapshotCopyStatus;
import com.amazonaws.services.redshift.model.ElasticIpStatus;
import com.amazonaws.services.redshift.model.Endpoint;
import com.amazonaws.services.redshift.model.HsmStatus;
import com.amazonaws.services.redshift.model.PendingModifiedValues;
import com.amazonaws.services.redshift.model.RestoreStatus;
import com.amazonaws.services.redshift.model.Tag;
import com.amazonaws.services.redshift.model.VpcSecurityGroupMembership;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Cluster
implements Serializable,
Cloneable {
    private String clusterIdentifier;
    private String nodeType;
    private String clusterStatus;
    private String modifyStatus;
    private String masterUsername;
    private String dBName;
    private Endpoint endpoint;
    private Date clusterCreateTime;
    private Integer automatedSnapshotRetentionPeriod;
    private SdkInternalList<ClusterSecurityGroupMembership> clusterSecurityGroups;
    private SdkInternalList<VpcSecurityGroupMembership> vpcSecurityGroups;
    private SdkInternalList<ClusterParameterGroupStatus> clusterParameterGroups;
    private String clusterSubnetGroupName;
    private String vpcId;
    private String availabilityZone;
    private String preferredMaintenanceWindow;
    private PendingModifiedValues pendingModifiedValues;
    private String clusterVersion;
    private Boolean allowVersionUpgrade;
    private Integer numberOfNodes;
    private Boolean publiclyAccessible;
    private Boolean encrypted;
    private RestoreStatus restoreStatus;
    private HsmStatus hsmStatus;
    private ClusterSnapshotCopyStatus clusterSnapshotCopyStatus;
    private String clusterPublicKey;
    private SdkInternalList<ClusterNode> clusterNodes;
    private ElasticIpStatus elasticIpStatus;
    private String clusterRevisionNumber;
    private SdkInternalList<Tag> tags;
    private String kmsKeyId;
    private Boolean enhancedVpcRouting;
    private SdkInternalList<ClusterIamRole> iamRoles;

    public void setClusterIdentifier(String clusterIdentifier) {
        this.clusterIdentifier = clusterIdentifier;
    }

    public String getClusterIdentifier() {
        return this.clusterIdentifier;
    }

    public Cluster withClusterIdentifier(String clusterIdentifier) {
        this.setClusterIdentifier(clusterIdentifier);
        return this;
    }

    public void setNodeType(String nodeType) {
        this.nodeType = nodeType;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public Cluster withNodeType(String nodeType) {
        this.setNodeType(nodeType);
        return this;
    }

    public void setClusterStatus(String clusterStatus) {
        this.clusterStatus = clusterStatus;
    }

    public String getClusterStatus() {
        return this.clusterStatus;
    }

    public Cluster withClusterStatus(String clusterStatus) {
        this.setClusterStatus(clusterStatus);
        return this;
    }

    public void setModifyStatus(String modifyStatus) {
        this.modifyStatus = modifyStatus;
    }

    public String getModifyStatus() {
        return this.modifyStatus;
    }

    public Cluster withModifyStatus(String modifyStatus) {
        this.setModifyStatus(modifyStatus);
        return this;
    }

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    public String getMasterUsername() {
        return this.masterUsername;
    }

    public Cluster withMasterUsername(String masterUsername) {
        this.setMasterUsername(masterUsername);
        return this;
    }

    public void setDBName(String dBName) {
        this.dBName = dBName;
    }

    public String getDBName() {
        return this.dBName;
    }

    public Cluster withDBName(String dBName) {
        this.setDBName(dBName);
        return this;
    }

    public void setEndpoint(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Cluster withEndpoint(Endpoint endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    public void setClusterCreateTime(Date clusterCreateTime) {
        this.clusterCreateTime = clusterCreateTime;
    }

    public Date getClusterCreateTime() {
        return this.clusterCreateTime;
    }

    public Cluster withClusterCreateTime(Date clusterCreateTime) {
        this.setClusterCreateTime(clusterCreateTime);
        return this;
    }

    public void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
        this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
    }

    public Integer getAutomatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public Cluster withAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
        this.setAutomatedSnapshotRetentionPeriod(automatedSnapshotRetentionPeriod);
        return this;
    }

    public List<ClusterSecurityGroupMembership> getClusterSecurityGroups() {
        if (this.clusterSecurityGroups == null) {
            this.clusterSecurityGroups = new SdkInternalList();
        }
        return this.clusterSecurityGroups;
    }

    public void setClusterSecurityGroups(Collection<ClusterSecurityGroupMembership> clusterSecurityGroups) {
        if (clusterSecurityGroups == null) {
            this.clusterSecurityGroups = null;
            return;
        }
        this.clusterSecurityGroups = new SdkInternalList(clusterSecurityGroups);
    }

    public Cluster withClusterSecurityGroups(ClusterSecurityGroupMembership ... clusterSecurityGroups) {
        if (this.clusterSecurityGroups == null) {
            this.setClusterSecurityGroups((Collection<ClusterSecurityGroupMembership>)new SdkInternalList(clusterSecurityGroups.length));
        }
        for (ClusterSecurityGroupMembership ele : clusterSecurityGroups) {
            this.clusterSecurityGroups.add((Object)ele);
        }
        return this;
    }

    public Cluster withClusterSecurityGroups(Collection<ClusterSecurityGroupMembership> clusterSecurityGroups) {
        this.setClusterSecurityGroups(clusterSecurityGroups);
        return this;
    }

    public List<VpcSecurityGroupMembership> getVpcSecurityGroups() {
        if (this.vpcSecurityGroups == null) {
            this.vpcSecurityGroups = new SdkInternalList();
        }
        return this.vpcSecurityGroups;
    }

    public void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        if (vpcSecurityGroups == null) {
            this.vpcSecurityGroups = null;
            return;
        }
        this.vpcSecurityGroups = new SdkInternalList(vpcSecurityGroups);
    }

    public Cluster withVpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
        if (this.vpcSecurityGroups == null) {
            this.setVpcSecurityGroups((Collection<VpcSecurityGroupMembership>)new SdkInternalList(vpcSecurityGroups.length));
        }
        for (VpcSecurityGroupMembership ele : vpcSecurityGroups) {
            this.vpcSecurityGroups.add((Object)ele);
        }
        return this;
    }

    public Cluster withVpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
        this.setVpcSecurityGroups(vpcSecurityGroups);
        return this;
    }

    public List<ClusterParameterGroupStatus> getClusterParameterGroups() {
        if (this.clusterParameterGroups == null) {
            this.clusterParameterGroups = new SdkInternalList();
        }
        return this.clusterParameterGroups;
    }

    public void setClusterParameterGroups(Collection<ClusterParameterGroupStatus> clusterParameterGroups) {
        if (clusterParameterGroups == null) {
            this.clusterParameterGroups = null;
            return;
        }
        this.clusterParameterGroups = new SdkInternalList(clusterParameterGroups);
    }

    public Cluster withClusterParameterGroups(ClusterParameterGroupStatus ... clusterParameterGroups) {
        if (this.clusterParameterGroups == null) {
            this.setClusterParameterGroups((Collection<ClusterParameterGroupStatus>)new SdkInternalList(clusterParameterGroups.length));
        }
        for (ClusterParameterGroupStatus ele : clusterParameterGroups) {
            this.clusterParameterGroups.add((Object)ele);
        }
        return this;
    }

    public Cluster withClusterParameterGroups(Collection<ClusterParameterGroupStatus> clusterParameterGroups) {
        this.setClusterParameterGroups(clusterParameterGroups);
        return this;
    }

    public void setClusterSubnetGroupName(String clusterSubnetGroupName) {
        this.clusterSubnetGroupName = clusterSubnetGroupName;
    }

    public String getClusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public Cluster withClusterSubnetGroupName(String clusterSubnetGroupName) {
        this.setClusterSubnetGroupName(clusterSubnetGroupName);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public Cluster withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Cluster withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public Cluster withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.setPreferredMaintenanceWindow(preferredMaintenanceWindow);
        return this;
    }

    public void setPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.pendingModifiedValues = pendingModifiedValues;
    }

    public PendingModifiedValues getPendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public Cluster withPendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
        this.setPendingModifiedValues(pendingModifiedValues);
        return this;
    }

    public void setClusterVersion(String clusterVersion) {
        this.clusterVersion = clusterVersion;
    }

    public String getClusterVersion() {
        return this.clusterVersion;
    }

    public Cluster withClusterVersion(String clusterVersion) {
        this.setClusterVersion(clusterVersion);
        return this;
    }

    public void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
        this.allowVersionUpgrade = allowVersionUpgrade;
    }

    public Boolean getAllowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public Cluster withAllowVersionUpgrade(Boolean allowVersionUpgrade) {
        this.setAllowVersionUpgrade(allowVersionUpgrade);
        return this;
    }

    public Boolean isAllowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public void setNumberOfNodes(Integer numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
    }

    public Integer getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public Cluster withNumberOfNodes(Integer numberOfNodes) {
        this.setNumberOfNodes(numberOfNodes);
        return this;
    }

    public void setPubliclyAccessible(Boolean publiclyAccessible) {
        this.publiclyAccessible = publiclyAccessible;
    }

    public Boolean getPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public Cluster withPubliclyAccessible(Boolean publiclyAccessible) {
        this.setPubliclyAccessible(publiclyAccessible);
        return this;
    }

    public Boolean isPubliclyAccessible() {
        return this.publiclyAccessible;
    }

    public void setEncrypted(Boolean encrypted) {
        this.encrypted = encrypted;
    }

    public Boolean getEncrypted() {
        return this.encrypted;
    }

    public Cluster withEncrypted(Boolean encrypted) {
        this.setEncrypted(encrypted);
        return this;
    }

    public Boolean isEncrypted() {
        return this.encrypted;
    }

    public void setRestoreStatus(RestoreStatus restoreStatus) {
        this.restoreStatus = restoreStatus;
    }

    public RestoreStatus getRestoreStatus() {
        return this.restoreStatus;
    }

    public Cluster withRestoreStatus(RestoreStatus restoreStatus) {
        this.setRestoreStatus(restoreStatus);
        return this;
    }

    public void setHsmStatus(HsmStatus hsmStatus) {
        this.hsmStatus = hsmStatus;
    }

    public HsmStatus getHsmStatus() {
        return this.hsmStatus;
    }

    public Cluster withHsmStatus(HsmStatus hsmStatus) {
        this.setHsmStatus(hsmStatus);
        return this;
    }

    public void setClusterSnapshotCopyStatus(ClusterSnapshotCopyStatus clusterSnapshotCopyStatus) {
        this.clusterSnapshotCopyStatus = clusterSnapshotCopyStatus;
    }

    public ClusterSnapshotCopyStatus getClusterSnapshotCopyStatus() {
        return this.clusterSnapshotCopyStatus;
    }

    public Cluster withClusterSnapshotCopyStatus(ClusterSnapshotCopyStatus clusterSnapshotCopyStatus) {
        this.setClusterSnapshotCopyStatus(clusterSnapshotCopyStatus);
        return this;
    }

    public void setClusterPublicKey(String clusterPublicKey) {
        this.clusterPublicKey = clusterPublicKey;
    }

    public String getClusterPublicKey() {
        return this.clusterPublicKey;
    }

    public Cluster withClusterPublicKey(String clusterPublicKey) {
        this.setClusterPublicKey(clusterPublicKey);
        return this;
    }

    public List<ClusterNode> getClusterNodes() {
        if (this.clusterNodes == null) {
            this.clusterNodes = new SdkInternalList();
        }
        return this.clusterNodes;
    }

    public void setClusterNodes(Collection<ClusterNode> clusterNodes) {
        if (clusterNodes == null) {
            this.clusterNodes = null;
            return;
        }
        this.clusterNodes = new SdkInternalList(clusterNodes);
    }

    public Cluster withClusterNodes(ClusterNode ... clusterNodes) {
        if (this.clusterNodes == null) {
            this.setClusterNodes((Collection<ClusterNode>)new SdkInternalList(clusterNodes.length));
        }
        for (ClusterNode ele : clusterNodes) {
            this.clusterNodes.add((Object)ele);
        }
        return this;
    }

    public Cluster withClusterNodes(Collection<ClusterNode> clusterNodes) {
        this.setClusterNodes(clusterNodes);
        return this;
    }

    public void setElasticIpStatus(ElasticIpStatus elasticIpStatus) {
        this.elasticIpStatus = elasticIpStatus;
    }

    public ElasticIpStatus getElasticIpStatus() {
        return this.elasticIpStatus;
    }

    public Cluster withElasticIpStatus(ElasticIpStatus elasticIpStatus) {
        this.setElasticIpStatus(elasticIpStatus);
        return this;
    }

    public void setClusterRevisionNumber(String clusterRevisionNumber) {
        this.clusterRevisionNumber = clusterRevisionNumber;
    }

    public String getClusterRevisionNumber() {
        return this.clusterRevisionNumber;
    }

    public Cluster withClusterRevisionNumber(String clusterRevisionNumber) {
        this.setClusterRevisionNumber(clusterRevisionNumber);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public Cluster withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public Cluster withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public Cluster withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
        this.enhancedVpcRouting = enhancedVpcRouting;
    }

    public Boolean getEnhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public Cluster withEnhancedVpcRouting(Boolean enhancedVpcRouting) {
        this.setEnhancedVpcRouting(enhancedVpcRouting);
        return this;
    }

    public Boolean isEnhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public List<ClusterIamRole> getIamRoles() {
        if (this.iamRoles == null) {
            this.iamRoles = new SdkInternalList();
        }
        return this.iamRoles;
    }

    public void setIamRoles(Collection<ClusterIamRole> iamRoles) {
        if (iamRoles == null) {
            this.iamRoles = null;
            return;
        }
        this.iamRoles = new SdkInternalList(iamRoles);
    }

    public Cluster withIamRoles(ClusterIamRole ... iamRoles) {
        if (this.iamRoles == null) {
            this.setIamRoles((Collection<ClusterIamRole>)new SdkInternalList(iamRoles.length));
        }
        for (ClusterIamRole ele : iamRoles) {
            this.iamRoles.add((Object)ele);
        }
        return this;
    }

    public Cluster withIamRoles(Collection<ClusterIamRole> iamRoles) {
        this.setIamRoles(iamRoles);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.getClusterIdentifier()).append(",");
        }
        if (this.getNodeType() != null) {
            sb.append("NodeType: ").append(this.getNodeType()).append(",");
        }
        if (this.getClusterStatus() != null) {
            sb.append("ClusterStatus: ").append(this.getClusterStatus()).append(",");
        }
        if (this.getModifyStatus() != null) {
            sb.append("ModifyStatus: ").append(this.getModifyStatus()).append(",");
        }
        if (this.getMasterUsername() != null) {
            sb.append("MasterUsername: ").append(this.getMasterUsername()).append(",");
        }
        if (this.getDBName() != null) {
            sb.append("DBName: ").append(this.getDBName()).append(",");
        }
        if (this.getEndpoint() != null) {
            sb.append("Endpoint: ").append(this.getEndpoint()).append(",");
        }
        if (this.getClusterCreateTime() != null) {
            sb.append("ClusterCreateTime: ").append(this.getClusterCreateTime()).append(",");
        }
        if (this.getAutomatedSnapshotRetentionPeriod() != null) {
            sb.append("AutomatedSnapshotRetentionPeriod: ").append(this.getAutomatedSnapshotRetentionPeriod()).append(",");
        }
        if (this.getClusterSecurityGroups() != null) {
            sb.append("ClusterSecurityGroups: ").append(this.getClusterSecurityGroups()).append(",");
        }
        if (this.getVpcSecurityGroups() != null) {
            sb.append("VpcSecurityGroups: ").append(this.getVpcSecurityGroups()).append(",");
        }
        if (this.getClusterParameterGroups() != null) {
            sb.append("ClusterParameterGroups: ").append(this.getClusterParameterGroups()).append(",");
        }
        if (this.getClusterSubnetGroupName() != null) {
            sb.append("ClusterSubnetGroupName: ").append(this.getClusterSubnetGroupName()).append(",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: ").append(this.getVpcId()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getPreferredMaintenanceWindow() != null) {
            sb.append("PreferredMaintenanceWindow: ").append(this.getPreferredMaintenanceWindow()).append(",");
        }
        if (this.getPendingModifiedValues() != null) {
            sb.append("PendingModifiedValues: ").append(this.getPendingModifiedValues()).append(",");
        }
        if (this.getClusterVersion() != null) {
            sb.append("ClusterVersion: ").append(this.getClusterVersion()).append(",");
        }
        if (this.getAllowVersionUpgrade() != null) {
            sb.append("AllowVersionUpgrade: ").append(this.getAllowVersionUpgrade()).append(",");
        }
        if (this.getNumberOfNodes() != null) {
            sb.append("NumberOfNodes: ").append(this.getNumberOfNodes()).append(",");
        }
        if (this.getPubliclyAccessible() != null) {
            sb.append("PubliclyAccessible: ").append(this.getPubliclyAccessible()).append(",");
        }
        if (this.getEncrypted() != null) {
            sb.append("Encrypted: ").append(this.getEncrypted()).append(",");
        }
        if (this.getRestoreStatus() != null) {
            sb.append("RestoreStatus: ").append(this.getRestoreStatus()).append(",");
        }
        if (this.getHsmStatus() != null) {
            sb.append("HsmStatus: ").append(this.getHsmStatus()).append(",");
        }
        if (this.getClusterSnapshotCopyStatus() != null) {
            sb.append("ClusterSnapshotCopyStatus: ").append(this.getClusterSnapshotCopyStatus()).append(",");
        }
        if (this.getClusterPublicKey() != null) {
            sb.append("ClusterPublicKey: ").append(this.getClusterPublicKey()).append(",");
        }
        if (this.getClusterNodes() != null) {
            sb.append("ClusterNodes: ").append(this.getClusterNodes()).append(",");
        }
        if (this.getElasticIpStatus() != null) {
            sb.append("ElasticIpStatus: ").append(this.getElasticIpStatus()).append(",");
        }
        if (this.getClusterRevisionNumber() != null) {
            sb.append("ClusterRevisionNumber: ").append(this.getClusterRevisionNumber()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getEnhancedVpcRouting() != null) {
            sb.append("EnhancedVpcRouting: ").append(this.getEnhancedVpcRouting()).append(",");
        }
        if (this.getIamRoles() != null) {
            sb.append("IamRoles: ").append(this.getIamRoles());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (other.getClusterIdentifier() == null ^ this.getClusterIdentifier() == null) {
            return false;
        }
        if (other.getClusterIdentifier() != null && !other.getClusterIdentifier().equals(this.getClusterIdentifier())) {
            return false;
        }
        if (other.getNodeType() == null ^ this.getNodeType() == null) {
            return false;
        }
        if (other.getNodeType() != null && !other.getNodeType().equals(this.getNodeType())) {
            return false;
        }
        if (other.getClusterStatus() == null ^ this.getClusterStatus() == null) {
            return false;
        }
        if (other.getClusterStatus() != null && !other.getClusterStatus().equals(this.getClusterStatus())) {
            return false;
        }
        if (other.getModifyStatus() == null ^ this.getModifyStatus() == null) {
            return false;
        }
        if (other.getModifyStatus() != null && !other.getModifyStatus().equals(this.getModifyStatus())) {
            return false;
        }
        if (other.getMasterUsername() == null ^ this.getMasterUsername() == null) {
            return false;
        }
        if (other.getMasterUsername() != null && !other.getMasterUsername().equals(this.getMasterUsername())) {
            return false;
        }
        if (other.getDBName() == null ^ this.getDBName() == null) {
            return false;
        }
        if (other.getDBName() != null && !other.getDBName().equals(this.getDBName())) {
            return false;
        }
        if (other.getEndpoint() == null ^ this.getEndpoint() == null) {
            return false;
        }
        if (other.getEndpoint() != null && !other.getEndpoint().equals(this.getEndpoint())) {
            return false;
        }
        if (other.getClusterCreateTime() == null ^ this.getClusterCreateTime() == null) {
            return false;
        }
        if (other.getClusterCreateTime() != null && !other.getClusterCreateTime().equals(this.getClusterCreateTime())) {
            return false;
        }
        if (other.getAutomatedSnapshotRetentionPeriod() == null ^ this.getAutomatedSnapshotRetentionPeriod() == null) {
            return false;
        }
        if (other.getAutomatedSnapshotRetentionPeriod() != null && !other.getAutomatedSnapshotRetentionPeriod().equals(this.getAutomatedSnapshotRetentionPeriod())) {
            return false;
        }
        if (other.getClusterSecurityGroups() == null ^ this.getClusterSecurityGroups() == null) {
            return false;
        }
        if (other.getClusterSecurityGroups() != null && !other.getClusterSecurityGroups().equals(this.getClusterSecurityGroups())) {
            return false;
        }
        if (other.getVpcSecurityGroups() == null ^ this.getVpcSecurityGroups() == null) {
            return false;
        }
        if (other.getVpcSecurityGroups() != null && !other.getVpcSecurityGroups().equals(this.getVpcSecurityGroups())) {
            return false;
        }
        if (other.getClusterParameterGroups() == null ^ this.getClusterParameterGroups() == null) {
            return false;
        }
        if (other.getClusterParameterGroups() != null && !other.getClusterParameterGroups().equals(this.getClusterParameterGroups())) {
            return false;
        }
        if (other.getClusterSubnetGroupName() == null ^ this.getClusterSubnetGroupName() == null) {
            return false;
        }
        if (other.getClusterSubnetGroupName() != null && !other.getClusterSubnetGroupName().equals(this.getClusterSubnetGroupName())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getPendingModifiedValues() == null ^ this.getPendingModifiedValues() == null) {
            return false;
        }
        if (other.getPendingModifiedValues() != null && !other.getPendingModifiedValues().equals(this.getPendingModifiedValues())) {
            return false;
        }
        if (other.getClusterVersion() == null ^ this.getClusterVersion() == null) {
            return false;
        }
        if (other.getClusterVersion() != null && !other.getClusterVersion().equals(this.getClusterVersion())) {
            return false;
        }
        if (other.getAllowVersionUpgrade() == null ^ this.getAllowVersionUpgrade() == null) {
            return false;
        }
        if (other.getAllowVersionUpgrade() != null && !other.getAllowVersionUpgrade().equals(this.getAllowVersionUpgrade())) {
            return false;
        }
        if (other.getNumberOfNodes() == null ^ this.getNumberOfNodes() == null) {
            return false;
        }
        if (other.getNumberOfNodes() != null && !other.getNumberOfNodes().equals(this.getNumberOfNodes())) {
            return false;
        }
        if (other.getPubliclyAccessible() == null ^ this.getPubliclyAccessible() == null) {
            return false;
        }
        if (other.getPubliclyAccessible() != null && !other.getPubliclyAccessible().equals(this.getPubliclyAccessible())) {
            return false;
        }
        if (other.getEncrypted() == null ^ this.getEncrypted() == null) {
            return false;
        }
        if (other.getEncrypted() != null && !other.getEncrypted().equals(this.getEncrypted())) {
            return false;
        }
        if (other.getRestoreStatus() == null ^ this.getRestoreStatus() == null) {
            return false;
        }
        if (other.getRestoreStatus() != null && !other.getRestoreStatus().equals(this.getRestoreStatus())) {
            return false;
        }
        if (other.getHsmStatus() == null ^ this.getHsmStatus() == null) {
            return false;
        }
        if (other.getHsmStatus() != null && !other.getHsmStatus().equals(this.getHsmStatus())) {
            return false;
        }
        if (other.getClusterSnapshotCopyStatus() == null ^ this.getClusterSnapshotCopyStatus() == null) {
            return false;
        }
        if (other.getClusterSnapshotCopyStatus() != null && !other.getClusterSnapshotCopyStatus().equals(this.getClusterSnapshotCopyStatus())) {
            return false;
        }
        if (other.getClusterPublicKey() == null ^ this.getClusterPublicKey() == null) {
            return false;
        }
        if (other.getClusterPublicKey() != null && !other.getClusterPublicKey().equals(this.getClusterPublicKey())) {
            return false;
        }
        if (other.getClusterNodes() == null ^ this.getClusterNodes() == null) {
            return false;
        }
        if (other.getClusterNodes() != null && !other.getClusterNodes().equals(this.getClusterNodes())) {
            return false;
        }
        if (other.getElasticIpStatus() == null ^ this.getElasticIpStatus() == null) {
            return false;
        }
        if (other.getElasticIpStatus() != null && !other.getElasticIpStatus().equals(this.getElasticIpStatus())) {
            return false;
        }
        if (other.getClusterRevisionNumber() == null ^ this.getClusterRevisionNumber() == null) {
            return false;
        }
        if (other.getClusterRevisionNumber() != null && !other.getClusterRevisionNumber().equals(this.getClusterRevisionNumber())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getEnhancedVpcRouting() == null ^ this.getEnhancedVpcRouting() == null) {
            return false;
        }
        if (other.getEnhancedVpcRouting() != null && !other.getEnhancedVpcRouting().equals(this.getEnhancedVpcRouting())) {
            return false;
        }
        if (other.getIamRoles() == null ^ this.getIamRoles() == null) {
            return false;
        }
        return other.getIamRoles() == null || other.getIamRoles().equals(this.getIamRoles());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterIdentifier() == null ? 0 : this.getClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getNodeType() == null ? 0 : this.getNodeType().hashCode());
        hashCode = 31 * hashCode + (this.getClusterStatus() == null ? 0 : this.getClusterStatus().hashCode());
        hashCode = 31 * hashCode + (this.getModifyStatus() == null ? 0 : this.getModifyStatus().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUsername() == null ? 0 : this.getMasterUsername().hashCode());
        hashCode = 31 * hashCode + (this.getDBName() == null ? 0 : this.getDBName().hashCode());
        hashCode = 31 * hashCode + (this.getEndpoint() == null ? 0 : this.getEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getClusterCreateTime() == null ? 0 : this.getClusterCreateTime().hashCode());
        hashCode = 31 * hashCode + (this.getAutomatedSnapshotRetentionPeriod() == null ? 0 : this.getAutomatedSnapshotRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getClusterSecurityGroups() == null ? 0 : this.getClusterSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroups() == null ? 0 : this.getVpcSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getClusterParameterGroups() == null ? 0 : this.getClusterParameterGroups().hashCode());
        hashCode = 31 * hashCode + (this.getClusterSubnetGroupName() == null ? 0 : this.getClusterSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPendingModifiedValues() == null ? 0 : this.getPendingModifiedValues().hashCode());
        hashCode = 31 * hashCode + (this.getClusterVersion() == null ? 0 : this.getClusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.getAllowVersionUpgrade() == null ? 0 : this.getAllowVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfNodes() == null ? 0 : this.getNumberOfNodes().hashCode());
        hashCode = 31 * hashCode + (this.getPubliclyAccessible() == null ? 0 : this.getPubliclyAccessible().hashCode());
        hashCode = 31 * hashCode + (this.getEncrypted() == null ? 0 : this.getEncrypted().hashCode());
        hashCode = 31 * hashCode + (this.getRestoreStatus() == null ? 0 : this.getRestoreStatus().hashCode());
        hashCode = 31 * hashCode + (this.getHsmStatus() == null ? 0 : this.getHsmStatus().hashCode());
        hashCode = 31 * hashCode + (this.getClusterSnapshotCopyStatus() == null ? 0 : this.getClusterSnapshotCopyStatus().hashCode());
        hashCode = 31 * hashCode + (this.getClusterPublicKey() == null ? 0 : this.getClusterPublicKey().hashCode());
        hashCode = 31 * hashCode + (this.getClusterNodes() == null ? 0 : this.getClusterNodes().hashCode());
        hashCode = 31 * hashCode + (this.getElasticIpStatus() == null ? 0 : this.getElasticIpStatus().hashCode());
        hashCode = 31 * hashCode + (this.getClusterRevisionNumber() == null ? 0 : this.getClusterRevisionNumber().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getEnhancedVpcRouting() == null ? 0 : this.getEnhancedVpcRouting().hashCode());
        hashCode = 31 * hashCode + (this.getIamRoles() == null ? 0 : this.getIamRoles().hashCode());
        return hashCode;
    }

    public Cluster clone() {
        try {
            return (Cluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

