/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.resourcegroupstaggingapi.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UntagResourcesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> resourceARNList;
    private List<String> tagKeys;

    public List<String> getResourceARNList() {
        return this.resourceARNList;
    }

    public void setResourceARNList(Collection<String> resourceARNList) {
        if (resourceARNList == null) {
            this.resourceARNList = null;
            return;
        }
        this.resourceARNList = new ArrayList<String>(resourceARNList);
    }

    public UntagResourcesRequest withResourceARNList(String ... resourceARNList) {
        if (this.resourceARNList == null) {
            this.setResourceARNList(new ArrayList<String>(resourceARNList.length));
        }
        for (String ele : resourceARNList) {
            this.resourceARNList.add(ele);
        }
        return this;
    }

    public UntagResourcesRequest withResourceARNList(Collection<String> resourceARNList) {
        this.setResourceARNList(resourceARNList);
        return this;
    }

    public List<String> getTagKeys() {
        return this.tagKeys;
    }

    public void setTagKeys(Collection<String> tagKeys) {
        if (tagKeys == null) {
            this.tagKeys = null;
            return;
        }
        this.tagKeys = new ArrayList<String>(tagKeys);
    }

    public UntagResourcesRequest withTagKeys(String ... tagKeys) {
        if (this.tagKeys == null) {
            this.setTagKeys(new ArrayList<String>(tagKeys.length));
        }
        for (String ele : tagKeys) {
            this.tagKeys.add(ele);
        }
        return this;
    }

    public UntagResourcesRequest withTagKeys(Collection<String> tagKeys) {
        this.setTagKeys(tagKeys);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceARNList() != null) {
            sb.append("ResourceARNList: ").append(this.getResourceARNList()).append(",");
        }
        if (this.getTagKeys() != null) {
            sb.append("TagKeys: ").append(this.getTagKeys());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UntagResourcesRequest)) {
            return false;
        }
        UntagResourcesRequest other = (UntagResourcesRequest)obj;
        if (other.getResourceARNList() == null ^ this.getResourceARNList() == null) {
            return false;
        }
        if (other.getResourceARNList() != null && !other.getResourceARNList().equals(this.getResourceARNList())) {
            return false;
        }
        if (other.getTagKeys() == null ^ this.getTagKeys() == null) {
            return false;
        }
        return other.getTagKeys() == null || other.getTagKeys().equals(this.getTagKeys());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceARNList() == null ? 0 : this.getResourceARNList().hashCode());
        hashCode = 31 * hashCode + (this.getTagKeys() == null ? 0 : this.getTagKeys().hashCode());
        return hashCode;
    }

    public UntagResourcesRequest clone() {
        return (UntagResourcesRequest)super.clone();
    }
}

