/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.securityhub.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.securityhub.model.Product;
import java.util.List;

@SdkInternalApi
public class ProductMarshaller {
    private static final MarshallingInfo<String> PRODUCTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductArn").build();
    private static final MarshallingInfo<String> PRODUCTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductName").build();
    private static final MarshallingInfo<String> COMPANYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompanyName").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Description").build();
    private static final MarshallingInfo<List> CATEGORIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Categories").build();
    private static final MarshallingInfo<List> INTEGRATIONTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IntegrationTypes").build();
    private static final MarshallingInfo<String> MARKETPLACEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MarketplaceUrl").build();
    private static final MarshallingInfo<String> ACTIVATIONURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ActivationUrl").build();
    private static final MarshallingInfo<String> PRODUCTSUBSCRIPTIONRESOURCEPOLICY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProductSubscriptionResourcePolicy").build();
    private static final ProductMarshaller instance = new ProductMarshaller();

    public static ProductMarshaller getInstance() {
        return instance;
    }

    public void marshall(Product product, ProtocolMarshaller protocolMarshaller) {
        if (product == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)product.getProductArn(), PRODUCTARN_BINDING);
            protocolMarshaller.marshall((Object)product.getProductName(), PRODUCTNAME_BINDING);
            protocolMarshaller.marshall((Object)product.getCompanyName(), COMPANYNAME_BINDING);
            protocolMarshaller.marshall((Object)product.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(product.getCategories(), CATEGORIES_BINDING);
            protocolMarshaller.marshall(product.getIntegrationTypes(), INTEGRATIONTYPES_BINDING);
            protocolMarshaller.marshall((Object)product.getMarketplaceUrl(), MARKETPLACEURL_BINDING);
            protocolMarshaller.marshall((Object)product.getActivationUrl(), ACTIVATIONURL_BINDING);
            protocolMarshaller.marshall((Object)product.getProductSubscriptionResourcePolicy(), PRODUCTSUBSCRIPTIONRESOURCEPOLICY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

